/*
 * Decompiled with CFR 0.152.
 */
package phex.msg.vendor;

import phex.common.address.AddressUtils;
import phex.common.address.DefaultDestAddress;
import phex.common.address.DestAddress;
import phex.common.address.IpAddress;
import phex.msg.InvalidMessageException;
import phex.msg.MsgHeader;
import phex.msg.vendor.VendorMsg;
import phex.utils.IOUtil;

public class TCPConnectBackRedirectVMsg
extends VendorMsg {
    public static final int VERSION = 1;
    private DestAddress hostAddress;

    public TCPConnectBackRedirectVMsg(MsgHeader header, byte[] vendorId, int subSelector, int version, byte[] data) throws InvalidMessageException {
        super(header, vendorId, subSelector, version, data);
        if (version > 1) {
            throw new InvalidMessageException("Vendor Message 'TCPConnectBackRedirect' with invalid version: " + version);
        }
        if (data.length != 6) {
            throw new InvalidMessageException("Vendor Message 'TCPConnectBackRedirect' invalid data length: " + data.length);
        }
        byte[] ip = new byte[]{data[0], data[1], data[2], data[3]};
        int port = IOUtil.unsignedShort2Int(IOUtil.deserializeShortLE(data, 4));
        if (!AddressUtils.isPortInRange(port)) {
            throw new InvalidMessageException("Port out of range: " + port);
        }
        this.hostAddress = new DefaultDestAddress(ip, port);
        if (!this.hostAddress.isValidAddress()) {
            throw new InvalidMessageException("Invalid host address.");
        }
    }

    public TCPConnectBackRedirectVMsg(DestAddress hostAddress) {
        super(VENDORID_LIME, 7, 1, TCPConnectBackRedirectVMsg.buildDataBody(hostAddress));
        this.hostAddress = hostAddress;
    }

    public DestAddress getAddress() {
        return this.hostAddress;
    }

    private static byte[] buildDataBody(DestAddress hostAddress) {
        byte[] data = new byte[6];
        IpAddress ip = hostAddress.getIpAddress();
        if (ip == null) {
            throw new IllegalArgumentException("Vendor Message 'TCPConnectBackRedirect' contains no IP.");
        }
        byte[] ipAddress = hostAddress.getIpAddress().getHostIP();
        data[0] = ipAddress[0];
        data[1] = ipAddress[1];
        data[2] = ipAddress[2];
        data[3] = ipAddress[3];
        IOUtil.serializeShortLE((short)hostAddress.getPort(), data, 4);
        return data;
    }
}

