/*
 * Decompiled with CFR 0.152.
 */
package phex.msg;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import phex.common.URN;
import phex.common.address.DefaultDestAddress;
import phex.common.address.DestAddress;
import phex.common.address.IpAddress;
import phex.io.buffer.ByteBuffer;
import phex.msg.GGEPBlock;
import phex.msg.GGEPExtension;
import phex.msg.GUID;
import phex.msg.HUGEBlock;
import phex.msg.Message;
import phex.msg.MsgHeader;
import phex.prefs.core.MessagePrefs;
import phex.servent.Servent;
import phex.utils.IOUtil;
import phex.utils.StringUtils;

public class QueryMsg
extends Message {
    private static final Logger logger = LoggerFactory.getLogger(QueryMsg.class);
    private static final int MINSPEED_BITBASED_BIT = 15;
    private static final int MINSPEED_FIREWALL_BIT = 14;
    private static final int MINSPEED_XML_BIT = 13;
    public static final int NO_FEATURE_QUERY_SELECTOR = 0;
    public static final int WHAT_IS_NEW_FEATURE_QUERY_SELECTOR = 1;
    private boolean minSpeedIsBitBased;
    private boolean requesterIsFirewalled;
    private boolean requesterIsXmlResultsCapable;
    private boolean requestSecureOOBReplies;
    private String searchString;
    private int featureQuerySelector;
    private byte[] body;
    private boolean isParsed;
    private Set<URN> queryURNSet;
    private byte[] originIpAddress;
    private int originPort;

    public QueryMsg(GUID guid, byte ttl, String aSearchString, URN queryURN, boolean isRequesterCapableOfXmlResults, boolean isRequesterBehindFirewall, boolean isOOBReplyAllowed, int featureQuerySelector) {
        super(new MsgHeader(guid, -128, ttl, 0));
        this.searchString = aSearchString;
        this.featureQuerySelector = featureQuerySelector;
        if (StringUtils.isEmpty(this.searchString)) {
            this.searchString = "\\";
        }
        if (queryURN != null) {
            this.queryURNSet = new HashSet<URN>(1);
            this.queryURNSet.add(queryURN);
        } else {
            this.queryURNSet = Collections.emptySet();
        }
        this.minSpeedIsBitBased = true;
        this.requesterIsFirewalled = isRequesterBehindFirewall;
        this.requesterIsXmlResultsCapable = isRequesterCapableOfXmlResults;
        this.requestSecureOOBReplies = isOOBReplyAllowed;
        try {
            this.buildBody();
        }
        catch (IOException e) {
            logger.error(e.toString(), (Throwable)e);
        }
        this.getHeader().setDataLength(this.body.length);
    }

    public QueryMsg(MsgHeader header, byte[] aBody) {
        super(header);
        this.getHeader().setPayloadType((byte)-128);
        this.body = aBody;
        this.requestSecureOOBReplies = false;
        this.parseBody();
    }

    public QueryMsg(QueryMsg query, byte ttl) {
        super(new MsgHeader(-128, 0));
        this.getHeader().copy(query.getHeader());
        this.getHeader().setTTL(ttl);
        this.body = query.body;
        this.searchString = query.searchString;
        this.featureQuerySelector = query.featureQuerySelector;
        this.minSpeedIsBitBased = query.minSpeedIsBitBased;
        this.requesterIsFirewalled = query.requesterIsFirewalled;
        this.requesterIsXmlResultsCapable = query.requesterIsXmlResultsCapable;
        this.requestSecureOOBReplies = query.requestSecureOOBReplies;
        this.isParsed = query.isParsed;
        this.queryURNSet = new HashSet<URN>(query.queryURNSet);
    }

    private boolean isMinSpeedBitBased() {
        return this.minSpeedIsBitBased;
    }

    public boolean isRequesterFirewalled() {
        return this.minSpeedIsBitBased && this.requesterIsFirewalled;
    }

    public boolean isRequesterXmlResultsCapable() {
        return this.minSpeedIsBitBased && this.requesterIsXmlResultsCapable;
    }

    private void setMinSpeedIsBitBased(boolean newValue) {
        this.minSpeedIsBitBased = newValue;
    }

    private void setRequesterIsFirewalled(boolean newValue) {
        this.requesterIsFirewalled = newValue;
    }

    private void setRequesterIsXmlResultsCapable(boolean newValue) {
        this.requesterIsXmlResultsCapable = newValue;
    }

    private static boolean isBitSet(short shortIn, int bitPos) {
        int bitValue = 1 << bitPos;
        return (shortIn & bitValue) != 0;
    }

    private static short setBit(short shortIn, int bitPos) {
        short mask = (short)(1 << bitPos);
        return (short)(shortIn | mask);
    }

    private static short setBit(Short shortIn, Integer bitPos) {
        return QueryMsg.setBit((short)shortIn, (int)bitPos);
    }

    private static boolean isBitSet(Short shortIn, Integer bitPos) {
        return QueryMsg.isBitSet((short)shortIn, (int)bitPos);
    }

    public int getFeatureQuerySelector() {
        return this.featureQuerySelector;
    }

    public boolean isWhatsNewQuery() {
        return this.featureQuerySelector == 1;
    }

    public URN[] getQueryURNs() {
        URN[] urns = new URN[this.queryURNSet.size()];
        return this.queryURNSet.toArray(urns);
    }

    public boolean hasQueryURNs() {
        return !this.queryURNSet.isEmpty();
    }

    public String getSearchString() {
        return this.searchString;
    }

    public ByteBuffer createMessageBuffer() {
        return ByteBuffer.wrap(this.body);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(100);
        buf.append("[").append(this.getHeader()).append(", MinSpeedIsBitBased=").append(this.minSpeedIsBitBased);
        if (this.minSpeedIsBitBased) {
            buf.append(", RequesterIsFirewalled=").append(this.requesterIsFirewalled).append(", RequesterIsXmlResultsCapable=").append(this.requesterIsXmlResultsCapable);
        }
        buf.append(", SearchString=").append(this.searchString).append("]");
        return buf.toString();
    }

    private void addPhexExtendedOriginGGEP(GGEPBlock ggepBlock) {
        DestAddress[] addresses = new DestAddress[1];
        DestAddress localAddress = Servent.getInstance().getLocalAddress();
        addresses[0] = new DefaultDestAddress(localAddress.getIpAddress(), localAddress.getPort());
        ggepBlock.addExtension("PHEX.EXORG", addresses, 1);
    }

    public int getOriginPort() {
        return this.originPort;
    }

    public byte[] getOriginIpAddress() {
        return this.originIpAddress;
    }

    private void buildBody() throws IOException {
        byte[] ggepData;
        ByteArrayOutputStream bodyStream = new ByteArrayOutputStream();
        short complexMinSpeed = this.buildComplexMinSpeed();
        IOUtil.serializeShort(complexMinSpeed, bodyStream);
        bodyStream.write(this.searchString.toLowerCase().getBytes("UTF-8"));
        bodyStream.write(0);
        boolean writeGemExtension = false;
        if (this.queryURNSet.size() == 0) {
            bodyStream.write("urn:sha1".getBytes());
            writeGemExtension = true;
        } else {
            for (URN urn : this.queryURNSet) {
                bodyStream.write(urn.getAsString().getBytes());
            }
            writeGemExtension = true;
        }
        GGEPBlock ggepBlock = new GGEPBlock(true);
        if (this.featureQuerySelector > 0) {
            ggepBlock.addExtension("WH", this.featureQuerySelector);
        }
        if (this.requestSecureOOBReplies) {
            ggepBlock.addExtension("SO");
        }
        if (MessagePrefs.UseExtendedOriginIpAddress.get().booleanValue()) {
            this.addPhexExtendedOriginGGEP(ggepBlock);
        }
        if ((ggepData = ggepBlock.getBytes()).length > 0) {
            if (writeGemExtension) {
                bodyStream.write(28);
            }
            bodyStream.write(ggepData);
            writeGemExtension = true;
        }
        bodyStream.write(0);
        this.body = bodyStream.toByteArray();
    }

    private void parseBody() {
        try {
            GGEPBlock[] ggepBlocks;
            ByteArrayInputStream inStream = new ByteArrayInputStream(this.body);
            short minSpeedField = IOUtil.deserializeShort(inStream);
            this.parseMinSpeed(minSpeedField);
            byte[] queryBytes = IOUtil.readBytesToNull(inStream);
            this.searchString = new String(queryBytes, "UTF-8");
            byte[] extensionBytes = IOUtil.readBytesToNull(inStream);
            HUGEBlock hugeBlock = new HUGEBlock(extensionBytes);
            this.queryURNSet = hugeBlock.getURNS();
            if (this.queryURNSet == null) {
                this.queryURNSet = Collections.emptySet();
            }
            if ((ggepBlocks = hugeBlock.getGGEPBlocks()) != null) {
                if (GGEPBlock.isExtensionHeaderInBlocks(ggepBlocks, "WH")) {
                    this.featureQuerySelector = GGEPExtension.parseIntExtensionData(ggepBlocks, "WH", 0);
                }
                if (GGEPBlock.isExtensionHeaderInBlocks(ggepBlocks, "SO")) {
                    this.requestSecureOOBReplies = true;
                }
                if (MessagePrefs.UseExtendedOriginIpAddress.get().booleanValue()) {
                    try {
                        byte[] value = GGEPBlock.getExtensionDataInBlocks(ggepBlocks, "PHEX.EXORG");
                        this.originIpAddress = new IpAddress(value).getHostIP();
                        this.originPort = IOUtil.deserializeShortLE(value, 4);
                    }
                    catch (Exception ex) {
                        logger.error(ex.toString(), (Throwable)ex);
                    }
                }
            }
        }
        catch (IOException e) {
            logger.error(e.toString(), (Throwable)e);
        }
    }

    private void parseMinSpeed(short minSpeedIn) {
        this.minSpeedIsBitBased = QueryMsg.isBitSet(minSpeedIn, 15);
        if (this.isMinSpeedBitBased()) {
            this.requesterIsFirewalled = QueryMsg.isBitSet(minSpeedIn, 14);
            this.requesterIsXmlResultsCapable = QueryMsg.isBitSet(minSpeedIn, 13);
        }
    }

    private short buildComplexMinSpeed() {
        short complexMinSpeed = 0;
        if (this.minSpeedIsBitBased) {
            complexMinSpeed = QueryMsg.setBit(complexMinSpeed, 15);
            if (this.requesterIsFirewalled) {
                complexMinSpeed = QueryMsg.setBit(complexMinSpeed, 14);
            }
            if (!this.requestSecureOOBReplies && this.requesterIsXmlResultsCapable) {
                complexMinSpeed = QueryMsg.setBit(complexMinSpeed, 13);
            }
        }
        return complexMinSpeed;
    }
}

