/*
 * Decompiled with CFR 0.152.
 */
package phex.msg;

import phex.io.buffer.ByteBuffer;
import phex.msg.MsgHeader;
import phex.msg.RouteTableUpdateMsg;
import phex.utils.IOUtil;

public class QRResetTableMsg
extends RouteTableUpdateMsg {
    private static final int MESSAGE_LENGTH = 6;
    private int tableSize;
    private byte infinityByte;

    public QRResetTableMsg(int aTableSize, byte aInfinityByte) {
        super((byte)0, 6);
        this.tableSize = aTableSize;
        this.infinityByte = aInfinityByte;
    }

    public QRResetTableMsg(MsgHeader header, byte[] aBody) {
        super((byte)0, header);
        header.setDataLength(aBody.length);
        this.tableSize = IOUtil.deserializeIntLE(aBody, 1);
        this.infinityByte = aBody[5];
    }

    public int getTableSize() {
        return this.tableSize;
    }

    public ByteBuffer createMessageBuffer() {
        ByteBuffer buffer = ByteBuffer.allocate(6);
        buffer.put(this.variant).putIntLE(this.tableSize).put(this.infinityByte);
        buffer.rewind();
        return buffer;
    }
}

