/*
 * Decompiled with CFR 0.152.
 */
package phex.msg;

import java.util.HashSet;
import java.util.Set;
import phex.bootstrap.UdpHostCache;
import phex.common.address.DefaultDestAddress;
import phex.common.address.DestAddress;
import phex.common.address.MalformedDestAddressException;
import phex.common.log.NLogger;
import phex.io.buffer.ByteBuffer;
import phex.msg.GGEPBlock;
import phex.msg.InvalidGGEPBlockException;
import phex.msg.Message;
import phex.msg.MsgHeader;
import phex.net.repres.PresentationManager;
import phex.security.AccessType;
import phex.security.PhexSecurityManager;
import phex.utils.HexConverter;
import phex.utils.IOUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PongMsg
extends Message {
    protected static final int MIN_PONG_DATA_LEN = 14;
    private byte[] body;
    private DestAddress pongAddress;
    private long fileCount;
    private long fileSizeInKB;
    private String vendor;
    private int vendorVersionMajor = -1;
    private int vendorVersionMinor = -1;
    private int avgDailyUptime;
    private boolean isUltrapeer;
    private GGEPBlock ggepBlock;
    private Set<DestAddress> ippDestAddresses;
    private Set<UdpHostCache> udpHostCaches;
    private UdpHostCache udpHostCache;

    public PongMsg(MsgHeader aHeader, byte[] payload, PhexSecurityManager securityService) {
        super(aHeader);
        this.getHeader().setPayloadType((byte)1);
        this.body = payload;
        this.getHeader().setDataLength(this.body.length);
        this.avgDailyUptime = -1;
        this.parseBody(securityService);
    }

    protected PongMsg(MsgHeader header, DestAddress pongAddress, int fileCount, int fileSizeInKB, boolean isUltrapeer, GGEPBlock ggepBlock) {
        super(header);
        this.getHeader().setPayloadType((byte)1);
        this.pongAddress = pongAddress;
        this.fileCount = fileCount;
        this.isUltrapeer = isUltrapeer;
        this.ggepBlock = ggepBlock;
        this.fileSizeInKB = isUltrapeer ? (long)PongMsg.createUltrapeerMarking(fileSizeInKB) : (long)fileSizeInKB;
        this.buildBody();
        this.getHeader().setDataLength(this.body.length);
    }

    public DestAddress getPongAddress() {
        return this.pongAddress;
    }

    public long getFileCount() {
        return this.fileCount;
    }

    public long getFileSizeInKB() {
        return this.fileSizeInKB;
    }

    public String getVendor() {
        return this.vendor;
    }

    public int getVendorVersionMajor() {
        return this.vendorVersionMajor;
    }

    public int getVendorVersionMinor() {
        return this.vendorVersionMinor;
    }

    public int getDailyUptime() {
        return this.avgDailyUptime;
    }

    public boolean hasFreeLeafSlots() {
        if (this.ggepBlock == null || !this.ggepBlock.isExtensionAvailable("UP")) {
            return false;
        }
        byte[] data = this.ggepBlock.getExtensionData("UP");
        return data != null && data.length >= 3 && data[1] > 0;
    }

    public boolean hasFreeUPSlots() {
        if (this.ggepBlock == null || !this.ggepBlock.isExtensionAvailable("UP")) {
            return false;
        }
        byte[] data = this.ggepBlock.getExtensionData("UP");
        return data != null && data.length >= 3 && data[2] > 0;
    }

    public Set<DestAddress> getIPPDestAddresses() {
        return this.ippDestAddresses;
    }

    public Set<UdpHostCache> getUdpHostCaches() {
        return this.udpHostCaches;
    }

    public UdpHostCache getUdpHostCache() {
        return this.udpHostCache;
    }

    public byte[] getBody() {
        return this.body;
    }

    @Override
    public ByteBuffer createMessageBuffer() {
        return ByteBuffer.wrap(this.body);
    }

    public byte[] getbytes() {
        byte[] data = new byte[23 + this.body.length];
        byte[] hdr = this.getHeader().getBytes();
        System.arraycopy(hdr, 0, data, 0, 23);
        System.arraycopy(this.body, 0, data, 23, this.body.length);
        return data;
    }

    public String getDebugString() {
        return "Pong[ Addr=" + this.pongAddress + ", FileCount=" + this.fileCount + ", FileSize=" + this.fileSizeInKB + ", AvgUptime=" + this.avgDailyUptime + ", HEX=[" + HexConverter.toHexString(this.body) + "] ]";
    }

    private void buildBody() {
        int extensionLength;
        byte[] ggepExtension;
        if (this.ggepBlock != null) {
            ggepExtension = this.ggepBlock.getBytes();
            extensionLength = ggepExtension.length;
        } else {
            ggepExtension = null;
            extensionLength = 0;
        }
        this.body = new byte[14 + extensionLength];
        IOUtil.serializeShortLE((short)this.pongAddress.getPort(), this.body, 0);
        System.arraycopy(this.pongAddress.getIpAddress().getHostIP(), 0, this.body, 2, 4);
        IOUtil.serializeIntLE((int)this.fileCount, this.body, 6);
        IOUtil.serializeIntLE((int)this.fileSizeInKB, this.body, 10);
        if (ggepExtension != null) {
            System.arraycopy(ggepExtension, 0, this.body, 14, extensionLength);
        }
    }

    private void parseBody(PhexSecurityManager securityService) {
        int port = IOUtil.unsignedShort2Int(IOUtil.deserializeShortLE(this.body, 0));
        byte[] ip = new byte[]{this.body[2], this.body[3], this.body[4], this.body[5]};
        this.pongAddress = new DefaultDestAddress(ip, port);
        this.fileCount = IOUtil.unsignedInt2Long(IOUtil.deserializeIntLE(this.body, 6));
        this.fileSizeInKB = IOUtil.unsignedInt2Long(IOUtil.deserializeIntLE(this.body, 10));
        if (this.body.length <= 14) {
            return;
        }
        this.parseGGEPBlocks(securityService);
    }

    private void parseGGEPBlocks(PhexSecurityManager securityService) {
        byte[] data;
        this.ggepBlock = GGEPBlock.mergeGGEPBlocks(GGEPBlock.parseGGEPBlocks(this.body, 14));
        if (this.ggepBlock.isExtensionAvailable("VC") && (data = this.ggepBlock.getExtensionData("VC")).length >= 4) {
            this.vendor = new String(data, 0, 4).intern();
            if (data.length > 4) {
                this.vendorVersionMajor = data[4] >> 4;
                this.vendorVersionMinor = data[4] & 0xF;
            }
        }
        if (this.ggepBlock.isExtensionAvailable("DU") && (data = this.ggepBlock.getExtensionData("DU")) != null) {
            if (data.length >= 1 && data.length <= 4) {
                this.avgDailyUptime = IOUtil.deserializeIntLE(data, 0, data.length);
                if (this.avgDailyUptime <= 0) {
                    NLogger.warn(PongMsg.class, "Negative average uptime GGEP extension data: " + this.avgDailyUptime + " - " + HexConverter.toHexString(data));
                    this.avgDailyUptime = -1;
                }
            } else {
                NLogger.warn(PongMsg.class, "Invalid average uptime GGEP extension data: " + HexConverter.toHexString(data));
                this.avgDailyUptime = -1;
            }
        }
        if (this.ggepBlock.isExtensionAvailable("IPP") && (data = this.ggepBlock.getExtensionData("IPP")) != null) {
            this.ippDestAddresses = PongMsg.unpackIpPortData(data, securityService);
        }
        if (this.ggepBlock.isExtensionAvailable("PHC") && (data = this.ggepBlock.getExtensionData("PHC")) != null) {
            String packedData = new String(data);
            this.udpHostCaches = this.parsePackedHostCache(packedData, securityService);
        }
        if (this.ggepBlock.isExtensionAvailable("UDPHC")) {
            data = this.ggepBlock.getExtensionData("UDPHC");
            try {
                DestAddress address = data != null && data.length > 0 ? new DefaultDestAddress(new String(data), this.pongAddress.getPort()) : this.pongAddress;
                AccessType access = securityService.controlHostAddressAccess(address);
                if (access == AccessType.ACCESS_GRANTED) {
                    this.udpHostCache = new UdpHostCache(address);
                }
            }
            catch (IllegalArgumentException e) {
                NLogger.warn(PongMsg.class, "INVALID Udp Host Cache found and ignored " + e);
            }
        }
    }

    private Set<UdpHostCache> parsePackedHostCache(String packedHostCaches, PhexSecurityManager securityMgr) {
        PresentationManager netPresMgr = PresentationManager.getInstance();
        String[] hostCaches = packedHostCaches.split("\n");
        HashSet<UdpHostCache> packedUdpHostCaches = new HashSet<UdpHostCache>(hostCaches.length);
        for (int i = 0; i < hostCaches.length; ++i) {
            int pos = hostCaches[i].indexOf("&");
            try {
                DestAddress address;
                if (pos == -1) {
                    address = netPresMgr.createHostAddress(hostCaches[i], 6346);
                } else {
                    String temp = hostCaches[i].substring(0, pos);
                    address = netPresMgr.createHostAddress(temp, 6346);
                }
                AccessType access = securityMgr.controlHostAddressAccess(address);
                if (access != AccessType.ACCESS_GRANTED) continue;
                UdpHostCache cache = new UdpHostCache(address);
                packedUdpHostCaches.add(cache);
                continue;
            }
            catch (MalformedDestAddressException e) {
                NLogger.warn(PongMsg.class, " Ignored One Host Cache address in a packed host cache list  " + e);
            }
        }
        return packedUdpHostCaches;
    }

    private static Set<DestAddress> unpackIpPortData(byte[] data, PhexSecurityManager securityMgr) {
        HashSet<DefaultDestAddress> ipPortPairs = null;
        try {
            int FIELD_SIZE = 6;
            if (data.length % 6 != 0) {
                throw new InvalidGGEPBlockException("invalid IPPORT EXTENSION DATA IN PONG");
            }
            int size = data.length / 6;
            ipPortPairs = new HashSet<DefaultDestAddress>();
            for (int i = 0; i < size; ++i) {
                int index = i * 6;
                byte[] ip = new byte[4];
                System.arraycopy(data, index, ip, 0, 4);
                int port = IOUtil.unsignedShort2Int(IOUtil.deserializeShortLE(data, index + 4));
                AccessType access = securityMgr.controlHostIPAccess(ip);
                if (access != AccessType.ACCESS_GRANTED) continue;
                DefaultDestAddress current = new DefaultDestAddress(ip, port);
                ipPortPairs.add(current);
            }
        }
        catch (InvalidGGEPBlockException exp) {
            NLogger.warn(PongMsg.class, exp);
        }
        return ipPortPairs;
    }

    public boolean isUltrapeerMarked() {
        if (this.fileSizeInKB < 8L) {
            return false;
        }
        return (this.fileSizeInKB & this.fileSizeInKB - 1L) == 0L;
    }

    private static int createUltrapeerMarking(int kbytes) {
        if (kbytes < 12) {
            return 8;
        }
        int bitCount = IOUtil.determineBitCount(kbytes);
        int power = (int)Math.pow(2.0, bitCount);
        int minBorder = power - power / 4;
        if (kbytes < minBorder) {
            power = (int)Math.pow(2.0, bitCount - 1);
        }
        return power;
    }
}

