/*
 * Decompiled with CFR 0.152.
 */
package phex.msg;

import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import phex.bootstrap.UdpHostCacheContainer;
import phex.common.PhexVersion;
import phex.common.address.DefaultDestAddress;
import phex.common.address.DestAddress;
import phex.common.address.IpAddress;
import phex.host.CaughtHost;
import phex.host.CaughtHostsContainer;
import phex.host.Host;
import phex.host.NetworkHostsContainer;
import phex.msg.GGEPBlock;
import phex.msg.GUID;
import phex.msg.InvalidMessageException;
import phex.msg.MessageProcessor;
import phex.msg.MsgHeader;
import phex.msg.PingMsg;
import phex.msg.PongMsg;
import phex.security.PhexSecurityManager;
import phex.utils.IOUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PongFactory {
    private static final int ULTRAPEER_MAJOR_VERSION_NUMBER = 0;
    private static final int ULTRAPEER_MINOR_VERSION_NUMBER = 1;
    private static final Logger logger = LoggerFactory.getLogger(PongFactory.class);
    private static final byte[] GGEP_VENDOR_CODE = new byte[5];
    @Nonnull
    private final PhexSecurityManager securityService;
    @Nonnull
    private final NetworkHostsContainer netHostsContainer;
    @Nonnull
    private final CaughtHostsContainer caughtHostsContainer;
    @Nullable
    private final UdpHostCacheContainer uhcContainer;

    public PongFactory(NetworkHostsContainer netHostsContainer, CaughtHostsContainer caughtHostsContainer, PhexSecurityManager securityService) {
        this(netHostsContainer, caughtHostsContainer, null, securityService);
    }

    public PongFactory(NetworkHostsContainer netHostsContainer, CaughtHostsContainer caughtHostsContainer, UdpHostCacheContainer uhcContainer, PhexSecurityManager securityService) {
        if (securityService == null) {
            throw new NullPointerException("securityService is null");
        }
        this.securityService = securityService;
        if (netHostsContainer == null) {
            throw new NullPointerException("netHostsContainer is null");
        }
        this.netHostsContainer = netHostsContainer;
        if (caughtHostsContainer == null) {
            throw new NullPointerException("caughtHostsContainer is null");
        }
        this.caughtHostsContainer = caughtHostsContainer;
        this.uhcContainer = uhcContainer;
    }

    public PongMsg createUdpPongMsg(byte[] bytesMsg, Host fromHost) throws InvalidMessageException {
        MsgHeader msgHdr = MsgHeader.createMsgHeader(bytesMsg, 0);
        return this.createUdpPongMsg(msgHdr, bytesMsg, 23, fromHost);
    }

    public PongMsg createUdpPongMsg(MsgHeader msgHdr, byte[] data, int offset, Host fromHost) throws InvalidMessageException {
        if (msgHdr.getDataLength() < 14) {
            throw new InvalidMessageException(" Could not create Msg Body while trying to create udp pong Msg");
        }
        byte[] body = MessageProcessor.createBody(msgHdr, data, offset);
        if (body == null) {
            throw new InvalidMessageException(" Could not create Msg Body while trying to create udp pong Msg");
        }
        return new PongMsg(msgHdr, body, this.securityService);
    }

    public PongMsg createUdpPongMsg(PingMsg ping, DestAddress localAddress, boolean isUdpHostCache, int avgDailyUptime, int sharedFileCount, int sharedFileSize, boolean isUltrapeer) {
        IpAddress ipAddress;
        GGEPBlock ggepBlock = this.createMyGGEPBlock(avgDailyUptime, isUltrapeer);
        byte[] scpByte = ping.getScpByte();
        if (scpByte != null) {
            List<CaughtHost> ipPortPairs = null;
            ipPortPairs = scpByte.length > 0 && (scpByte[0] & 1) == 1 ? this.caughtHostsContainer.getFreeUltrapeerSlotHosts() : this.caughtHostsContainer.getFreeLeafSlotHosts();
            this.addUdpPongGGEPExt(localAddress, isUdpHostCache, ipPortPairs, ggepBlock);
        }
        if ((ipAddress = localAddress.getIpAddress()) == null) {
            throw new IllegalArgumentException("Can't accept null ip.");
        }
        MsgHeader newHeader = new MsgHeader(ping.getHeader().getMsgID(), 1, 1, 0, 0);
        PongMsg udpPong = new PongMsg(newHeader, localAddress, sharedFileCount, sharedFileSize, isUltrapeer, ggepBlock);
        logger.info("Created udp pong in response to ping: {}", (Object)udpPong);
        return udpPong;
    }

    public PongMsg createMyOutgoingPong(GUID msgId, DestAddress localAddress, byte ttl, int sharedFileCount, int sharedFileSize, boolean isUltrapeer, int avgDailyUptime) {
        IpAddress pongIp;
        GGEPBlock ggepBlock = this.createMyGGEPBlock(avgDailyUptime, isUltrapeer);
        IpAddress localIp = localAddress.getIpAddress();
        if (localIp == null) {
            pongIp = IpAddress.UNSET_IP;
            PongFactory.addPhexExtendedDestinationGGEP(localAddress, ggepBlock);
        } else {
            pongIp = new IpAddress(localIp.getHostIP());
        }
        MsgHeader header = new MsgHeader(msgId, 1, ttl, 0, 0);
        DefaultDestAddress pongAddress = new DefaultDestAddress(pongIp, localAddress.getPort());
        PongMsg pong = new PongMsg(header, pongAddress, sharedFileCount, sharedFileSize, isUltrapeer, ggepBlock);
        return pong;
    }

    public PongMsg createOtherLeafsOutgoingPong(GUID msgId, byte ttl, byte hops, DestAddress address) {
        IpAddress pongIp;
        MsgHeader header = new MsgHeader(msgId, 1, ttl, hops, 0);
        GGEPBlock ggepBlock = null;
        IpAddress ip = address.getIpAddress();
        if (ip == null) {
            pongIp = IpAddress.UNSET_IP;
            ggepBlock = new GGEPBlock(false);
            PongFactory.addPhexExtendedDestinationGGEP(address, ggepBlock);
        } else {
            pongIp = new IpAddress(ip.getHostIP());
        }
        DefaultDestAddress pongAddress = new DefaultDestAddress(pongIp, address.getPort());
        PongMsg pong = new PongMsg(header, pongAddress, 0, 0, false, ggepBlock);
        return pong;
    }

    public PongMsg createFromCachePong(GUID newGuid, byte newTTL, PongMsg pongMsg) {
        MsgHeader header = new MsgHeader(newGuid, 1, newTTL, 0, 0);
        PongMsg pong = new PongMsg(header, pongMsg.getBody(), this.securityService);
        return pong;
    }

    private GGEPBlock createMyGGEPBlock(int avgDailyUptime, boolean isUltrapeer) {
        GGEPBlock ggepBlock = new GGEPBlock(false);
        if (avgDailyUptime > 0) {
            ggepBlock.addExtension("DU", avgDailyUptime);
        }
        if (isUltrapeer) {
            byte[] upExtension = new byte[]{IOUtil.serializeGUESSVersionFormat(0, 1), (byte)this.netHostsContainer.getOpenLeafSlotsCount(), (byte)this.netHostsContainer.getOpenUltrapeerSlotsCount()};
            ggepBlock.addExtension("UP", upExtension);
        }
        ggepBlock.addExtension("VC", GGEP_VENDOR_CODE);
        return ggepBlock;
    }

    private void addUdpPongGGEPExt(DestAddress localAddress, boolean isUdpHostCache, Collection<CaughtHost> ipPortPairs, GGEPBlock ggepBlock) {
        String packedCacheString;
        byte[] ipPortData;
        if (ipPortPairs != null && (ipPortData = PongFactory.packIpPortData(ipPortPairs)).length >= 6) {
            ggepBlock.addExtension("IPP", ipPortData);
        }
        if (isUdpHostCache) {
            byte[] data = localAddress.isIpHostName() ? new byte[]{} : localAddress.getHostName().getBytes();
            ggepBlock.addExtension("UDPHC", data);
            logger.debug("UDP HOST CACHE extension added to outgoing pongs");
        }
        if (this.uhcContainer != null && (packedCacheString = this.uhcContainer.createPackedHostCaches()).length() > 0) {
            byte[] data = IOUtil.deflate(packedCacheString.getBytes());
            ggepBlock.addExtension("PHC", data);
            logger.debug("PACKED HOST CACHE extension added to outgoing pongs.");
        }
    }

    private static void addPhexExtendedDestinationGGEP(DestAddress address, GGEPBlock ggepBlock) {
        ggepBlock.addExtension("PHEX.EXDST", address.getHostName().getBytes());
    }

    private static byte[] packIpPortData(Collection<CaughtHost> ipPortCollection) {
        int FIELD_SIZE = 6;
        byte[] data = new byte[ipPortCollection.size() * 6];
        int offset = 0;
        for (CaughtHost host : ipPortCollection) {
            DestAddress address = host.getHostAddress();
            byte[] addr = address.getIpAddress().getHostIP();
            int port = address.getPort();
            System.arraycopy(addr, 0, data, offset, 4);
            IOUtil.serializeShortLE((short)port, data, offset += 4);
            offset += 2;
        }
        return data;
    }

    static {
        PongFactory.GGEP_VENDOR_CODE[0] = 80;
        PongFactory.GGEP_VENDOR_CODE[1] = 72;
        PongFactory.GGEP_VENDOR_CODE[2] = 69;
        PongFactory.GGEP_VENDOR_CODE[3] = 88;
        PongFactory.GGEP_VENDOR_CODE[4] = IOUtil.serializeGUESSVersionFormat(PhexVersion.getMajorVersion(), PhexVersion.getMinorVersion());
    }
}

