/*
 * Decompiled with CFR 0.152.
 */
package phex.msg;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PushbackInputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import phex.common.URN;
import phex.common.log.NLogger;
import phex.msg.GGEPBlock;
import phex.msg.InvalidGGEPBlockException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HUGEBlock {
    private GGEPBlock[] ggepBlocks = null;
    private Set<URN> urns = null;
    private Set<String> others = null;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HUGEBlock(byte[] data) {
        ByteArrayOutputStream tempBuffer = new ByteArrayOutputStream(64);
        ByteArrayInputStream baInStream = new ByteArrayInputStream(data);
        PushbackInputStream inStream = new PushbackInputStream(baInStream);
        try {
            byte b;
            while ((b = (byte)inStream.read()) != -1) {
                if (b == 0) {
                    return;
                }
                if (b == -61) {
                    inStream.unread(b);
                    this.parseGGEPBlock(inStream);
                    continue;
                }
                tempBuffer.reset();
                do {
                    tempBuffer.write(b);
                } while ((b = (byte)inStream.read()) != -1 && b != 28);
                if (b != -1 && b != 28) continue;
                try {
                    String extString = new String(tempBuffer.toByteArray(), "UTF-8");
                    if (URN.isValidURN(extString)) {
                        URN urn = new URN(extString);
                        if (this.urns == null) {
                            this.urns = new HashSet<URN>(3);
                        }
                        this.urns.add(urn);
                        continue;
                    }
                    if (this.others == null) {
                        this.others = new HashSet<String>(3);
                    }
                    this.others.add(extString);
                }
                catch (IOException exp) {}
            }
            return;
        }
        catch (IOException exp) {
            NLogger.error(HUGEBlock.class, exp, exp);
        }
    }

    private void parseGGEPBlock(PushbackInputStream inStream) {
        try {
            GGEPBlock[] ggeps = GGEPBlock.parseGGEPBlocks(inStream);
            this.ggepBlocks = ggeps;
        }
        catch (InvalidGGEPBlockException exp) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public GGEPBlock[] getGGEPBlocks() {
        return this.ggepBlocks;
    }

    public Set<URN> getURNS() {
        if (this.urns == null) {
            return Collections.emptySet();
        }
        return this.urns;
    }

    public Set<String> getOthers() {
        if (this.others == null) {
            return Collections.emptySet();
        }
        return this.others;
    }
}

