/*
 * Decompiled with CFR 0.152.
 */
package phex.metalink;

import com.bitzi.util.Base32;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import phex.utils.StringUtils;
import phex.utils.URLCodecUtils;

public class DMetalink {
    public ArrayList<FileEntry> files = new ArrayList();

    public void newFile(String filename) {
        this.files.add(new FileEntry(filename));
    }

    public void addURL(String proto, String url) {
        FileEntry f = this.files.get(this.files.size() - 1);
        f.urls.add(new UrlEntry(proto, url));
    }

    public void addHash(String type, String value) {
        FileEntry f = this.files.get(this.files.size() - 1);
        f.hashes.put(type, value);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.files.size() + " files known\n");
        for (FileEntry f : this.files) {
            buffer.append("filename=" + f.filename + "\n");
            for (UrlEntry u : f.urls) {
                buffer.append("  url= " + u.url + "\n");
            }
            Set<Map.Entry<String, String>> hashEntrySet = f.hashes.entrySet();
            for (Map.Entry<String, String> hash : hashEntrySet) {
                buffer.append("  hash(" + hash.getKey() + ")= " + hash.getValue() + "\n");
            }
        }
        return buffer.toString();
    }

    public class UrlEntry {
        public String type;
        public String url;

        public UrlEntry(String type, String url) {
            this.type = type;
            this.url = url;
        }
    }

    public class FileEntry {
        public HashMap<String, String> hashes;
        public ArrayList<UrlEntry> urls;
        public String filename;

        public FileEntry(String name) {
            this.filename = name;
            this.hashes = new HashMap();
            this.urls = new ArrayList();
        }

        public String sha1() {
            return this.hashes.get("sha1");
        }

        public String getSha1Urn() {
            String sha1Data = this.hashes.get("sha1");
            if (StringUtils.isEmpty(sha1Data)) {
                return null;
            }
            if (sha1Data.length() == 40) {
                sha1Data = this.encodeSha1(sha1Data);
            } else if (sha1Data.length() != 32) {
                return null;
            }
            return "urn:sha1:" + sha1Data;
        }

        private String encodeSha1(String digest) {
            byte[] chars = new byte[20];
            for (int i = 0; i < digest.length(); i += 2) {
                int hn = Byte.parseByte(digest.substring(i, i + 1), 16) << 4;
                byte ln = Byte.parseByte(digest.substring(i + 1, i + 2), 16);
                int b = hn + ln;
                chars[i / 2] = (byte)b;
            }
            return Base32.encode(chars);
        }

        public String magnet() {
            String xtPart = null;
            String sha1Urn = this.getSha1Urn();
            if (!StringUtils.isEmpty(sha1Urn)) {
                xtPart = "xt=" + sha1Urn;
            }
            String dnPart = null;
            if (!StringUtils.isEmpty(this.filename)) {
                dnPart = "dn=" + URLCodecUtils.encodeURL(this.filename);
            }
            StringBuffer altSourceBuf = new StringBuffer();
            for (UrlEntry urlEntry : this.urls) {
                if (!urlEntry.type.equals("http")) continue;
                if (altSourceBuf.length() > 0) {
                    altSourceBuf.append("&");
                }
                altSourceBuf.append("as=");
                altSourceBuf.append(URLCodecUtils.encodeURL(urlEntry.url));
            }
            StringBuffer magnetBuffer = new StringBuffer();
            if (!StringUtils.isEmpty(xtPart)) {
                magnetBuffer.append(xtPart);
            }
            if (!StringUtils.isEmpty(dnPart)) {
                if (magnetBuffer.length() > 0) {
                    magnetBuffer.append("&");
                }
                magnetBuffer.append(xtPart);
            }
            if (altSourceBuf.length() > 0) {
                if (magnetBuffer.length() > 0) {
                    magnetBuffer.append("&");
                }
                magnetBuffer.append(altSourceBuf);
            }
            if (magnetBuffer.length() == 0) {
                return null;
            }
            magnetBuffer.insert(0, "magnet:?");
            return magnetBuffer.toString();
        }
    }
}

