/*
 * Decompiled with CFR 0.152.
 */
package phex.http;

import phex.common.URN;
import phex.utils.URLCodecUtils;

public class GnutellaRequest {
    public static final String GNUTELLA_GET_PREFIX = "/get/";
    public static final String GNUTELLA_URI_RES_PREFIX = "/uri-res/N2R?";
    public static final String GNUTELLA_URI_RES_THEX_PREFIX = "/uri-res/N2X?";
    private int fileIndex;
    private String filename;
    private URN urn;
    private boolean isTigerTreeRequest;

    public GnutellaRequest(URN requestURN, boolean isTigerTreeRequest) {
        this.urn = requestURN;
        this.fileIndex = -1;
        this.filename = null;
        this.isTigerTreeRequest = isTigerTreeRequest;
    }

    public GnutellaRequest(int fileIndex, String fileName) {
        this.fileIndex = fileIndex;
        this.filename = fileName;
        this.urn = null;
        this.isTigerTreeRequest = false;
    }

    public String getFileName() {
        return this.filename;
    }

    public int getFileIndex() {
        return this.fileIndex;
    }

    public URN getURN() {
        return this.urn;
    }

    public void setContentURN(URN contentURN) {
        this.urn = contentURN;
    }

    public boolean isTigerTreeRequest() {
        return this.isTigerTreeRequest;
    }

    public static GnutellaRequest parseGnutellaRequest(String requestURI) {
        int index = requestURI.indexOf(GNUTELLA_GET_PREFIX);
        if (index != -1) {
            int fileIndex;
            int indexEndIdx = requestURI.indexOf(47, index += 5);
            String indexStr = requestURI.substring(index, indexEndIdx);
            try {
                fileIndex = Integer.parseInt(indexStr);
            }
            catch (NumberFormatException exp) {
                fileIndex = -1;
            }
            String filename = URLCodecUtils.decodeURL(requestURI.substring(indexEndIdx + 1));
            return new GnutellaRequest(fileIndex, filename);
        }
        index = requestURI.indexOf(GNUTELLA_URI_RES_PREFIX);
        if (index != -1) {
            String urnStr = URLCodecUtils.decodeURL(requestURI.substring(index += 13));
            URN urn = new URN(urnStr);
            return new GnutellaRequest(urn, false);
        }
        index = requestURI.indexOf(GNUTELLA_URI_RES_THEX_PREFIX);
        if (index != -1) {
            String urnStr = requestURI.substring(index += GNUTELLA_URI_RES_THEX_PREFIX.length());
            URN urn = new URN(urnStr);
            return new GnutellaRequest(urn, true);
        }
        return null;
    }
}

