/*
 * Decompiled with CFR 0.152.
 */
package phex.host;

import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import phex.common.Environment;
import phex.common.LongObj;
import phex.common.bandwidth.BandwidthController;
import phex.prefs.core.BandwidthPrefs;
import phex.prefs.core.ConnectionPrefs;
import phex.servent.Servent;
import phex.statistic.StatisticsManager;
import phex.statistic.UptimeStatisticProvider;

public class UltrapeerCapabilityChecker
extends TimerTask {
    private static Logger logger = LoggerFactory.getLogger(UltrapeerCapabilityChecker.class);
    private static final long TIMER_PERIOD = 10000L;
    private static final long ONE_HOUR = 3600000L;
    private static final long TWO_HOURS = 0x6DDD00L;
    private final Servent servent;
    private final StatisticsManager statisticsService;
    private final boolean isUltrapeerOS;
    private volatile boolean isUltrapeerCapable;
    private volatile boolean isPerfectUltrapeer;

    public UltrapeerCapabilityChecker(Servent servent, StatisticsManager statisticsService) {
        if (servent == null) {
            throw new NullPointerException("servent missing.");
        }
        if (statisticsService == null) {
            throw new NullPointerException("statisticsService missing.");
        }
        this.servent = servent;
        this.statisticsService = statisticsService;
        Environment env = Environment.getInstance();
        this.isUltrapeerOS = env.isUltrapeerOS();
        env.scheduleTimerTask(this, 0L, 10000L);
    }

    public void run() {
        this.checkIfUltrapeerCapable();
    }

    private void checkIfUltrapeerCapable() {
        boolean isCapable;
        UptimeStatisticProvider uptimeProvider = (UptimeStatisticProvider)this.statisticsService.getStatisticProvider("UptimeProvider");
        if (uptimeProvider == null) {
            this.isUltrapeerCapable = false;
            return;
        }
        boolean bl = isCapable = ConnectionPrefs.AllowToBecomeUP.get() != false && !this.servent.isFirewalled() && this.isUltrapeerOS && BandwidthPrefs.NetworkSpeedKbps.get() > 64 && BandwidthPrefs.MaxNetworkBandwidth.get() > 10240 && BandwidthPrefs.MaxTotalBandwidth.get() > 14336 && (((LongObj)uptimeProvider.getValue()).getValue() > 0x6DDD00L || ((LongObj)uptimeProvider.getAverageValue()).getValue() > 3600000L);
        if (logger.isTraceEnabled() && !isCapable) {
            this.logTraceUltrapeerCapable(uptimeProvider);
        }
        this.isUltrapeerCapable = isCapable;
        if (this.isUltrapeerCapable && !this.servent.isUltrapeer()) {
            boolean isPerfect;
            long now = System.currentTimeMillis();
            long lastQueryTime = this.servent.getQueryService().getLastQueryTime();
            BandwidthController upBandCont = this.servent.getBandwidthService().getUploadBandwidthController();
            long upAvg = upBandCont.getLongTransferAvg().getAverage();
            this.isPerfectUltrapeer = isPerfect = now - lastQueryTime > 300000L && upAvg < 2048L;
            this.servent.upgradeToUltrapeer();
        } else {
            this.isPerfectUltrapeer = false;
        }
        logger.debug("UP capable: {}, perfect: {}", (Object)this.isUltrapeerCapable, (Object)this.isPerfectUltrapeer);
    }

    private void logTraceUltrapeerCapable(UptimeStatisticProvider uptimeProvider) {
        if (!ConnectionPrefs.AllowToBecomeUP.get().booleanValue()) {
            logger.trace("Not allowed to become UP.");
        }
        if (this.servent.isFirewalled()) {
            logger.trace("Servent is firewalled.");
        }
        if (!this.isUltrapeerOS) {
            logger.trace("No ultrapeer OS.");
        }
        if (BandwidthPrefs.NetworkSpeedKbps.get() <= 64) {
            logger.trace("Not enough network speed");
        }
        if (BandwidthPrefs.MaxNetworkBandwidth.get() <= 10240) {
            logger.trace("Not enough max network bandwidth");
        }
        if (BandwidthPrefs.MaxTotalBandwidth.get() <= 14336) {
            logger.trace("Not enough max total bandwidth");
        }
        if (((LongObj)uptimeProvider.getValue()).getValue() <= 0x6DDD00L || ((LongObj)uptimeProvider.getAverageValue()).getValue() <= 3600000L) {
            logger.trace("Not enough current or avg uptime.");
        }
    }

    public boolean isUltrapeerCapable() {
        return this.isUltrapeerCapable;
    }

    public boolean isPerfectUltrapeer() {
        return this.isPerfectUltrapeer;
    }
}

