/*
 * Decompiled with CFR 0.152.
 */
package phex.host;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.TimerTask;
import org.bushe.swing.event.annotation.EventTopicSubscriber;
import phex.common.Environment;
import phex.common.PhexVersion;
import phex.common.address.DefaultDestAddress;
import phex.common.address.DestAddress;
import phex.common.file.FileManager;
import phex.common.file.ManagedFile;
import phex.common.file.ManagedFileException;
import phex.common.log.NLogger;
import phex.event.ChangeEvent;
import phex.event.ContainerEvent;
import phex.host.FavoriteHost;
import phex.servent.Servent;
import phex.xml.sax.DPhex;
import phex.xml.sax.DSubElementList;
import phex.xml.sax.XMLBuilder;
import phex.xml.sax.favorites.DFavoriteHost;

public class FavoritesContainer {
    private final Servent servent;
    private final ArrayList<FavoriteHost> favoritesList;
    private boolean hasChangedSinceLastSave;

    public FavoritesContainer(Servent servent) {
        this.servent = servent;
        this.favoritesList = new ArrayList();
        this.hasChangedSinceLastSave = false;
        Environment.getInstance().scheduleTimerTask(new SaveFavoritesTimer(), 60000L, 60000L);
        this.initializeFavorites();
        servent.getEventService().processAnnotations(this);
    }

    private void initializeFavorites() {
        this.favoritesList.clear();
        this.loadFromFile();
    }

    public synchronized void addFavorites(DestAddress[] addresses) {
        for (DestAddress address : addresses) {
            FavoriteHost host = new FavoriteHost(address);
            this.insertBookmarkedHost(host, this.favoritesList.size());
        }
    }

    public synchronized void addFavorite(DestAddress address) {
        FavoriteHost host = new FavoriteHost(address);
        this.insertBookmarkedHost(host, this.favoritesList.size());
    }

    @EventTopicSubscriber(topic="phex:servent/gnutellaNetwork")
    public void onGnutellaNetworkEvent(String topic, ChangeEvent event) {
        this.saveFavoriteHosts();
        this.initializeFavorites();
    }

    private void loadFromFile() {
        NLogger.debug(FavoritesContainer.class, "Loading favorites file.");
        try {
            File favoritesFile = this.servent.getGnutellaNetwork().getFavoritesFile();
            if (!favoritesFile.exists()) {
                return;
            }
            FileManager fileMgr = FileManager.getInstance();
            ManagedFile managedFile = fileMgr.getReadWriteManagedFile(favoritesFile);
            DPhex dPhex = XMLBuilder.loadDPhexFromFile(managedFile);
            if (dPhex == null) {
                NLogger.debug(FavoritesContainer.class, "No bookmarked hosts file found.");
                return;
            }
            DSubElementList<DFavoriteHost> dHostList = dPhex.getFavoritesList();
            if (dHostList == null) {
                NLogger.warn(FavoritesContainer.class, "No DFavoritesList found.");
                return;
            }
            for (DFavoriteHost dHost : dHostList.getSubElementList()) {
                int port = dHost.getPort();
                DefaultDestAddress address = null;
                String hostName = dHost.getHostName();
                byte[] ip = dHost.getIp();
                if (hostName != null) {
                    address = new DefaultDestAddress(hostName, port);
                } else if (ip != null) {
                    address = new DefaultDestAddress(ip, port);
                }
                if (address == null) continue;
                FavoriteHost bookmarkedHost = new FavoriteHost(address);
                this.insertBookmarkedHost(bookmarkedHost, this.favoritesList.size());
            }
        }
        catch (IOException exp) {
            NLogger.error(FavoritesContainer.class, exp, exp);
            Environment.getInstance().fireDisplayUserMessage("FavoritesSettingsLoadFailed", new String[]{exp.toString()});
            return;
        }
        catch (ManagedFileException exp) {
            NLogger.error(FavoritesContainer.class, exp, exp);
            Environment.getInstance().fireDisplayUserMessage("FavoritesSettingsLoadFailed", new String[]{exp.toString()});
            return;
        }
    }

    synchronized void saveFavoriteHosts() {
        if (!this.hasChangedSinceLastSave) {
            return;
        }
        try {
            DPhex dPhex = new DPhex();
            dPhex.setPhexVersion(PhexVersion.getFullVersion());
            DSubElementList<DFavoriteHost> dList = new DSubElementList<DFavoriteHost>("favorites-list");
            dPhex.setFavoritesList(dList);
            List<DFavoriteHost> list = dList.getSubElementList();
            for (FavoriteHost host : this.favoritesList) {
                DFavoriteHost dHost = new DFavoriteHost();
                DestAddress address = host.getHostAddress();
                if (address.isIpHostName()) {
                    dHost.setIp(address.getIpAddress().getHostIP());
                } else {
                    dHost.setHostName(address.getHostName());
                }
                dHost.setPort(address.getPort());
                list.add(dHost);
            }
            File favoritesFile = this.servent.getGnutellaNetwork().getFavoritesFile();
            ManagedFile managedFile = FileManager.getInstance().getReadWriteManagedFile(favoritesFile);
            XMLBuilder.saveToFile(managedFile, dPhex);
            this.hasChangedSinceLastSave = false;
        }
        catch (IOException exp) {
            NLogger.error(FavoritesContainer.class, exp, exp);
            Environment.getInstance().fireDisplayUserMessage("FavoritesSettingsSaveFailed", new String[]{exp.toString()});
        }
        catch (ManagedFileException exp) {
            NLogger.error(FavoritesContainer.class, exp, exp);
            Environment.getInstance().fireDisplayUserMessage("FavoritesSettingsSaveFailed", new String[]{exp.toString()});
        }
    }

    public synchronized int getBookmarkedHostsCount() {
        return this.favoritesList.size();
    }

    public synchronized FavoriteHost getBookmarkedHostAt(int index) {
        if (index >= this.favoritesList.size()) {
            return null;
        }
        return this.favoritesList.get(index);
    }

    private synchronized void insertBookmarkedHost(FavoriteHost host, int position) {
        if (!this.favoritesList.contains(host)) {
            this.favoritesList.add(position, host);
            this.hasChangedSinceLastSave = true;
            this.fireBookmarkedHostAdded(host, position);
        }
    }

    public synchronized void removeBookmarkedHost(FavoriteHost host) {
        int position = this.favoritesList.indexOf(host);
        if (position >= 0) {
            this.favoritesList.remove(position);
            this.fireBookmarkedHostRemoved(host, position);
            this.hasChangedSinceLastSave = true;
        }
    }

    private void fireBookmarkedHostAdded(FavoriteHost host, int position) {
        this.servent.getEventService().publish("phex:net/favorites", new ContainerEvent(ContainerEvent.Type.ADDED, host, this, position));
    }

    private void fireBookmarkedHostRemoved(FavoriteHost host, int position) {
        this.servent.getEventService().publish("phex:net/favorites", new ContainerEvent(ContainerEvent.Type.REMOVED, host, this, position));
    }

    private class SaveFavoritesTimer
    extends TimerTask {
        public static final long TIMER_PERIOD = 60000L;

        private SaveFavoritesTimer() {
        }

        public void run() {
            Environment.getInstance().executeOnThreadPool(new SaveFavoritesRunner(), "SaveBookmarkedHosts");
        }
    }

    private class SaveFavoritesRunner
    implements Runnable {
        private SaveFavoritesRunner() {
        }

        public void run() {
            FavoritesContainer.this.saveFavoriteHosts();
        }
    }
}

