/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.tabs.search.monitor;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import phex.gui.common.FWElegantPanel;
import phex.gui.common.GUIRegistry;
import phex.gui.common.IntegerTextField;
import phex.gui.common.table.FWTable;
import phex.gui.tabs.FWTab;
import phex.gui.tabs.search.monitor.QueryHistoryMonitorTableModel;
import phex.query.QueryHistoryMonitor;
import phex.utils.Localizer;
import phex.xml.sax.gui.DGuiSettings;

public class SearchMonitorTab
extends FWTab {
    private final QueryHistoryMonitor queryHistory;
    private JCheckBox enableMonitorCheckbox;
    private JTextField numberOfMonitorRows;
    private QueryHistoryMonitorTableModel queryHistoryModel;
    private JTable mMonitorTable;
    private JScrollPane monitorTableScrollPane;

    public SearchMonitorTab(QueryHistoryMonitor queryHistory) {
        super(1008, Localizer.getString("SearchMonitorTab_SearchMonitor"), GUIRegistry.getInstance().getPlafIconPack().getIcon("SearchMonitor.Tab"), Localizer.getString("SearchMonitorTab_TTTSearchMonitor"), Localizer.getChar("SearchMonitorTab_Mnemonic"), KeyStroke.getKeyStroke(Localizer.getString("SearchMonitorTab_Accelerator")), 7);
        this.queryHistory = queryHistory;
    }

    public void initComponent(DGuiSettings guiSettings) {
        CellConstraints cc = new CellConstraints();
        FormLayout tabLayout = new FormLayout("2dlu, fill:d:grow, 2dlu", "2dlu, fill:p:grow, 2dlu");
        PanelBuilder tabBuilder = new PanelBuilder(tabLayout, (JPanel)this);
        JPanel contentPanel = new JPanel();
        FWElegantPanel banner = new FWElegantPanel(Localizer.getString("SearchMonitorTab_SearchMonitor"), contentPanel);
        tabBuilder.add((Component)banner, cc.xy(2, 2));
        FormLayout contentLayout = new FormLayout("fill:d:grow", "p, 1dlu, fill:d:grow");
        PanelBuilder contentBuilder = new PanelBuilder(contentLayout, contentPanel);
        JPanel historyHeader = new JPanel();
        contentBuilder.add((Component)historyHeader, cc.xy(1, 1));
        FormLayout headerLayout = new FormLayout("d, fill:d:grow, d, 1dlu, d, 1dlu, d", "p");
        PanelBuilder headerBuilder = new PanelBuilder(headerLayout, historyHeader);
        this.enableMonitorCheckbox = new JCheckBox(Localizer.getString("SearchMonitorTab_enable"));
        this.enableMonitorCheckbox.setSelected(this.queryHistory.isHistoryMonitored());
        this.enableMonitorCheckbox.addActionListener(new EnableMonitorActionListener());
        headerBuilder.add((Component)this.enableMonitorCheckbox, cc.xy(1, 1));
        headerBuilder.addLabel(Localizer.getString("SearchMonitorTab_Show"), cc.xy(3, 1));
        this.numberOfMonitorRows = new IntegerTextField(String.valueOf(this.queryHistory.getMaxHistorySize()), 3, 3);
        this.numberOfMonitorRows.getDocument().addDocumentListener(new MonitorRowsDocumentListener());
        headerBuilder.add((Component)this.numberOfMonitorRows, cc.xy(5, 1));
        headerBuilder.addLabel(Localizer.getString("SearchMonitorTab_Rows"), cc.xy(7, 1));
        this.queryHistoryModel = new QueryHistoryMonitorTableModel(this.queryHistory);
        this.mMonitorTable = new JTable(this.queryHistoryModel);
        this.monitorTableScrollPane = FWTable.createFWTableScrollPane(this.mMonitorTable);
        contentBuilder.add((Component)this.monitorTableScrollPane, cc.xy(1, 3));
    }

    public boolean isVisibleByDefault() {
        return false;
    }

    public void updateUI() {
        super.updateUI();
        if (this.monitorTableScrollPane != null) {
            FWTable.updateFWTableScrollPane(this.monitorTableScrollPane);
        }
    }

    private class MonitorRowsDocumentListener
    implements DocumentListener {
        private MonitorRowsDocumentListener() {
        }

        public void insertUpdate(DocumentEvent documentevent) {
            this.updateMonitorRows();
        }

        public void removeUpdate(DocumentEvent documentevent) {
            this.updateMonitorRows();
        }

        public void changedUpdate(DocumentEvent documentevent) {
        }

        private void updateMonitorRows() {
            String rowsStr = SearchMonitorTab.this.numberOfMonitorRows.getText();
            try {
                int rows = Integer.parseInt(rowsStr);
                rows = Math.max(1, rows);
                SearchMonitorTab.this.queryHistory.setMaxHistroySize(rows);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private class EnableMonitorActionListener
    implements ActionListener {
        private EnableMonitorActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            SearchMonitorTab.this.queryHistory.setHistoryMonitored(SearchMonitorTab.this.enableMonitorCheckbox.isSelected());
        }
    }
}

