/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.tabs.download;

import java.awt.EventQueue;
import java.util.Comparator;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import org.apache.commons.collections.comparators.ComparableComparator;
import org.bushe.swing.event.annotation.EventTopicSubscriber;
import phex.common.format.NumberFormatUtils;
import phex.download.DownloadScopeList;
import phex.download.swarming.SWDownloadCandidate;
import phex.download.swarming.SWDownloadFile;
import phex.download.swarming.SWDownloadInfo;
import phex.download.swarming.SWDownloadSegment;
import phex.download.swarming.SwarmingManager;
import phex.event.ContainerEvent;
import phex.gui.common.GUIRegistry;
import phex.gui.common.table.FWSortableTableModel;
import phex.gui.common.table.FWTable;
import phex.gui.comparator.DestAddressComparator;
import phex.gui.renderer.HostAddressCellRenderer;
import phex.gui.renderer.ScopeProgressCellRenderer;
import phex.utils.Localizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SWCandidateTableModel
extends FWSortableTableModel {
    public static final int HOST_MODEL_INDEX = 0;
    public static final int VENDOR_MODEL_INDEX = 1;
    public static final int PROGRESS_MODEL_INDEX = 2;
    public static final int TOTAL_DOWNLOAD_MODEL_INDEX = 3;
    public static final int RATE_MODEL_INDEX = 4;
    public static final int STATUS_MODEL_INDEX = 5;
    public static final int HOST_COLUMN_ID = 1001;
    public static final int VENDOR_COLUMN_ID = 1002;
    public static final int PROGRESS_COLUMN_ID = 1003;
    public static final int TOTAL_DOWNLOAD_COLUMN_ID = 1004;
    public static final int RATE_COLUMN_ID = 1005;
    public static final int STATUS_COLUMN_ID = 1006;
    private static final Integer[] COLUMN_IDS = new Integer[]{1001, 1002, 1003, 1004, 1005, 1006};
    private static String[] tableColumns = new String[]{Localizer.getString("SharingHost"), Localizer.getString("Vendor"), Localizer.getString("DownloadTable_Available"), Localizer.getString("DownloadTable_DownloadTotal"), Localizer.getString("Rate"), Localizer.getString("Status")};
    private static Class[] tableClasses = new Class[]{HostAddressCellRenderer.class, String.class, ScopeProgressCellRenderer.class, String.class, String.class, String.class};
    private final SwarmingManager downloadService;
    private SWDownloadFile downloadFile;
    private FWTable downloadTable;

    public SWCandidateTableModel(FWTable aDownloadTable, SwarmingManager downloadService) {
        super(COLUMN_IDS, tableColumns, tableClasses);
        if (downloadService == null) {
            throw new NullPointerException("DownloadService missing");
        }
        this.downloadService = downloadService;
        this.downloadTable = aDownloadTable;
        this.downloadTable.getSelectionModel().addListSelectionListener(new DownloadSelectionChangeHandler());
        GUIRegistry.getInstance().getServent().getEventService().processAnnotations(this);
    }

    public SWDownloadFile getDownloadFile() {
        return this.downloadFile;
    }

    @Override
    public int getRowCount() {
        if (this.downloadFile == null) {
            return 0;
        }
        return this.downloadFile.getCandidatesCount();
    }

    @Override
    public Object getValueAt(int row, int column) {
        SWDownloadCandidate candidate = this.downloadFile.getCandidate(row);
        if (candidate == null) {
            this.fireTableRowsDeleted(row, row);
            return null;
        }
        switch (column) {
            case 0: {
                return candidate.getHostAddress();
            }
            case 1: {
                return candidate.getVendor();
            }
            case 2: {
                return candidate;
            }
            case 3: {
                return NumberFormatUtils.formatSignificantByteSize(candidate.getTotalDownloadSize());
            }
            case 4: {
                SWDownloadSegment segment = candidate.getDownloadSegment();
                if (segment == null) {
                    return null;
                }
                return NumberFormatUtils.formatSignificantByteSize(segment.getTransferSpeed()) + Localizer.getString("PerSec");
            }
            case 5: {
                return SWDownloadInfo.getDownloadCandidateStatusString(candidate);
            }
        }
        return null;
    }

    @Override
    public Comparator<?> getColumnComparator(int column) {
        switch (column) {
            case 0: {
                return new DestAddressComparator();
            }
            case 2: {
                return ComparableComparator.getInstance();
            }
        }
        return null;
    }

    @Override
    public Object getComparableValueAt(int row, int column) {
        SWDownloadCandidate candidate = this.downloadFile.getCandidate(row);
        if (candidate == null) {
            return null;
        }
        switch (column) {
            case 2: {
                DownloadScopeList availableScopeList = candidate.getAvailableScopeList();
                if (availableScopeList == null) {
                    return null;
                }
                return availableScopeList.getAggregatedLength();
            }
            case 3: {
                return candidate.getTotalDownloadSize();
            }
            case 5: {
                SWDownloadCandidate.CandidateStatus status = candidate.getStatus();
                if (status == SWDownloadCandidate.CandidateStatus.REMOTLY_QUEUED) {
                    int queuePosition = candidate.getXQueueParameters().getPosition();
                    Double doubObj = (double)status.ordinal() + 1.0 - Math.min((double)queuePosition, 10000.0) / 10000.0;
                    return doubObj;
                }
                long timeLeft = candidate.getStatusTimeLeft();
                double val = timeLeft == 0L ? (double)status.ordinal() : (double)status.ordinal() - 1.0 + 1.0 / (double)timeLeft;
                return val;
            }
            case 4: {
                SWDownloadSegment segment = candidate.getDownloadSegment();
                if (segment == null) {
                    return null;
                }
                return segment.getTransferSpeed();
            }
        }
        return this.getValueAt(row, column);
    }

    @Override
    public boolean isColumnHideable(int columnIndex) {
        return columnIndex != 0;
    }

    @EventTopicSubscriber(topic="phex:download/candidate")
    public void onDownloadCandidateEvent(String topic, final ContainerEvent event) {
        if (this.downloadFile != ((SWDownloadCandidate)event.getSource()).getDownloadFile()) {
            return;
        }
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                int position = event.getPosition();
                if (event.getType() == ContainerEvent.Type.ADDED) {
                    SWCandidateTableModel.this.fireTableChanged(new TableModelEvent(SWCandidateTableModel.this, position, position, -1, 1));
                } else if (event.getType() == ContainerEvent.Type.REMOVED) {
                    SWCandidateTableModel.this.fireTableChanged(new TableModelEvent(SWCandidateTableModel.this, position, position, -1, -1));
                }
            }
        });
    }

    private class DownloadSelectionChangeHandler
    implements ListSelectionListener {
        private DownloadSelectionChangeHandler() {
        }

        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                ListSelectionModel model = (ListSelectionModel)e.getSource();
                int viewIdx = model.getMinSelectionIndex();
                int modelIdx = SWCandidateTableModel.this.downloadTable.translateRowIndexToModel(viewIdx);
                SWDownloadFile tmpDownloadFile = SWCandidateTableModel.this.downloadService.getDownloadFile(modelIdx);
                if (tmpDownloadFile != SWCandidateTableModel.this.downloadFile) {
                    SWCandidateTableModel.this.downloadFile = tmpDownloadFile;
                    SWCandidateTableModel.this.fireTableDataChanged();
                }
            }
        }
    }
}

