/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.renderer;

import java.awt.Component;
import javax.swing.JTable;
import phex.common.TransferDataProvider;
import phex.common.format.TimeFormatUtils;
import phex.gui.renderer.CellColorHandler;
import phex.gui.renderer.FWTableCellRenderer;
import phex.utils.Localizer;

public class ETACellRenderer
extends FWTableCellRenderer {
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (value instanceof TransferDataProvider) {
            TransferDataProvider provider = (TransferDataProvider)value;
            if (isSelected) {
                this.setForeground(table.getSelectionForeground());
            } else {
                CellColorHandler.applyCellColor(provider, this);
            }
            long transferredSize = provider.getTransferredDataSize();
            long totalTransferSize = provider.getTransferDataSize();
            long transferRate = provider.getLongTermTransferRate();
            if (totalTransferSize == -1L || provider.getDataTransferStatus() != 10) {
                this.setText("");
            } else {
                long timeRemaining;
                if (transferRate == 0L) {
                    timeRemaining = 31536000L;
                } else {
                    timeRemaining = (totalTransferSize - transferredSize) / transferRate;
                    timeRemaining = Math.max(0L, timeRemaining);
                }
                if (timeRemaining < 31536000L) {
                    this.setText(TimeFormatUtils.formatSignificantElapsedTime(timeRemaining));
                } else {
                    this.setText(Localizer.getDecimalFormatSymbols().getInfinity());
                }
            }
        }
        return this;
    }
}

