/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.models;

import phex.gui.common.table.FWSortableTableModel;
import phex.statistic.StatisticProvider;
import phex.statistic.StatisticProviderConstants;
import phex.statistic.StatisticsManager;
import phex.utils.Localizer;

public class StatisticsTableModel
extends FWSortableTableModel
implements StatisticProviderConstants {
    private static final int NAME_MODEL_INDEX = 0;
    private static final int VALUE_MODEL_INDEX = 1;
    private static final int AVG_MODEL_INDEX = 2;
    private static final int MAX_MODEL_INDEX = 3;
    private static final int NAME_COLUMN_ID = 1001;
    private static final int VALUE_COLUMN_ID = 1002;
    private static final int AVG_COLUMN_ID = 1003;
    private static final int MAX_COLUMN_ID = 1004;
    private static final Integer[] COLUMN_IDS = new Integer[]{1001, 1002, 1003, 1004};
    private static String[] tableColumns = new String[]{Localizer.getString("Name"), Localizer.getString("Value"), Localizer.getString("Avg."), Localizer.getString("Max.")};
    private static Class[] tableClasses = new Class[]{String.class, String.class, String.class, String.class};
    private static String[] rowKeys = new String[]{"TotalBandwidthProvider", "NetworkBandwidthProvider", "DownloadBandwidthProvider", "UploadBandwidthProvider", "HorizonHostCountProvider", "HorizonFileCountProvider", "HorizonFileSizeProvider", "TotalMsgInProvider", "PingMsgInProvider", "PongMsgInProvider", "QueryMsgInProvider", "QueryHitMsgInProvider", "PushMsgInProvider", "TotalMsgOutProvider", "PingMsgOutProvider", "PongMsgOutProvider", "QueryMsgOutProvider", "QueryHitMsgOutProvider", "PushMsgOutProvider", "DropedMsgTotalProvider", "DropedMsgInProvider", "DropedMsgOutProvider", "PushDownloadAttemptsProvider", "PushDownloadSucessProvider", "PushDownloadFailureProvider", "PushDldPushProxyAttemptsProvider", "PushDldPushProxySuccessProvider", "PushUploadAttemptsProvider", "PushUploadSucessProvider", "PushUploadFailureProvider", "UptimeProvider", "DailyUptimeProvider"};
    private StatisticsManager statsService;

    public StatisticsTableModel(StatisticsManager statsService) {
        super(COLUMN_IDS, tableColumns, tableClasses);
        this.statsService = statsService;
    }

    public int getRowCount() {
        return rowKeys.length;
    }

    public Object getValueAt(int row, int column) {
        if (column == 0) {
            return Localizer.getString(rowKeys[row]);
        }
        if (column == 1) {
            StatisticProvider provider = this.statsService.getStatisticProvider(rowKeys[row]);
            if (provider == null) {
                return "";
            }
            Object value = provider.getValue();
            if (value != null) {
                return provider.toStatisticString(value);
            }
        } else if (column == 2) {
            StatisticProvider provider = this.statsService.getStatisticProvider(rowKeys[row]);
            if (provider == null) {
                return "";
            }
            Object value = provider.getAverageValue();
            if (value != null) {
                return provider.toStatisticString(value);
            }
        } else if (column == 3) {
            StatisticProvider provider = this.statsService.getStatisticProvider(rowKeys[row]);
            if (provider == null) {
                return "";
            }
            Object value = provider.getMaxValue();
            if (value != null) {
                return provider.toStatisticString(value);
            }
        }
        return "";
    }

    public boolean isColumnHideable(int columnIndex) {
        return columnIndex != 0;
    }
}

