/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.dialogs.options;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.util.HashMap;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import phex.gui.common.GUIRegistry;
import phex.gui.common.HTMLMultiLinePanel;
import phex.gui.common.IconPack;
import phex.gui.dialogs.options.OptionsSettingsPane;
import phex.gui.prefs.InterfacePrefs;
import phex.gui.renderer.FWListCellRenderer;
import phex.utils.Localizer;

public class LanguagePane
extends OptionsSettingsPane {
    private JList languageList;

    public LanguagePane() {
        super("LanguageSettings_Language");
    }

    protected void prepareComponent() {
        this.setLayout(new BorderLayout());
        JPanel contentPanel = new JPanel();
        this.add((Component)contentPanel, "Center");
        FormLayout layout = new FormLayout("10dlu, d, 2dlu:grow", "p, 3dlu, p, 2dlu, fill:d:grow, 3dlu, p");
        contentPanel.setLayout((LayoutManager)layout);
        PanelBuilder builder = new PanelBuilder(layout, contentPanel);
        CellConstraints cc = new CellConstraints();
        builder.addSeparator(Localizer.getString("LanguageSettings_LanguageSettings"), cc.xywh(1, 1, 3, 1));
        HTMLMultiLinePanel textPanel = new HTMLMultiLinePanel(Localizer.getString("LanguageSettings_SelectYourLanguage"));
        builder.add((Component)textPanel, cc.xy(2, 3));
        this.languageList = new JList<Object>(Localizer.getAvailableLocales().toArray());
        this.languageList.setSelectionMode(0);
        this.languageList.setVisibleRowCount(5);
        this.languageList.setCellRenderer(new LanguageListCellRenderer());
        Font lanugageListFont = this.getLanugageListFont();
        this.languageList.setFont(lanugageListFont);
        this.languageList.setFixedCellHeight(lanugageListFont.getSize() * 2);
        JScrollPane scrollPane = new JScrollPane(this.languageList);
        builder.add((Component)scrollPane, cc.xy(2, 5));
        HTMLMultiLinePanel textPanel2 = new HTMLMultiLinePanel(Localizer.getString("LanguageSettings_RestartNote"));
        builder.add((Component)textPanel2, cc.xy(2, 7));
        Locale locale = Localizer.getUsedLocale();
        this.languageList.setSelectedValue(locale, true);
    }

    public void updateUI() {
        super.updateUI();
        if (this.languageList != null) {
            Font lanugageListFont = this.getLanugageListFont();
            this.languageList.setFont(lanugageListFont);
            this.languageList.setFixedCellHeight(lanugageListFont.getSize() * 2);
        }
    }

    private Font getLanugageListFont() {
        return UIManager.getFont("TitledBorder.font").deriveFont(1);
    }

    public void saveAndApplyChanges(HashMap inputDic) {
        if (this.languageList.getSelectedIndex() == -1) {
            return;
        }
        Locale selectedLocale = (Locale)this.languageList.getSelectedValue();
        String localeStr = selectedLocale.toString();
        if (!localeStr.equals(InterfacePrefs.LocaleName.get())) {
            InterfacePrefs.LocaleName.set(localeStr);
            Localizer.setUsedLocale(selectedLocale);
        }
    }

    public class LanguageListCellRenderer
    extends FWListCellRenderer {
        private IconPack iconFactory = GUIRegistry.getInstance().getCountryIconPack();

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            if (value instanceof Locale) {
                String country;
                Locale locale = (Locale)value;
                String text = locale.getDisplayLanguage(locale);
                String variant = locale.getDisplayVariant(locale);
                if (variant != null && variant.length() > 0) {
                    text = text + " / " + variant;
                }
                if ((country = locale.getDisplayCountry(locale)) != null && country.length() > 0) {
                    text = text + " (" + country + ")";
                }
                this.setText(text);
                String countryCode = locale.getCountry();
                Icon icon = null;
                if (countryCode != null && countryCode.length() > 0) {
                    icon = this.iconFactory.getIcon(countryCode);
                }
                this.setIcon(icon);
            }
            return this;
        }
    }
}

