/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.common.treetable;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.List;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import org.jdesktop.swingx.JXTree;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.treetable.TreeTableCellEditor;
import phex.gui.common.table.FWTable;
import phex.gui.common.treetable.TreeTableModel;
import phex.gui.common.treetable.TreeTableModelAdapter;
import sun.swing.UIAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JTreeTable
extends FWTable {
    public static final String DRAG_HACK_FLAG_KEY = "treeTable.dragHackFlag";
    private TreeTableCellRenderer renderer;
    private TreeTableCellEditor hierarchicalEditor;
    private TreeTableHacker treeTableHacker;
    private boolean consumedOnPress;
    private TableAdapter dataAdapter;

    public JTreeTable(TreeTableModel treeModel) {
        this(new TreeTableCellRenderer(treeModel));
    }

    private JTreeTable(TreeTableCellRenderer renderer) {
        super(new TreeTableModelAdapter(renderer));
        this.init(renderer);
        this.initActions();
        this.setShowGrid(false);
        this.hierarchicalEditor = new TreeTableCellEditor(renderer);
        this.setColumnSelectionAllowed(false);
    }

    private void init(TreeTableCellRenderer renderer) {
        this.renderer = renderer;
        assert (((TreeTableModelAdapter)this.getModel()).tree == this.renderer);
        ListToTreeSelectionModelWrapper selectionWrapper = new ListToTreeSelectionModelWrapper();
        if (renderer != null) {
            renderer.bind(this);
            renderer.setSelectionModel(selectionWrapper);
        }
        this.adjustTreeRowHeight(this.getRowHeight());
        this.setSelectionModel(selectionWrapper.getListSelectionModel());
        PropertyChangeListener l = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                JTreeTable.this.renderer.putClientProperty(evt.getPropertyName(), evt.getNewValue());
            }
        };
        this.addPropertyChangeListener("JTree.lineStyle", l);
    }

    private void initActions() {
        ActionMap map = this.getActionMap();
        map.put("expand-all", new Actions("expand-all"));
        map.put("collapse-all", new Actions("collapse-all"));
    }

    @Override
    public boolean editCellAt(int row, int column, EventObject e) {
        this.getTreeTableHacker().hitHandleDetectionFromEditCell(column, e);
        boolean canEdit = super.editCellAt(row, column, e);
        if (canEdit && this.isHierarchical(column)) {
            this.repaint(this.getCellRect(row, column, false));
        }
        return canEdit;
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        if (e.getID() == 502 && this.consumedOnPress) {
            this.consumedOnPress = false;
            e.consume();
            return;
        }
        if (this.getTreeTableHacker().hitHandleDetectionFromProcessMouse(e)) {
            this.consumedOnPress = true;
            e.consume();
            return;
        }
        this.consumedOnPress = false;
        super.processMouseEvent(e);
    }

    protected TreeTableHacker getTreeTableHacker() {
        if (this.treeTableHacker == null) {
            this.treeTableHacker = this.createTreeTableHacker();
        }
        return this.treeTableHacker;
    }

    protected TreeTableHacker createTreeTableHacker() {
        return new TreeTableHackerExt();
    }

    protected boolean hackAroundDragEnabled(MouseEvent me) {
        Boolean dragHackFlag = (Boolean)this.getClientProperty(DRAG_HACK_FLAG_KEY);
        if (dragHackFlag == null) {
            String priority = null;
            try {
                priority = System.getProperty("sun.swing.enableImprovedDragGesture");
            }
            catch (Exception ex) {
                // empty catch block
            }
            dragHackFlag = priority == null;
            this.putClientProperty(DRAG_HACK_FLAG_KEY, dragHackFlag);
        }
        return this.getDragEnabled() && dragHackFlag != false;
    }

    @Override
    public int getEditingRow() {
        return this.isHierarchical(this.editingColumn) ? -1 : this.editingRow;
    }

    private int realEditingRow() {
        return this.editingRow;
    }

    public Object getNodeOfRow(int row) {
        TreePath treePath = this.renderer.getPathForRow(row);
        if (treePath == null) {
            return null;
        }
        return treePath.getLastPathComponent();
    }

    public void setTreeTableModel(TreeTableModel treeModel) {
        TreeTableModel old = this.getTreeTableModel();
        this.renderer.setModel(treeModel);
        this.firePropertyChange("treeTableModel", old, this.getTreeTableModel());
    }

    public TreeTableModel getTreeTableModel() {
        return (TreeTableModel)this.renderer.getModel();
    }

    @Override
    public final void setModel(TableModel tableModel) {
        if (tableModel instanceof TreeTableModelAdapter) {
            if (((TreeTableModelAdapter)tableModel).getTreeTable() != null) {
                throw new IllegalArgumentException("model already bound");
            }
        } else {
            throw new IllegalArgumentException("unsupported model type");
        }
        super.setModel(tableModel);
        ((TreeTableModelAdapter)tableModel).bind(this);
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (this.isStructureChanged(e) || this.isUpdate(e)) {
            super.tableChanged(e);
        } else {
            this.resizeAndRepaint();
        }
    }

    @Override
    public final void setRowHeight(int row, int rowHeight) {
        throw new UnsupportedOperationException("variable height rows not supported");
    }

    @Override
    public void setRowHeight(int rowHeight) {
        super.setRowHeight(rowHeight);
        this.adjustTreeRowHeight(this.getRowHeight());
    }

    protected void adjustTreeRowHeight(int tableRowHeight) {
        if (this.renderer != null && this.renderer.getRowHeight() != tableRowHeight) {
            this.renderer.setRowHeight(tableRowHeight);
        }
    }

    @Override
    public void setSelectionMode(int mode) {
        if (this.renderer != null) {
            switch (mode) {
                case 1: {
                    this.renderer.getSelectionModel().setSelectionMode(2);
                    break;
                }
                case 2: {
                    this.renderer.getSelectionModel().setSelectionMode(4);
                    break;
                }
                default: {
                    this.renderer.getSelectionModel().setSelectionMode(1);
                }
            }
        }
        super.setSelectionMode(mode);
    }

    @Override
    public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
        Component component = super.prepareRenderer(renderer, row, column);
        return this.applyRenderer(component, this.getComponentAdapter(row, column));
    }

    protected Component applyRenderer(Component component, ComponentAdapter adapter) {
        TreeCellRenderer tcr;
        if (component == null) {
            throw new IllegalArgumentException("null component");
        }
        if (adapter == null) {
            throw new IllegalArgumentException("null component data adapter");
        }
        if (this.isHierarchical(adapter.column) && (tcr = this.renderer.getCellRenderer()) instanceof DefaultTreeCellRenderer) {
            DefaultTreeCellRenderer dtcr = (DefaultTreeCellRenderer)tcr;
            if (adapter.isSelected()) {
                dtcr.setTextSelectionColor(component.getForeground());
                dtcr.setBackgroundSelectionColor(component.getBackground());
            } else {
                dtcr.setTextNonSelectionColor(component.getForeground());
                dtcr.setBackgroundNonSelectionColor(component.getBackground());
            }
        }
        return component;
    }

    public void setTreeCellRenderer(TreeCellRenderer cellRenderer) {
        if (this.renderer != null) {
            this.renderer.setCellRenderer(cellRenderer);
        }
    }

    public TreeCellRenderer getTreeCellRenderer() {
        return this.renderer.getCellRenderer();
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        int column = this.columnAtPoint(event.getPoint());
        if (this.isHierarchical(column)) {
            int row = this.rowAtPoint(event.getPoint());
            return this.renderer.getToolTipText(event, row, column);
        }
        return super.getToolTipText(event);
    }

    public void setCollapsedIcon(Icon icon) {
        this.renderer.setCollapsedIcon(icon);
    }

    public void setExpandedIcon(Icon icon) {
        this.renderer.setExpandedIcon(icon);
    }

    @Override
    public void clearSelection() {
        if (this.renderer != null) {
            this.renderer.clearSelection();
        }
        super.clearSelection();
    }

    public void collapseAll() {
        this.renderer.collapseAll();
    }

    public void expandAll() {
        this.renderer.expandAll();
    }

    public void collapsePath(TreePath path) {
        this.renderer.collapsePath(path);
    }

    public void expandPath(TreePath path) {
        this.renderer.expandPath(path);
    }

    public void scrollPathToVisible(TreePath path) {
        this.renderer.scrollPathToVisible(path);
    }

    public void collapseRow(int row) {
        this.renderer.collapseRow(row);
    }

    public void expandRow(int row) {
        this.renderer.expandRow(row);
    }

    public boolean isVisible(TreePath path) {
        return this.renderer.isVisible(path);
    }

    public boolean isExpanded(TreePath path) {
        return this.renderer.isExpanded(path);
    }

    public boolean isExpanded(int row) {
        return this.renderer.isExpanded(row);
    }

    public boolean isCollapsed(TreePath path) {
        return this.renderer.isCollapsed(path);
    }

    public boolean isCollapsed(int row) {
        return this.renderer.isCollapsed(row);
    }

    public Enumeration<?> getExpandedDescendants(TreePath parent) {
        return this.renderer.getExpandedDescendants(parent);
    }

    public TreePath getPathForLocation(int x, int y) {
        int row = this.rowAtPoint(new Point(x, y));
        if (row == -1) {
            return null;
        }
        return this.renderer.getPathForRow(row);
    }

    public TreePath getPathForRow(int row) {
        return this.renderer.getPathForRow(row);
    }

    public int getRowForPath(TreePath path) {
        return this.renderer.getRowForPath(path);
    }

    public void setRootVisible(boolean visible) {
        this.renderer.setRootVisible(visible);
        this.revalidate();
        this.repaint();
    }

    public boolean isRootVisible() {
        return this.renderer.isRootVisible();
    }

    public void setScrollsOnExpand(boolean scroll) {
        this.renderer.setScrollsOnExpand(scroll);
    }

    public boolean getScrollsOnExpand() {
        return this.renderer.getScrollsOnExpand();
    }

    public void setShowsRootHandles(boolean visible) {
        this.renderer.setShowsRootHandles(visible);
        this.repaint();
    }

    public boolean getShowsRootHandles() {
        return this.renderer.getShowsRootHandles();
    }

    public void setExpandsSelectedPaths(boolean expand) {
        this.renderer.setExpandsSelectedPaths(expand);
    }

    public boolean getExpandsSelectedPaths() {
        return this.renderer.getExpandsSelectedPaths();
    }

    public int getToggleClickCount() {
        return this.renderer.getToggleClickCount();
    }

    public void setToggleClickCount(int clickCount) {
        this.renderer.setToggleClickCount(clickCount);
    }

    public boolean isLargeModel() {
        return this.renderer.isLargeModel();
    }

    public void setLargeModel(boolean newValue) {
        this.renderer.setLargeModel(newValue);
    }

    public void addTreeExpansionListener(TreeExpansionListener tel) {
        this.renderer.addTreeExpansionListener(tel);
    }

    public void removeTreeExpansionListener(TreeExpansionListener tel) {
        this.renderer.removeTreeExpansionListener(tel);
    }

    public void addTreeSelectionListener(TreeSelectionListener tsl) {
        this.renderer.addTreeSelectionListener(tsl);
    }

    public void removeTreeSelectionListener(TreeSelectionListener tsl) {
        this.renderer.removeTreeSelectionListener(tsl);
    }

    public void addTreeWillExpandListener(TreeWillExpandListener tel) {
        this.renderer.addTreeWillExpandListener(tel);
    }

    public void removeTreeWillExpandListener(TreeWillExpandListener tel) {
        this.renderer.removeTreeWillExpandListener(tel);
    }

    public TreeSelectionModel getTreeSelectionModel() {
        return this.renderer.getSelectionModel();
    }

    @Override
    public void sizeColumnsToFit(int resizingColumn) {
        super.sizeColumnsToFit(resizingColumn);
        if (this.getEditingColumn() != -1 && this.isHierarchical(this.editingColumn)) {
            Rectangle cellRect = this.getCellRect(this.realEditingRow(), this.getEditingColumn(), false);
            Component component = this.getEditorComponent();
            component.setBounds(cellRect);
            component.validate();
        }
    }

    public boolean isHierarchical(int column) {
        if (column < 0 || column >= this.getColumnCount()) {
            throw new IllegalArgumentException("column must be valid, was" + column);
        }
        return this.getHierarchicalColumn() == column;
    }

    public int getHierarchicalColumn() {
        return this.convertColumnIndexToView(((TreeTableModel)this.renderer.getModel()).getHierarchicalColumn());
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        if (this.isHierarchical(column)) {
            return this.renderer;
        }
        return super.getCellRenderer(row, column);
    }

    @Override
    public TableCellEditor getCellEditor(int row, int column) {
        if (this.isHierarchical(column)) {
            return this.hierarchicalEditor;
        }
        return super.getCellEditor(row, column);
    }

    protected ComponentAdapter getComponentAdapter() {
        if (this.dataAdapter == null) {
            this.dataAdapter = new TreeTableDataAdapter(this);
        }
        return this.dataAdapter;
    }

    protected ComponentAdapter getComponentAdapter(int row, int column) {
        ComponentAdapter adapter = this.getComponentAdapter();
        adapter.row = row;
        adapter.column = column;
        return adapter;
    }

    protected static class TreeTableDataAdapter
    extends TableAdapter {
        private final JTreeTable table;

        public TreeTableDataAdapter(JTreeTable component) {
            super(component);
            this.table = component;
        }

        public JTreeTable getTreeTable() {
            return this.table;
        }

        public boolean isExpanded() {
            return this.table.isExpanded(this.row);
        }

        public int getDepth() {
            return this.table.getPathForRow(this.row).getPathCount() - 1;
        }

        public boolean isLeaf() {
            TreePath path = this.table.getPathForRow(this.row);
            if (path != null) {
                return this.table.getTreeTableModel().isLeaf(path.getLastPathComponent());
            }
            return true;
        }

        public boolean isHierarchical() {
            return this.table.isHierarchical(this.column);
        }
    }

    protected static class TableAdapter
    extends ComponentAdapter {
        private final FWTable table;

        public TableAdapter(FWTable component) {
            super(component);
            this.table = component;
        }

        public FWTable getTable() {
            return this.table;
        }

        public String getColumnName(int columnIndex) {
            TableColumn column = this.getColumnByModelIndex(columnIndex);
            return column == null ? "" : column.getHeaderValue().toString();
        }

        protected TableColumn getColumnByModelIndex(int modelColumn) {
            List<TableColumn> columns = this.table.getColumns(true);
            for (TableColumn column : columns) {
                if (column.getModelIndex() != modelColumn) continue;
                return column;
            }
            return null;
        }

        public String getColumnIdentifier(int columnIndex) {
            TableColumn column = this.getColumnByModelIndex(columnIndex);
            Object identifier = column != null ? column.getIdentifier() : null;
            return identifier != null ? identifier.toString() : null;
        }

        public int getColumnCount() {
            return this.table.getModel().getColumnCount();
        }

        public int getRowCount() {
            return this.table.getModel().getRowCount();
        }

        public Object getValueAt(int row, int column) {
            return this.table.getModel().getValueAt(row, column);
        }

        public void setValueAt(Object aValue, int row, int column) {
            this.table.getModel().setValueAt(aValue, row, column);
        }

        public boolean isCellEditable(int row, int column) {
            return this.table.getModel().isCellEditable(row, column);
        }

        public boolean isTestable(int column) {
            return this.getColumnByModelIndex(column) != null;
        }

        public Object getFilteredValueAt(int row, int column) {
            return this.getValueAt(this.table.translateRowIndexToModel(row), column);
        }

        public Object getValue() {
            return this.table.getValueAt(this.row, this.column);
        }

        public boolean isEditable() {
            return this.table.isCellEditable(this.row, this.column);
        }

        public boolean isSelected() {
            return this.table.isCellSelected(this.row, this.column);
        }

        public boolean hasFocus() {
            boolean rowIsLead = this.table.getSelectionModel().getLeadSelectionIndex() == this.row;
            boolean colIsLead = this.table.getColumnModel().getSelectionModel().getLeadSelectionIndex() == this.column;
            return this.table.isFocusOwner() && rowIsLead && colIsLead;
        }

        public int modelToView(int columnIndex) {
            return this.table.convertColumnIndexToView(columnIndex);
        }

        public int viewToModel(int columnIndex) {
            return this.table.convertColumnIndexToModel(columnIndex);
        }
    }

    static class TreeTableCellRenderer
    extends JXTree
    implements TableCellRenderer {
        protected Border highlightBorder = null;
        protected JTreeTable treeTable = null;
        protected int visibleRow = 0;
        private int hierarchicalColumnWidth = 0;

        public TreeTableCellRenderer(TreeTableModel model) {
            super(model);
            this.putClientProperty("JTree.lineStyle", "None");
            this.setRootVisible(false);
            this.setShowsRootHandles(true);
            this.setOverwriteRendererIcons(true);
            this.setCellRenderer(new ClippedTreeCellRenderer());
        }

        private String getToolTipText(MouseEvent event, int row, int column) {
            TreePath path;
            Object lastPath;
            if (row < 0) {
                return null;
            }
            TreeCellRenderer renderer = this.getCellRenderer();
            Component rComponent = renderer.getTreeCellRendererComponent(this, lastPath = (path = this.getPathForRow(row)).getLastPathComponent(), this.isRowSelected(row), this.isExpanded(row), this.getModel().isLeaf(lastPath), row, true);
            if (rComponent instanceof JComponent) {
                Rectangle pathBounds = this.getPathBounds(path);
                Rectangle cellRect = this.treeTable.getCellRect(row, column, false);
                Point mousePoint = event.getPoint();
                mousePoint.translate(-cellRect.x, -cellRect.y);
                mousePoint.translate(-pathBounds.x, 0);
                MouseEvent newEvent = new MouseEvent(rComponent, event.getID(), event.getWhen(), event.getModifiers(), mousePoint.x, mousePoint.y, event.getClickCount(), event.isPopupTrigger());
                return ((JComponent)rComponent).getToolTipText(newEvent);
            }
            return null;
        }

        public final void bind(JTreeTable treeTable) {
            if (treeTable == null) {
                throw new IllegalArgumentException("null treeTable");
            }
            if (this.treeTable != null) {
                throw new IllegalArgumentException("renderer already bound");
            }
            this.treeTable = treeTable;
        }

        public void scrollRectToVisible(Rectangle aRect) {
            this.treeTable.scrollRectToVisible(aRect);
        }

        protected void setExpandedState(TreePath path, boolean state) {
            super.setExpandedState(path, state);
            this.treeTable.getTreeTableHacker().completeEditing();
        }

        public void updateUI() {
            super.updateUI();
            TreeCellRenderer tcr = this.getCellRenderer();
            if (tcr instanceof DefaultTreeCellRenderer) {
                DefaultTreeCellRenderer dtcr = (DefaultTreeCellRenderer)tcr;
                dtcr.setBorderSelectionColor(null);
                dtcr.setTextSelectionColor(UIManager.getColor("Table.selectionForeground"));
                dtcr.setBackgroundSelectionColor(UIManager.getColor("Table.selectionBackground"));
            }
        }

        public void setRowHeight(int rowHeight) {
            super.setRowHeight(rowHeight);
            if (rowHeight > 0 && this.treeTable != null) {
                this.treeTable.setRowHeight(rowHeight);
            }
        }

        public void setBounds(int x, int y, int w, int h) {
            if (this.treeTable != null) {
                y = 0;
                h = this.treeTable.getRowCount() * this.getRowHeight();
            }
            super.setBounds(x, y, w, h);
        }

        public void paint(Graphics g) {
            Rectangle cellRect = this.treeTable.getCellRect(this.visibleRow, 0, false);
            g.translate(0, -cellRect.y);
            this.hierarchicalColumnWidth = this.getWidth();
            super.paint(g);
            if (this.highlightBorder != null) {
                this.highlightBorder.paintBorder(this, g, 0, cellRect.y, this.getWidth(), cellRect.height);
            }
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            assert (table == this.treeTable);
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
                this.setForeground(table.getSelectionForeground());
            } else {
                this.setBackground(table.getBackground());
                this.setForeground(table.getForeground());
            }
            this.highlightBorder = null;
            if (this.treeTable != null && (this.treeTable.realEditingRow() != row || this.treeTable.getEditingColumn() != column) && hasFocus) {
                this.highlightBorder = UIManager.getBorder("Table.focusCellHighlightBorder");
            }
            this.visibleRow = row;
            return this;
        }

        private class ClippedTreeCellRenderer
        extends DefaultTreeCellRenderer {
            private final Rectangle iconRect = new Rectangle();
            private final Rectangle textRect = new Rectangle();
            private final Rectangle itemRect = new Rectangle();

            private ClippedTreeCellRenderer() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void paint(Graphics g) {
                String fullText = super.getText();
                String shortText = SwingUtilities.layoutCompoundLabel(this, g.getFontMetrics(), fullText, this.getIcon(), this.getVerticalAlignment(), this.getHorizontalAlignment(), this.getVerticalTextPosition(), this.getHorizontalTextPosition(), this.getItemRect(this.itemRect), this.iconRect, this.textRect, this.getIconTextGap());
                try {
                    this.setText(shortText);
                    super.paint(g);
                }
                finally {
                    this.setText(fullText);
                }
            }

            private Rectangle getItemRect(Rectangle itemRect) {
                this.getBounds(itemRect);
                itemRect.width = TreeTableCellRenderer.this.hierarchicalColumnWidth - itemRect.x;
                return itemRect;
            }

            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                Object val = value;
                if (TreeTableCellRenderer.this.treeTable != null) {
                    int treeColumn = TreeTableCellRenderer.this.treeTable.getTreeTableModel().getHierarchicalColumn();
                    Object o = null;
                    if (treeColumn >= 0) {
                        o = TreeTableCellRenderer.this.treeTable.getTreeTableModel().getValueAt(value, treeColumn);
                    }
                    val = o;
                }
                return super.getTreeCellRendererComponent(tree, val, sel, expanded, leaf, row, hasFocus);
            }
        }
    }

    class ListToTreeSelectionModelWrapper
    extends DefaultTreeSelectionModel {
        protected boolean updatingListSelectionModel;

        public ListToTreeSelectionModelWrapper() {
            this.getListSelectionModel().addListSelectionListener(this.createListSelectionListener());
        }

        ListSelectionModel getListSelectionModel() {
            return this.listSelectionModel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resetRowSelection() {
            if (!this.updatingListSelectionModel) {
                this.updatingListSelectionModel = true;
                try {
                    super.resetRowSelection();
                }
                finally {
                    this.updatingListSelectionModel = false;
                }
            }
        }

        protected ListSelectionListener createListSelectionListener() {
            return new ListSelectionHandler();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void updateSelectedPathsFromSelectedRows() {
            if (!this.updatingListSelectionModel) {
                this.updatingListSelectionModel = true;
                try {
                    if (this.listSelectionModel.isSelectionEmpty()) {
                        this.clearSelection();
                    } else {
                        int min = this.listSelectionModel.getMinSelectionIndex();
                        int max = this.listSelectionModel.getMaxSelectionIndex();
                        ArrayList<TreePath> paths = new ArrayList<TreePath>();
                        for (int counter = min; counter <= max; ++counter) {
                            TreePath selPath;
                            if (!this.listSelectionModel.isSelectedIndex(counter) || (selPath = JTreeTable.this.renderer.getPathForRow(counter)) == null) continue;
                            paths.add(selPath);
                        }
                        this.setSelectionPaths(paths.toArray(new TreePath[paths.size()]));
                        this.leadRow = this.leadIndex;
                    }
                }
                finally {
                    this.updatingListSelectionModel = false;
                }
            }
        }

        class ListSelectionHandler
        implements ListSelectionListener {
            ListSelectionHandler() {
            }

            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    ListToTreeSelectionModelWrapper.this.updateSelectedPathsFromSelectedRows();
                }
            }
        }
    }

    public class TreeTableHackerExt2
    extends TreeTableHackerExt {
        protected boolean expandOrCollapseNode(int column, EventObject e) {
            if (!JTreeTable.this.isHierarchical(column)) {
                return false;
            }
            if (!this.mightBeExpansionTrigger(e)) {
                return false;
            }
            boolean changedExpansion = false;
            MouseEvent me = (MouseEvent)e;
            if (JTreeTable.this.hackAroundDragEnabled(me)) {
                me = new MouseEvent((Component)me.getSource(), 501, me.getWhen(), me.getModifiers(), me.getX(), me.getY(), me.getClickCount(), me.isPopupTrigger());
            }
            if (me.getModifiers() == 0 || me.getModifiers() == 16) {
                Point treeMousePoint = new Point(me.getX() - JTreeTable.this.getCellRect((int)0, (int)column, (boolean)false).x, me.getY());
                int treeRow = JTreeTable.this.renderer.getRowForLocation(treeMousePoint.x, treeMousePoint.y);
                int row = 0;
                if (treeRow < 0) {
                    row = JTreeTable.this.renderer.getClosestRowForLocation(treeMousePoint.x, treeMousePoint.y);
                    Rectangle bounds = JTreeTable.this.renderer.getRowBounds(row);
                    if (bounds == null) {
                        row = -1;
                    } else if (bounds.y + bounds.height < treeMousePoint.y || bounds.x > treeMousePoint.x) {
                        row = -1;
                    }
                    this.expansionChangedFlag = false;
                }
                if (treeRow >= 0 || treeRow < 0 && row < 0) {
                    MouseEvent pressed = new MouseEvent(JTreeTable.this.renderer, me.getID(), me.getWhen(), me.getModifiers(), treeMousePoint.x, treeMousePoint.y, me.getClickCount(), me.isPopupTrigger());
                    JTreeTable.this.renderer.dispatchEvent(pressed);
                    MouseEvent released = new MouseEvent(JTreeTable.this.renderer, 502, pressed.getWhen(), pressed.getModifiers(), pressed.getX(), pressed.getY(), pressed.getClickCount(), pressed.isPopupTrigger());
                    JTreeTable.this.renderer.dispatchEvent(released);
                }
                if (this.expansionChangedFlag) {
                    changedExpansion = true;
                }
            }
            this.expansionChangedFlag = false;
            return changedExpansion;
        }
    }

    public class TreeTableHackerExt
    extends TreeTableHacker {
        protected boolean isHitDetectionFromProcessMouse() {
            return true;
        }
    }

    public class TreeTableHacker {
        protected boolean expansionChangedFlag;

        protected boolean isHitDetectionFromProcessMouse() {
            return false;
        }

        public void hitHandleDetectionFromEditCell(int column, EventObject e) {
            if (!this.isHitDetectionFromProcessMouse()) {
                this.expandOrCollapseNode(column, e);
            }
        }

        public boolean hitHandleDetectionFromProcessMouse(MouseEvent e) {
            if (!this.isHitDetectionFromProcessMouse()) {
                return false;
            }
            int col = JTreeTable.this.columnAtPoint(e.getPoint());
            return col >= 0 && this.expandOrCollapseNode(col, e);
        }

        protected void completeEditing() {
            if (JTreeTable.this.isEditing()) {
                JTreeTable.this.getCellEditor().cancelCellEditing();
            }
        }

        protected boolean expandOrCollapseNode(int column, EventObject e) {
            if (!JTreeTable.this.isHierarchical(column)) {
                return false;
            }
            if (!this.mightBeExpansionTrigger(e)) {
                return false;
            }
            boolean changedExpansion = false;
            MouseEvent me = (MouseEvent)e;
            if (JTreeTable.this.hackAroundDragEnabled(me)) {
                me = new MouseEvent((Component)me.getSource(), 501, me.getWhen(), me.getModifiers(), me.getX(), me.getY(), me.getClickCount(), me.isPopupTrigger());
            }
            if (me.getModifiers() == 0 || me.getModifiers() == 16) {
                MouseEvent pressed = new MouseEvent(JTreeTable.this.renderer, me.getID(), me.getWhen(), me.getModifiers(), me.getX() - JTreeTable.this.getCellRect((int)0, (int)column, (boolean)false).x, me.getY(), me.getClickCount(), me.isPopupTrigger());
                JTreeTable.this.renderer.dispatchEvent(pressed);
                MouseEvent released = new MouseEvent(JTreeTable.this.renderer, 502, pressed.getWhen(), pressed.getModifiers(), pressed.getX(), pressed.getY(), pressed.getClickCount(), pressed.isPopupTrigger());
                JTreeTable.this.renderer.dispatchEvent(released);
                if (this.expansionChangedFlag) {
                    changedExpansion = true;
                }
            }
            this.expansionChangedFlag = false;
            return changedExpansion;
        }

        protected boolean mightBeExpansionTrigger(EventObject e) {
            if (!(e instanceof MouseEvent)) {
                return false;
            }
            MouseEvent me = (MouseEvent)e;
            if (!SwingUtilities.isLeftMouseButton(me)) {
                return false;
            }
            return me.getID() == 501;
        }

        protected void expansionChanged() {
            this.expansionChangedFlag = true;
        }
    }

    private class Actions
    extends UIAction {
        Actions(String name) {
            super(name);
        }

        public void actionPerformed(ActionEvent evt) {
            if ("expand-all".equals(this.getName())) {
                JTreeTable.this.expandAll();
            } else if ("collapse-all".equals(this.getName())) {
                JTreeTable.this.collapseAll();
            }
        }
    }
}

