/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.common.table;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import phex.gui.common.table.FWTable;
import phex.xml.sax.gui.DTableColumn;

public class FWTableColumn
extends TableColumn {
    protected Object prototypeValue;
    private boolean isVisible = true;
    private boolean isHideable = true;
    private boolean isSortingAscending = false;

    public FWTableColumn(int modelIndex) {
        super(modelIndex);
    }

    public FWTableColumn(int modelIndex, Object headerValue, Integer identifier) {
        this(modelIndex);
        this.setHeaderValue(headerValue);
        this.setIdentifier(identifier);
    }

    public void setPrototypeValue(Object value) {
        Object oldPrototypeValue = this.prototypeValue;
        this.prototypeValue = value;
        this.firePropertyChange("prototypeValue", oldPrototypeValue, value);
    }

    public Object getPrototypeValue() {
        return this.prototypeValue;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public boolean isHideable() {
        return this.isHideable;
    }

    public void setHideable(boolean state) {
        boolean oldHideable = this.isHideable;
        this.isHideable = state;
        this.firePropertyChange("visible", oldHideable, this.isHideable);
    }

    public void setVisible(boolean state) {
        boolean oldVisible = this.isVisible;
        this.isVisible = state;
        this.firePropertyChange("visible", oldVisible, this.isVisible);
    }

    public boolean reverseSortingOrder() {
        this.isSortingAscending = !this.isSortingAscending;
        return this.isSortingAscending;
    }

    public void sizeWidthToFitData(JTable table, TableModel model) {
        TableCellRenderer aCellRenderer = this.cellRenderer;
        if (this.cellRenderer == null) {
            aCellRenderer = table.getDefaultRenderer(model.getColumnClass(this.modelIndex));
        }
        int maxWidth = 0;
        int rowCount = model.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            Object value = model.getValueAt(i, this.modelIndex);
            Component component = aCellRenderer.getTableCellRendererComponent(table, value, false, false, i, this.modelIndex);
            maxWidth = Math.max(component.getPreferredSize().width + 4, maxWidth);
        }
        this.setPreferredWidth(maxWidth);
    }

    public DTableColumn createDGuiTableColumn() {
        DTableColumn dColumn = new DTableColumn();
        dColumn.setColumnID((Integer)this.getIdentifier());
        dColumn.setVisible(this.isVisible);
        dColumn.setWidth(this.getWidth());
        return dColumn;
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        PropertyChangeListener[] pcl;
        if ((oldValue != null && !oldValue.equals(newValue) || oldValue == null && newValue != null) && (pcl = this.getPropertyChangeListeners()) != null && pcl.length != 0) {
            PropertyChangeEvent pce = new PropertyChangeEvent(this, propertyName, oldValue, newValue);
            for (int i = 0; i < pcl.length; ++i) {
                pcl[i].propertyChange(pce);
            }
        }
    }

    public static int calculateHeaderWidth(FWTable table, FWTableColumn col) {
        TableCellRenderer aCellRenderer = col.getHeaderRenderer();
        if (aCellRenderer == null) {
            aCellRenderer = table.getTableHeader().getDefaultRenderer();
        }
        Component component = aCellRenderer.getTableCellRendererComponent(table, col.getHeaderValue(), false, false, -1, col.getModelIndex());
        int width = Math.max(component.getPreferredSize().width + 4, 75);
        return width;
    }
}

