/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.common.table;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import phex.gui.common.table.FWSortedTableModel;
import phex.gui.common.table.FWTable;
import phex.gui.common.table.FWTableColumn;
import phex.gui.common.table.FWTableModel;

public class ColumnFactory {
    private static ColumnFactory columnFactory;
    private int packMargin = 4;

    public static synchronized ColumnFactory getInstance() {
        if (columnFactory == null) {
            columnFactory = new ColumnFactory();
        }
        return columnFactory;
    }

    public static synchronized void setInstance(ColumnFactory factory) {
        columnFactory = factory;
    }

    public FWTableColumn createAndConfigureTableColumn(TableModel model, int modelIndex) {
        FWTableColumn column = this.createTableColumn(modelIndex);
        this.configureTableColumn(model, column);
        return column;
    }

    public FWTableColumn createTableColumn(int modelIndex) {
        return new FWTableColumn(modelIndex);
    }

    public void configureTableColumn(TableModel model, FWTableColumn column) {
        int modelIndex = column.getModelIndex();
        if (modelIndex < 0 || modelIndex >= model.getColumnCount()) {
            throw new IllegalStateException("column must have valid modelIndex");
        }
        column.setHeaderValue(model.getColumnName(modelIndex));
        FWTableModel fwModel = null;
        if (model instanceof FWTableModel) {
            fwModel = (FWTableModel)model;
        } else if (model instanceof FWSortedTableModel) {
            fwModel = ((FWSortedTableModel)model).getTableModel();
        }
        if (fwModel != null) {
            Object columnId = fwModel.getColumnId(modelIndex);
            column.setIdentifier(columnId);
            column.setHideable(fwModel.isColumnHideable(modelIndex));
            column.setVisible(fwModel.isColumnDefaultVisible(modelIndex));
        }
    }

    public void configureColumnWidths(FWTable table, FWTableColumn column) {
        Dimension cellSpacing = table.getIntercellSpacing();
        Object prototypeValue = column.getPrototypeValue();
        if (prototypeValue != null) {
            JTableHeader header;
            TableCellRenderer renderer = table.getCellRenderer(0, table.convertColumnIndexToView(column.getModelIndex()));
            Component comp = renderer.getTableCellRendererComponent(table, prototypeValue, false, false, 0, 0);
            int prefWidth = comp.getPreferredSize().width + cellSpacing.width;
            renderer = column.getHeaderRenderer();
            if (renderer == null && (header = table.getTableHeader()) != null) {
                renderer = header.getDefaultRenderer();
            }
            if (renderer != null) {
                comp = renderer.getTableCellRendererComponent(table, column.getHeaderValue(), false, false, 0, table.convertColumnIndexToView(column.getModelIndex()));
                prefWidth = Math.max(comp.getPreferredSize().width, prefWidth);
            }
            column.setPreferredWidth(prefWidth += table.getColumnModel().getColumnMargin());
        }
    }

    public void packColumn(FWTable table, FWTableColumn column, int margin, int max) {
        TableCellRenderer renderer = column.getHeaderRenderer();
        if (renderer == null) {
            renderer = table.getTableHeader().getDefaultRenderer();
        }
        int viewIdx = table.convertColumnIndexToView(column.getModelIndex());
        Component comp = renderer.getTableCellRendererComponent(table, column.getHeaderValue(), false, false, 0, viewIdx);
        int width = comp.getPreferredSize().width;
        if (this.getRowCount(table) > 0) {
            renderer = table.getCellRenderer(0, viewIdx);
        }
        for (int r = 0; r < this.getRowCount(table); ++r) {
            comp = renderer.getTableCellRendererComponent(table, table.getValueAt(r, viewIdx), false, false, r, viewIdx);
            width = Math.max(width, comp.getPreferredSize().width);
        }
        if (margin < 0) {
            margin = this.getDefaultPackMargin();
        }
        if (max != -1 && (width += 2 * margin) > max) {
            width = max;
        }
        column.setPreferredWidth(width);
    }

    protected int getRowCount(FWTable table) {
        return table.getRowCount();
    }

    public int getDefaultPackMargin() {
        return this.packMargin;
    }

    public void setDefaultPackMargin(int margin) {
        this.packMargin = margin;
    }
}

