/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.common.progressbar;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JPanel;
import javax.swing.UIManager;
import phex.download.DownloadScope;
import phex.download.DownloadScopeList;
import phex.gui.common.PhexColors;
import phex.gui.common.progressbar.MultiScopeProvider;

public class MultiScopeProgressBar
extends JPanel {
    private MultiScopeProvider provider;
    private static Rectangle viewRect = new Rectangle();
    private boolean isPreferredSizeSet = false;
    private boolean isMaximumSizeSet = false;
    private boolean isMinimumSizeSet = false;

    public MultiScopeProgressBar() {
        this.setBackground(PhexColors.getScopeProgressBarBackground());
        this.setForeground(PhexColors.getScopeProgressBarForeground());
        this.setBorder(UIManager.getBorder("ProgressBar.border"));
    }

    public void setProvider(MultiScopeProvider provider) {
        this.provider = provider;
        this.repaint();
    }

    protected void paintComponent(Graphics g) {
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        Insets i = this.getInsets();
        MultiScopeProgressBar.viewRect.x = i.left;
        MultiScopeProgressBar.viewRect.y = i.top;
        MultiScopeProgressBar.viewRect.width = this.getWidth() - (i.right + MultiScopeProgressBar.viewRect.x);
        MultiScopeProgressBar.viewRect.height = this.getHeight() - (i.bottom + MultiScopeProgressBar.viewRect.y);
        Graphics2D g2 = (Graphics2D)g;
        if (this.provider != null) {
            int count = this.provider.getScopeCount();
            for (int j = 0; j < count; ++j) {
                this.paintScopeList(this.provider.getScopeAt(j), this.provider.getScopeColor(j), g2);
            }
        }
    }

    private void paintScopeList(DownloadScopeList scopeList, Color baseColor, Graphics2D g2) {
        double valPerPixel = (double)(this.provider.getFileSize() - 1L) / (double)MultiScopeProgressBar.viewRect.width;
        int scopeCount = scopeList.size();
        for (int i = 0; i < scopeCount; ++i) {
            Color useColor;
            DownloadScope scope;
            try {
                scope = scopeList.getScopeAt(i);
                if (scope == null) {
                }
            }
            catch (IndexOutOfBoundsException exp) {}
            break;
            double startPx = (double)scope.getStart() / valPerPixel;
            double endPx = (double)scope.getEnd() / valPerPixel;
            double width = endPx - startPx;
            int alpha = (int)Math.min(245.0 * width, 245.0) + 10;
            if (alpha < 255) {
                alpha = Math.max(0, alpha);
                useColor = new Color(baseColor.getRed(), baseColor.getGreen(), baseColor.getBlue(), alpha);
            } else {
                useColor = baseColor;
            }
            g2.setColor(useColor);
            int rectWidth = (int)Math.max(width, 1.0);
            g2.fillRect(MultiScopeProgressBar.viewRect.x + (int)startPx, MultiScopeProgressBar.viewRect.y, rectWidth, MultiScopeProgressBar.viewRect.height);
        }
    }

    public Dimension getPreferredSize() {
        if (this.isPreferredSizeSet()) {
            return super.getPreferredSize();
        }
        return this.computePreferredSize();
    }

    public Dimension getMaximumSize() {
        if (this.isMaximumSizeSet()) {
            return super.getMaximumSize();
        }
        return this.computeMaximumSize();
    }

    public Dimension getMinimumSize() {
        if (this.isMinimumSizeSet()) {
            return super.getMinimumSize();
        }
        return this.computeMinimumSize();
    }

    public boolean isPreferredSizeSet() {
        return this.isPreferredSizeSet;
    }

    public void setPreferredSize(Dimension sz) {
        this.isPreferredSizeSet = sz != null;
        super.setPreferredSize(sz);
    }

    public boolean isMaximumSizeSet() {
        return this.isMaximumSizeSet;
    }

    public void setMaximumSize(Dimension sz) {
        this.isMaximumSizeSet = sz != null;
        super.setMaximumSize(sz);
    }

    public boolean isMinimumSizeSet() {
        return this.isMinimumSizeSet;
    }

    public void setMinimumSize(Dimension sz) {
        this.isMinimumSizeSet = sz != null;
        super.setMinimumSize(sz);
    }

    protected Dimension computePreferredSize() {
        Dimension dim = super.getPreferredSize();
        dim.height = 25;
        return dim;
    }

    protected Dimension computeMaximumSize() {
        return this.computePreferredSize();
    }

    protected Dimension computeMinimumSize() {
        return this.computePreferredSize();
    }
}

