/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.common;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.ImageIcon;
import javax.swing.JWindow;
import phex.gui.common.GUIUtils;

public class SplashWindow
extends JWindow
implements MouseListener {
    public static final String SPLASH_IMAGE_NAME = "/phex/resources/splash.png";
    private Image image;

    public SplashWindow() {
        ImageIcon icon = new ImageIcon(SplashWindow.class.getResource(SPLASH_IMAGE_NAME));
        this.image = icon.getImage();
        this.setSize(this.image.getWidth(null) + 4, this.image.getHeight(null) + 4);
        GUIUtils.centerWindowOnScreen(this);
        this.addMouseListener(this);
    }

    public void showSplash() {
        this.setVisible(true);
        this.repaint();
        this.toFront();
    }

    private void hideSplash() {
        this.setVisible(false);
    }

    public void paint(Graphics g) {
        g.drawImage(this.image, 2, 2, null);
        g.setColor(Color.white);
        g.drawLine(0, 0, 0, this.image.getHeight(null) + 3);
        g.drawLine(0, 0, this.image.getWidth(null) + 3, 0);
        g.setColor(Color.lightGray);
        g.drawLine(1, 1, 1, this.image.getHeight(null) + 2);
        g.drawLine(1, 1, this.image.getWidth(null) + 2, 1);
        g.setColor(Color.black);
        g.drawLine(0, this.image.getHeight(null) + 3, this.image.getWidth(null) + 3, this.image.getHeight(null) + 3);
        g.drawLine(this.image.getWidth(null) + 3, 0, this.image.getWidth(null) + 3, this.image.getHeight(null) + 3);
        g.setColor(Color.darkGray);
        g.drawLine(1, this.image.getHeight(null) + 2, this.image.getWidth(null) + 2, this.image.getHeight(null) + 2);
        g.drawLine(this.image.getWidth(null) + 2, 1, this.image.getWidth(null) + 2, this.image.getHeight(null) + 2);
    }

    public void mouseClicked(MouseEvent e) {
        this.hideSplash();
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }
}

