/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.common;

import java.awt.Color;
import javax.swing.UIManager;
import org.apache.commons.lang.SystemUtils;
import phex.gui.common.GUIUtils;

public class PhexColors {
    public static final Color[] NETWORK_HOST_CONNECTING_COLORS = new Color[]{new Color(127, 0, 0), new Color(255, 212, 212)};
    public static final Color[] NETWORK_HOST_CONNECTED_COLORS = new Color[]{new Color(0, 127, 0), new Color(181, 255, 181)};
    private static Color boxPanelBorderColor;
    private static Color boxPanelBackground;
    private static Color boxHeaderBackground;
    private static Color boxHeaderGradientFrom;
    private static Color boxHeaderGradientTo;
    private static Color linkLabelRolloverForeground;
    private static Color scopeProgressBarBackground;
    private static Color scopeProgressBarForeground;
    private static Color finishedScopeProgressBarForeground;
    private static Color unverifiedScopeProgressBarForeground;
    private static Color blockedScopeProgressBarForeground;

    public static Color getBoxPanelBorderColor() {
        return boxPanelBorderColor;
    }

    public static Color getBoxPanelBackground() {
        return boxPanelBackground;
    }

    public static Color getBoxHeaderBackground() {
        return boxHeaderBackground;
    }

    public static Color getBoxHeaderGradientFrom() {
        return boxHeaderGradientFrom;
    }

    public static Color getBoxHeaderGradientTo() {
        return boxHeaderGradientTo;
    }

    public static Color getElegantHeaderGradientFrom() {
        return boxHeaderGradientFrom;
    }

    public static Color getElegantHeaderGradientTo() {
        return boxHeaderGradientTo;
    }

    public static Color getLinkLabelRolloverForeground() {
        return linkLabelRolloverForeground;
    }

    public static Color getScopeProgressBarBackground() {
        return scopeProgressBarBackground;
    }

    public static Color getScopeProgressBarForeground() {
        return scopeProgressBarForeground;
    }

    public static Color getFinishedScopeProgressBarForeground() {
        return finishedScopeProgressBarForeground;
    }

    public static Color getUnverifiedScopeProgressBarForeground() {
        return unverifiedScopeProgressBarForeground;
    }

    public static Color getBlockedScopeProgressBarForeground() {
        return blockedScopeProgressBarForeground;
    }

    public static void updateColors() {
        Color activeCaptionBorderColor = UIManager.getColor("activeCaptionBorder");
        Color infoColor = UIManager.getColor("info");
        if ((SystemUtils.IS_OS_MAC_OSX || SystemUtils.IS_OS_WINDOWS) && UIManager.getLookAndFeel().isNativeLookAndFeel()) {
            PhexColors.activatePhexColors();
        } else if (infoColor == null || activeCaptionBorderColor == null) {
            PhexColors.activatePhexColors();
        } else {
            boxPanelBorderColor = GUIUtils.darkerColor(activeCaptionBorderColor, 0.8);
            boxPanelBackground = new Color(infoColor.getRGB());
            boxHeaderBackground = GUIUtils.darkerColor(activeCaptionBorderColor, 0.9);
            boxHeaderGradientFrom = new Color(activeCaptionBorderColor.getRGB());
            boxHeaderGradientTo = GUIUtils.brighterColor(infoColor, 0.8);
            linkLabelRolloverForeground = GUIUtils.darkerColor(activeCaptionBorderColor, 0.8);
            scopeProgressBarBackground = UIManager.getColor("window");
            finishedScopeProgressBarForeground = scopeProgressBarForeground = UIManager.getColor("ProgressBar.foreground");
            unverifiedScopeProgressBarForeground = new Color(15746646);
            blockedScopeProgressBarForeground = GUIUtils.brighterColor(infoColor, 0.7);
        }
    }

    private static void activatePhexColors() {
        boxPanelBorderColor = new Color(14510336);
        boxPanelBackground = new Color(16764827);
        boxHeaderBackground = new Color(16745472);
        boxHeaderGradientFrom = new Color(16756034);
        boxHeaderGradientTo = new Color(16767401);
        linkLabelRolloverForeground = new Color(15492096);
        scopeProgressBarBackground = Color.WHITE;
        finishedScopeProgressBarForeground = scopeProgressBarForeground = new Color(16754245);
        unverifiedScopeProgressBarForeground = new Color(16729136);
        blockedScopeProgressBarForeground = new Color(0xFF998F);
    }
}

