/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.common;

import java.awt.HeadlessException;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.TimerTask;
import javax.swing.JOptionPane;
import javax.swing.LookAndFeel;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import org.apache.commons.lang.SystemUtils;
import phex.common.Environment;
import phex.common.PhexVersion;
import phex.common.file.FileManager;
import phex.common.file.ManagedFile;
import phex.common.file.ManagedFileException;
import phex.common.log.NLogger;
import phex.gui.actions.ConnectNetworkAction;
import phex.gui.actions.DisconnectNetworkAction;
import phex.gui.actions.ExitPhexAction;
import phex.gui.actions.FWAction;
import phex.gui.actions.NewDownloadAction;
import phex.gui.actions.SwitchNetworkAction;
import phex.gui.chat.ChatFrameManager;
import phex.gui.common.CountryFlagIconPack;
import phex.gui.common.DesktopIndicator;
import phex.gui.common.GUIRegistryConstants;
import phex.gui.common.GUIUpdateNotificationListener;
import phex.gui.common.GUIUserMessageListener;
import phex.gui.common.GUIUtils;
import phex.gui.common.GlobalGuiEventListeners;
import phex.gui.common.GuiUpdateTimer;
import phex.gui.common.IconPack;
import phex.gui.common.LazyEventQueue;
import phex.gui.common.LookAndFeelFailedException;
import phex.gui.common.LookAndFeelUtils;
import phex.gui.common.MainFrame;
import phex.gui.macosx.MacOsxGUIUtils;
import phex.gui.prefs.InterfacePrefs;
import phex.servent.Servent;
import phex.update.UpdateCheckRunner;
import phex.utils.Localizer;
import phex.utils.StringUtils;
import phex.utils.VersionUtils;
import phex.xml.sax.DPhex;
import phex.xml.sax.XMLBuilder;
import phex.xml.sax.gui.DGuiSettings;
import phex.xml.sax.gui.DTableList;

public final class GUIRegistry
implements GUIRegistryConstants {
    private Servent servent;
    private HashMap<String, FWAction> globalActionMap;
    private LazyEventQueue lazyEventQueue;
    private GuiUpdateTimer guiUpdateTimer;
    private DesktopIndicator desktopIndicator;
    private IconPack systemIconPack;
    private IconPack plafIconPack;
    private IconPack countryIconPack;
    private GlobalGuiEventListeners globalEventListeners;
    private ChatFrameManager chatFrameManager;
    private MainFrame mainFrame;
    private boolean showTableHorizontalLines;
    private boolean showTableVerticalLines;
    private boolean useLogBandwidthSlider;
    private boolean showRespectCopyrightNotice;

    private GUIRegistry() {
    }

    public static GUIRegistry getInstance() {
        return Holder.instance;
    }

    public void initialize(Servent serv) {
        this.servent = serv;
        DGuiSettings guiSettings = this.loadGUISettings();
        this.initializeGUISettings(guiSettings);
        this.systemIconPack = new IconPack("phex.gui.resources.icons.system.Icons");
        this.countryIconPack = new CountryFlagIconPack();
        if (SystemUtils.IS_OS_WINDOWS) {
            try {
                this.desktopIndicator = new DesktopIndicator();
            }
            catch (UnsupportedOperationException x) {
                this.desktopIndicator = null;
            }
        }
        if (SystemUtils.IS_OS_MAC_OSX) {
            MacOsxGUIUtils.installEventHandlers();
        }
        this.guiUpdateTimer = new GuiUpdateTimer(InterfacePrefs.GuiUpdateInterval);
        this.initializeGlobalActions();
        this.chatFrameManager = new ChatFrameManager();
        try {
            this.mainFrame = new MainFrame(null, guiSettings);
            NLogger.debug(GUIRegistry.class, "GUIRegistry initialized.");
        }
        catch (HeadlessException ex) {
            // empty catch block
        }
        this.globalEventListeners = new GlobalGuiEventListeners(this.servent.getEventService());
        Environment environment = Environment.getInstance();
        environment.scheduleTimerTask(new TimerTask(){

            public void run() {
                UpdateCheckRunner.triggerAutoBackgroundCheck(new GUIUpdateNotificationListener(), InterfacePrefs.ShowBetaUpdateNotification.get());
            }
        }, 60000L);
        environment.setUserMessageListener(new GUIUserMessageListener());
    }

    public Servent getServent() {
        return this.servent;
    }

    public DesktopIndicator getDesktopIndicator() {
        return this.desktopIndicator;
    }

    public MainFrame getMainFrame() {
        return this.mainFrame;
    }

    public IconPack getPlafIconPack() {
        return this.plafIconPack;
    }

    public void setPlafIconPack(IconPack pack) {
        this.plafIconPack = pack;
    }

    public IconPack getCountryIconPack() {
        return this.countryIconPack;
    }

    public IconPack getSystemIconPack() {
        return this.systemIconPack;
    }

    public LazyEventQueue getLazyEventQueue() {
        if (this.lazyEventQueue == null) {
            this.lazyEventQueue = new LazyEventQueue();
        }
        return this.lazyEventQueue;
    }

    public GuiUpdateTimer getGuiUpdateTimer() {
        return this.guiUpdateTimer;
    }

    public FWAction getGlobalAction(String actionKey) {
        return this.globalActionMap.get(actionKey);
    }

    public String getUsedLAFClass() {
        return UIManager.getLookAndFeel().getClass().getName();
    }

    public boolean getShowTableHorizontalLines() {
        return this.showTableHorizontalLines;
    }

    public void setShowTableHorizontalLines(boolean showHorizontalLines) {
        this.showTableHorizontalLines = showHorizontalLines;
    }

    public boolean getShowTableVerticalLines() {
        return this.showTableVerticalLines;
    }

    public void setShowTableVerticalLines(boolean showVerticalLines) {
        this.showTableVerticalLines = showVerticalLines;
    }

    public boolean useLogBandwidthSlider() {
        return this.useLogBandwidthSlider;
    }

    public void setLogBandwidthSliderUsed(boolean useLogBandwidthSlider) {
        this.useLogBandwidthSlider = useLogBandwidthSlider;
    }

    public boolean isRespectCopyrightNoticeShown() {
        return this.showRespectCopyrightNotice;
    }

    public void setRespectCopyrightNoticeShown(boolean showRespectCopyrightNotice) {
        this.showRespectCopyrightNotice = showRespectCopyrightNotice;
    }

    private synchronized DGuiSettings loadGUISettings() {
        NLogger.debug(GUIRegistry.class, "Loading gui settings file");
        File inputFile = Environment.getInstance().getPhexConfigFile("phexgui.xml");
        try {
            if (!inputFile.exists()) {
                NLogger.debug(GUIRegistry.class, "No gui settings configuration file found.");
                return null;
            }
            FileManager fileMgr = FileManager.getInstance();
            ManagedFile managedFile = fileMgr.getReadWriteManagedFile(inputFile);
            DPhex dPhex = XMLBuilder.loadDPhexFromFile(managedFile);
            if (dPhex == null) {
                NLogger.debug(GUIRegistry.class, "No DPhex found.");
                return null;
            }
            this.updateGUISettings(dPhex);
            return dPhex.getGuiSettings();
        }
        catch (IOException exp) {
            NLogger.error(GUIRegistry.class, exp, exp);
            Environment.getInstance().fireDisplayUserMessage("GuiSettingsLoadFailed", new String[]{exp.toString()});
            return null;
        }
        catch (ManagedFileException exp) {
            NLogger.error(GUIRegistry.class, exp, exp);
            Environment.getInstance().fireDisplayUserMessage("GuiSettingsLoadFailed", new String[]{exp.toString()});
            return null;
        }
    }

    public synchronized void saveGUISettings() {
        NLogger.debug(GUIRegistry.class, "Saving gui settings.");
        try {
            DPhex phex = new DPhex();
            phex.setPhexVersion(PhexVersion.getFullVersion());
            DGuiSettings dSettings = new DGuiSettings();
            dSettings.setLogBandwidthSliderUsed(this.useLogBandwidthSlider);
            dSettings.setShowRespectCopyrightNotice(this.showRespectCopyrightNotice);
            phex.setGuiSettings(dSettings);
            DTableList dTableList = new DTableList();
            dTableList.setShowHorizontalLines(this.showTableHorizontalLines);
            dTableList.setShowVerticalLines(this.showTableVerticalLines);
            dSettings.setTableList(dTableList);
            dSettings.setLookAndFeelClass(this.getUsedLAFClass());
            dSettings.setIconPackName(this.plafIconPack.getName());
            if (this.mainFrame != null) {
                this.mainFrame.saveGUISettings(dSettings);
            }
            File outputFile = Environment.getInstance().getPhexConfigFile("phexgui.xml");
            ManagedFile managedFile = FileManager.getInstance().getReadWriteManagedFile(outputFile);
            XMLBuilder.saveToFile(managedFile, phex);
        }
        catch (IOException exp) {
            NLogger.error(GUIRegistry.class, exp, exp);
            Environment.getInstance().fireDisplayUserMessage("GuiSettingsSaveFailed", new String[]{exp.toString()});
        }
        catch (ManagedFileException exp) {
            NLogger.error(GUIRegistry.class, exp, exp);
            Environment.getInstance().fireDisplayUserMessage("GuiSettingsSaveFailed", new String[]{exp.toString()});
        }
    }

    private void initializeGlobalActions() {
        this.globalActionMap = new HashMap(2);
        FWAction action = new ExitPhexAction();
        this.globalActionMap.put("ExitPhexAction", action);
        action = new NewDownloadAction();
        this.globalActionMap.put("NewDownloadAction", action);
        action = new ConnectNetworkAction();
        this.globalActionMap.put("ConnectNetworkAction", action);
        action = new DisconnectNetworkAction();
        this.globalActionMap.put("DisconnectNetworkAction", action);
        action = new SwitchNetworkAction();
        this.globalActionMap.put("SwitchNetworkAction", action);
    }

    private void initializeGUISettings(DGuiSettings guiSettings) {
        block16: {
            String userLafClass;
            String iconPackName;
            if (SystemUtils.IS_OS_MAC_OSX || SystemUtils.IS_OS_WINDOWS) {
                this.showTableHorizontalLines = false;
                this.showTableVerticalLines = false;
            } else {
                this.showTableHorizontalLines = true;
                this.showTableVerticalLines = true;
            }
            this.useLogBandwidthSlider = false;
            this.showRespectCopyrightNotice = true;
            ToolTipManager.sharedInstance().setEnabled(InterfacePrefs.DisplayTooltip.get());
            if (guiSettings != null) {
                DTableList tableList;
                if (guiSettings.isSetLogBandwidthSliderUsed()) {
                    this.useLogBandwidthSlider = guiSettings.isLogBandwidthSliderUsed();
                }
                if (guiSettings.isSetShowRespectCopyrightNotice()) {
                    this.showRespectCopyrightNotice = guiSettings.isShowRespectCopyrightNotice();
                }
                if ((tableList = guiSettings.getTableList()) != null && tableList.isSetShowHorizontalLines()) {
                    this.showTableHorizontalLines = tableList.isShowHorizontalLines();
                }
                if (tableList != null && tableList.isSetShowVerticalLines()) {
                    this.showTableVerticalLines = tableList.isShowVerticalLines();
                }
                iconPackName = guiSettings.getIconPackName();
                userLafClass = guiSettings.getLookAndFeelClass();
            } else {
                userLafClass = null;
                iconPackName = null;
            }
            if (iconPackName != null) {
                this.plafIconPack = IconPack.createIconPack(iconPackName);
            }
            if (this.plafIconPack == null) {
                this.plafIconPack = IconPack.createDefaultIconPack();
            }
            LookAndFeel laf = LookAndFeelUtils.determineLAF(userLafClass);
            String phexLafClass = laf.getClass().getName();
            if (userLafClass != null && !phexLafClass.equals(userLafClass)) {
                JOptionPane.showMessageDialog(GUIRegistry.getInstance().getMainFrame(), Localizer.getString("LAF_ErrorLoadingSwitchToDefault"), Localizer.getString("Error"), 0);
            }
            if (phexLafClass.equals(UIManager.getLookAndFeel().getClass().getName())) {
                GUIUtils.updateComponentsUI();
            } else {
                try {
                    LookAndFeelUtils.setLookAndFeel(laf);
                }
                catch (ExceptionInInitializerError ex) {
                }
                catch (LookAndFeelFailedException e) {
                    if ($assertionsDisabled) break block16;
                    throw new AssertionError();
                }
            }
        }
    }

    private void updateGUISettings(DPhex dPhex) {
        if (dPhex == null) {
            return;
        }
        String version = dPhex.getPhexVersion();
        if (VersionUtils.compare(PhexVersion.getFullVersion(), version) != 0) {
            this.reactivateRespectCopyright(dPhex);
        }
        if (VersionUtils.compare("2.1.6.82", version) > 0) {
            this.updatesForBuild82(dPhex);
        }
    }

    private void updatesForBuild82(DPhex dPhex) {
        DGuiSettings guiSettings = dPhex.getGuiSettings();
        if (guiSettings == null) {
            return;
        }
        String userLafClass = guiSettings.getLookAndFeelClass();
        if (userLafClass == null) {
            return;
        }
        if (userLafClass.startsWith("com.jgoodies.plaf")) {
            userLafClass = StringUtils.replace(userLafClass, "com.jgoodies.plaf.", "com.jgoodies.looks.", 1);
            guiSettings.setLookAndFeelClass(userLafClass);
        }
    }

    private void reactivateRespectCopyright(DPhex dPhex) {
        DGuiSettings guiSettings = dPhex.getGuiSettings();
        if (guiSettings == null) {
            return;
        }
        guiSettings.setShowRespectCopyrightNotice(true);
    }

    private static class Holder {
        protected static final GUIRegistry instance = new GUIRegistry();

        private Holder() {
        }
    }
}

