/*
 * Decompiled with CFR 0.152.
 */
package phex.download.swarming;

import java.io.IOException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import phex.common.Environment;
import phex.common.address.IpAddress;
import phex.common.log.NLogger;
import phex.connection.ConnectionFailedException;
import phex.download.DownloadConnection;
import phex.download.DownloadEngine;
import phex.download.PushHandler;
import phex.download.swarming.SWDownloadCandidate;
import phex.download.swarming.SWDownloadFile;
import phex.download.swarming.SWDownloadSet;
import phex.download.swarming.SwarmingManager;
import phex.net.repres.SocketFacade;
import phex.prefs.core.NetworkPrefs;

public class SWDownloadWorker
implements Runnable {
    private volatile boolean isTemporaryWorker;
    private volatile boolean isRunning;
    private volatile DownloadEngine downloadEngine;
    private volatile boolean insideCriticalSection;
    private volatile boolean isDownloadStopped;
    private volatile Thread workerThread;
    private Object workerThreadLock = new Object();
    private final SwarmingManager downloadService;

    public SWDownloadWorker(SwarmingManager downloadService) {
        this.downloadService = downloadService;
    }

    public void setTemporaryWorker(boolean state) {
        this.isTemporaryWorker = state;
    }

    public boolean isTemporaryWorker() {
        return this.isTemporaryWorker;
    }

    public boolean isInsideCriticalSection() {
        return this.insideCriticalSection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Object object = this.workerThreadLock;
        synchronized (object) {
            this.workerThread = Thread.currentThread();
        }
        try {
            this.innerRun();
        }
        finally {
            object = this.workerThreadLock;
            synchronized (object) {
                this.workerThread = null;
                this.workerThreadLock.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void innerRun() {
        try {
            boolean isStopped;
            while (this.isRunning && !(isStopped = this.downloadService.checkToStopWorker(this))) {
                this.isDownloadStopped = false;
                NLogger.debug(SWDownloadWorker.class, " - Allocating DownloadSet - " + this);
                SWDownloadSet downloadSet = this.downloadService.allocateDownloadSet(this);
                if (downloadSet == null) {
                    if (!this.isTemporaryWorker) break;
                    try {
                        this.downloadService.waitForNotify();
                        continue;
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        break;
                    }
                }
                NLogger.debug(SWDownloadWorker.class, "Allocated DownloadSet: " + downloadSet.toString() + " - " + this);
                try {
                    this.handleDownload(downloadSet);
                }
                finally {
                    NLogger.debug(SWDownloadWorker.class, "Releasing DownloadSet: " + downloadSet.toString() + " - " + this);
                    downloadSet.releaseDownloadSet();
                }
            }
            this.downloadService.notifyWorkerShoutdown(this, !this.isRunning);
        }
        catch (Throwable throwable) {
            this.downloadService.notifyWorkerShoutdown(this, !this.isRunning);
            NLogger.debug(SWDownloadWorker.class, "Download worker finished: " + this);
            throw throwable;
        }
        NLogger.debug(SWDownloadWorker.class, "Download worker finished: " + this);
    }

    public void startWorker() {
        this.isRunning = true;
        Environment.getInstance().executeOnThreadPool(this, "SWDownloadWorker-" + Integer.toHexString(this.hashCode()));
        NLogger.debug(SWDownloadWorker.class, "Started SWDownloadWorker " + this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopWorker() {
        NLogger.debug(SWDownloadWorker.class, "Download worker has been instructed to stop running: " + this);
        this.isRunning = false;
        this.isDownloadStopped = true;
        if (this.downloadEngine != null) {
            this.downloadEngine.abortDownload();
            this.downloadEngine = null;
        }
        Object object = this.workerThreadLock;
        synchronized (object) {
            if (this.workerThread != null) {
                this.workerThread.interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitTillFinished() {
        Object object = this.workerThreadLock;
        synchronized (object) {
            try {
                while (this.workerThread != null) {
                    this.workerThreadLock.wait(5000L);
                }
            }
            catch (InterruptedException e) {
                NLogger.error(SWDownloadWorker.class, e, e);
                Thread.currentThread().interrupt();
            }
        }
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDownload(SWDownloadSet downloadSet) {
        NLogger.debug(SWDownloadWorker.class, "handleDownload() with: " + downloadSet + " - " + this);
        SWDownloadFile downloadFile = downloadSet.getDownloadFile();
        SWDownloadCandidate downloadCandidate = downloadSet.getCandidate();
        if (!this.isRunning || this.isDownloadStopped) {
            return;
        }
        if (downloadCandidate.isPushNeeded()) {
            this.connectDownloadEngineViaPush(downloadSet, false);
        } else {
            this.connectDownloadEngine(downloadSet);
        }
        if (this.downloadEngine == null) {
            return;
        }
        if (!this.isRunning || this.isDownloadStopped) {
            return;
        }
        try {
            this.insideCriticalSection = true;
            this.startDownload(downloadSet);
        }
        finally {
            downloadFile.removeQueuedCandidate(downloadCandidate);
            this.downloadEngine = null;
            NLogger.debug(SWDownloadWorker.class, "Releasing DownloadSegment: " + downloadSet.toString() + " - " + this);
            downloadSet.releaseDownloadSegment();
            downloadFile.verifyStatus();
            this.insideCriticalSection = false;
        }
    }

    private void connectDownloadEngine(SWDownloadSet downloadSet) {
        if (!this.isRunning || this.isDownloadStopped) {
            return;
        }
        NLogger.debug(SWDownloadWorker.class, "connectDownloadEngine with: " + downloadSet + " - " + this);
        SWDownloadCandidate downloadCandidate = downloadSet.getCandidate();
        this.downloadEngine = null;
        try {
            DownloadConnection connection = new DownloadConnection(downloadCandidate);
            connection.connect(NetworkPrefs.TcpConnectTimeout.get());
            if (!this.isRunning || this.isDownloadStopped) {
                return;
            }
            this.downloadEngine = new DownloadEngine(downloadSet);
            this.downloadEngine.setConnection(connection);
        }
        catch (ConnectionFailedException exp) {
            downloadCandidate.addToCandidateLog(exp.toString());
            NLogger.debug(SWDownloadWorker.class, exp.toString());
            this.connectDownloadEngineViaPush(downloadSet, true);
            return;
        }
        catch (SocketTimeoutException exp) {
            downloadCandidate.addToCandidateLog(exp.toString());
            NLogger.debug(SWDownloadWorker.class, exp.toString());
            this.connectDownloadEngineViaPush(downloadSet, true);
            return;
        }
        catch (UnknownHostException exp) {
            downloadCandidate.addToCandidateLog(exp.toString());
            NLogger.debug(SWDownloadWorker.class, exp.toString());
            this.connectDownloadEngineViaPush(downloadSet, true);
            return;
        }
        catch (IOException exp) {
            downloadCandidate.addToCandidateLog(exp.toString());
            NLogger.error(SWDownloadWorker.class, "HardError at Host: " + downloadCandidate.getHostAddress() + " Vendor: " + downloadCandidate.getVendor(), exp);
            assert (this.downloadEngine == null) : "Download Engine is initialized. If this can possible happen we need to stop it.";
            this.connectDownloadEngineViaPush(downloadSet, true);
            return;
        }
    }

    private void connectDownloadEngineViaPush(SWDownloadSet downloadSet, boolean failedBefore) {
        boolean isLANReachable;
        if (!this.isRunning || this.isDownloadStopped) {
            return;
        }
        NLogger.debug(SWDownloadWorker.class, "connectDownloadEngineViaPush with: " + downloadSet + " - " + this);
        SWDownloadCandidate downloadCandidate = downloadSet.getCandidate();
        SWDownloadFile downloadFile = downloadSet.getDownloadFile();
        this.downloadEngine = null;
        IpAddress ipAddress = downloadCandidate.getHostAddress().getIpAddress();
        boolean bl = isLANReachable = NetworkPrefs.ConnectedToLAN.get() != false && ipAddress != null && ipAddress.isSiteLocalIP();
        if (downloadCandidate.getStatus() == SWDownloadCandidate.CandidateStatus.CONNECTION_FAILED) {
            downloadCandidate.setStatus(SWDownloadCandidate.CandidateStatus.CONNECTING, -1, "Forced status switch.");
        }
        if (downloadSet.getServent().isFirewalled() && !isLANReachable) {
            NLogger.debug(SWDownloadWorker.class, this.toString() + downloadCandidate.toString() + " Cant PUSH -> I'm firewalled and candidate not reachable by LAN");
            downloadCandidate.addToCandidateLog("Cant PUSH -> I'm firewalled and candidate not reachable by LAN");
            downloadCandidate.setStatus(SWDownloadCandidate.CandidateStatus.CONNECTION_FAILED);
            if (downloadCandidate.isPushNeeded()) {
                downloadFile.markCandidateBad(downloadCandidate);
            }
            return;
        }
        if (downloadCandidate.getGUID() == null) {
            NLogger.debug(SWDownloadWorker.class, this.toString() + downloadCandidate.toString() + " Cant PUSH -> No candidate GUID.");
            downloadCandidate.addToCandidateLog("Cant PUSH -> No candidate GUID.");
            downloadCandidate.setStatus(SWDownloadCandidate.CandidateStatus.CONNECTION_FAILED);
            return;
        }
        if (!this.isRunning || this.isDownloadStopped) {
            if (failedBefore) {
                downloadCandidate.setStatus(SWDownloadCandidate.CandidateStatus.CONNECTION_FAILED);
            }
            return;
        }
        downloadCandidate.setStatus(SWDownloadCandidate.CandidateStatus.PUSH_REQUEST);
        SocketFacade socket = PushHandler.requestSocketViaPush(downloadSet.getServent(), downloadCandidate);
        if (socket == null) {
            downloadCandidate.setStatus(SWDownloadCandidate.CandidateStatus.CONNECTION_FAILED);
            if (downloadCandidate.isPushNeeded()) {
                downloadFile.markCandidateIgnored(downloadCandidate, "CandidateStatusReason_PushRouteFailed");
            }
            NLogger.debug(SWDownloadWorker.class, "Push request fails for candidate: " + downloadCandidate);
            downloadCandidate.addToCandidateLog("Push request fails for candidate: " + downloadCandidate);
            return;
        }
        if (!this.isRunning || this.isDownloadStopped) {
            return;
        }
        DownloadConnection connection = new DownloadConnection(downloadCandidate, socket);
        this.downloadEngine = new DownloadEngine(downloadSet);
        this.downloadEngine.setConnection(connection);
    }

    private void startDownload(SWDownloadSet downloadSet) {
        NLogger.debug(SWDownloadWorker.class, "startDownload with: " + downloadSet + " - " + this);
        SWDownloadFile downloadFile = downloadSet.getDownloadFile();
        SWDownloadCandidate downloadCandidate = downloadSet.getCandidate();
        downloadCandidate.addToCandidateLog("Start download.");
        downloadFile.addGoodAltLoc(downloadCandidate);
        downloadFile.markCandidateGood(downloadCandidate);
        this.downloadEngine.runEngine();
    }

    public String toString() {
        return "[SWDownloadWorker@" + Integer.toHexString(this.hashCode()) + ":running:" + this.isRunning + ",tempWorker:" + this.isTemporaryWorker + ",engine:" + this.downloadEngine + "]";
    }
}

