/*
 * Decompiled with CFR 0.152.
 */
package phex.download;

import phex.common.URN;
import phex.common.address.DestAddress;
import phex.msg.GUID;
import phex.query.QueryHitHost;

public class RemoteFile {
    private QueryHitHost qhHost;
    private int fileIndex;
    private String filename;
    private String pathInfo;
    private String displayName;
    private String fileExtension = null;
    private Long fileSize;
    private URN urn;
    private String metaData;
    private boolean isInDownloadQueue;
    private boolean filteredHidden;
    private boolean filteredRemoved;
    private short score;
    private float bitzRating = Float.NaN;

    public RemoteFile(QueryHitHost aQhHost, int fileIndex, String fileName, String pathInfo, long fileSize, URN aUrn, String aMetaData, short aScore) {
        this.qhHost = aQhHost;
        this.fileIndex = fileIndex;
        this.filename = fileName;
        this.pathInfo = pathInfo;
        this.fileSize = fileSize;
        this.urn = aUrn;
        this.metaData = aMetaData;
        this.isInDownloadQueue = false;
        this.score = aScore;
        this.buildDisplayName();
    }

    public RemoteFile(RemoteFile b) {
        this.copy(b);
    }

    public void copy(RemoteFile b) {
        this.qhHost = b.qhHost;
        this.fileIndex = b.fileIndex;
        this.urn = b.urn;
        this.filename = b.filename;
        this.fileSize = b.fileSize;
        this.isInDownloadQueue = b.isInDownloadQueue;
        this.score = b.score;
        this.pathInfo = b.pathInfo;
        this.displayName = b.displayName;
    }

    public GUID getRemoteClientID() {
        return this.qhHost.getHostGUID();
    }

    public int getFileIndex() {
        return this.fileIndex;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getPathInfo() {
        return this.pathInfo;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getFileExt() {
        if (this.fileExtension != null) {
            return this.fileExtension;
        }
        int index = this.filename.lastIndexOf(".");
        this.fileExtension = index > -1 ? this.filename.substring(index + 1, this.filename.length()) : "";
        return this.fileExtension;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public Long getFileSizeObject() {
        return this.fileSize;
    }

    public QueryHitHost getQueryHitHost() {
        return this.qhHost;
    }

    public void setQueryHitHost(QueryHitHost qhHost) {
        this.qhHost = qhHost;
    }

    public void updateQueryHitHost(QueryHitHost host) {
        if (this.qhHost.getHostGUID() == null) {
            this.qhHost.setHostGUID(host.getHostGUID());
        }
        if (this.qhHost.getHostSpeed() == -1) {
            this.qhHost.setHostSpeed(host.getHostSpeed());
        }
    }

    public DestAddress getHostAddress() {
        return this.qhHost.getHostAddress();
    }

    public String getMetaData() {
        return this.metaData;
    }

    public void setMetaData(String data) {
        this.metaData = data;
    }

    public URN getURN() {
        return this.urn;
    }

    public String getSHA1() {
        if (this.urn == null || !this.urn.isSha1Nid()) {
            return "";
        }
        return this.urn.getNamespaceSpecificString();
    }

    public int getSpeed() {
        return this.qhHost.getHostSpeed();
    }

    public String getFormattedSpeed() {
        return this.qhHost.getFormattedHostSpeed();
    }

    public boolean isInDownloadQueue() {
        return this.isInDownloadQueue;
    }

    public void setInDownloadQueue(boolean inDownloadQueue) {
        this.isInDownloadQueue = inDownloadQueue;
    }

    public void clearFilterFlags() {
        this.filteredHidden = false;
        this.filteredRemoved = false;
    }

    public boolean isFilteredHidden() {
        return this.filteredHidden;
    }

    public void setFilteredHidden(boolean filteredHidden) {
        this.filteredHidden = filteredHidden;
    }

    public boolean isFilteredRemoved() {
        return this.filteredRemoved;
    }

    public void setFilteredRemoved(boolean filteredRemoved) {
        this.filteredRemoved = filteredRemoved;
    }

    public short getScore() {
        return this.score;
    }

    public float getBitzRating() {
        return this.bitzRating;
    }

    public void setBitzRating(float bitzRating) {
        this.bitzRating = bitzRating;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RemoteFile)) {
            return false;
        }
        RemoteFile b = (RemoteFile)obj;
        return this.qhHost.getHostAddress().equals(b.qhHost.getHostAddress()) && this.fileIndex == b.fileIndex;
    }

    public int hashCode() {
        int h = 0;
        h = 31 * h + ((Object)this.qhHost.getHostAddress()).hashCode();
        h = 127 * h + this.fileIndex;
        return h;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(super.toString());
        buffer.append("  ");
        buffer.append(this.qhHost.getHostAddress());
        buffer.append("  ");
        buffer.append(this.filename);
        buffer.append("  ");
        buffer.append(this.fileIndex);
        return buffer.toString();
    }

    private void buildDisplayName() {
        StringBuffer buffer = new StringBuffer(128);
        if (this.pathInfo != null && this.pathInfo.length() > 0) {
            String displayPath = this.pathInfo.replace('\\', '/');
            buffer.append(displayPath);
            if (!displayPath.endsWith("/")) {
                buffer.append("/");
            }
        }
        String displayFileName = this.filename.replace('\\', '/');
        buffer.append(displayFileName);
        this.displayName = buffer.toString();
    }
}

