/*
 * Decompiled with CFR 0.152.
 */
package phex.download;

import java.util.ArrayList;
import phex.common.address.DestAddress;
import phex.common.log.NLogger;
import phex.download.PushRequestSleeper;
import phex.download.swarming.SWDownloadCandidate;
import phex.msg.GUID;
import phex.net.repres.SocketFacade;
import phex.servent.Servent;
import phex.statistic.SimpleStatisticProvider;

public class PushHandler {
    private static PushHandler singleton = new PushHandler();
    private ArrayList<PushRequestSleeper> pushSleeperList = new ArrayList(5);

    private PushHandler() {
    }

    public static void handleIncommingGIV(SocketFacade aGivenSocket, GUID givenGUID, String givenFileName) {
        singleton.internalHandleIncommingGIV(aGivenSocket, givenGUID, givenFileName);
    }

    public static SocketFacade requestSocketViaPush(Servent servent, SWDownloadCandidate downloadCandidate) {
        if (downloadCandidate.getGUID() == null) {
            return null;
        }
        return singleton.internalRequestSocketViaPush(servent, downloadCandidate.getGUID(), downloadCandidate.getFileIndex(), downloadCandidate.getPushProxyAddresses());
    }

    public static SocketFacade requestSocketViaPush(Servent servent, GUID aClientGUID, long aFileIndex) {
        return singleton.internalRequestSocketViaPush(servent, aClientGUID, aFileIndex, null);
    }

    public static void unregisterPushRequestSleeper(PushRequestSleeper sleeper) {
        singleton.internalUnregisterPushRequestSleeper(sleeper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalHandleIncommingGIV(SocketFacade aGivenSocket, GUID givenGUID, String givenFileName) {
        ArrayList<PushRequestSleeper> sleeperList;
        NLogger.debug(PushHandler.class, "Handle incomming GIV response: " + givenFileName);
        ArrayList<PushRequestSleeper> arrayList = this.pushSleeperList;
        synchronized (arrayList) {
            sleeperList = new ArrayList<PushRequestSleeper>(this.pushSleeperList);
        }
        for (PushRequestSleeper sleeper : sleeperList) {
            boolean succ = sleeper.acceptGIVConnection(aGivenSocket, givenGUID);
            if (!succ) continue;
            NLogger.debug(PushHandler.class, "Accepted GIV response: " + givenFileName);
            return;
        }
        NLogger.debug(PushHandler.class, "No Push request for GIV found: " + givenFileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SocketFacade internalRequestSocketViaPush(Servent servent, GUID aClientGUID, long aFileIndex, DestAddress[] pushProxyAddresses) {
        NLogger.debug(PushHandler.class, "Perform PUSH request...");
        ((SimpleStatisticProvider)servent.getStatisticsService().getStatisticProvider("PushDownloadAttemptsProvider")).increment(1);
        PushRequestSleeper pushSleeper = new PushRequestSleeper(servent, aClientGUID, aFileIndex, pushProxyAddresses);
        ArrayList<PushRequestSleeper> arrayList = this.pushSleeperList;
        synchronized (arrayList) {
            this.pushSleeperList.add(pushSleeper);
        }
        SocketFacade socket = pushSleeper.requestSocketViaPush();
        if (socket == null) {
            NLogger.debug(PushHandler.class, "PUSH request failed.");
            ((SimpleStatisticProvider)servent.getStatisticsService().getStatisticProvider("PushDownloadFailureProvider")).increment(1);
        } else {
            NLogger.debug(PushHandler.class, "PUSH request successful.");
            ((SimpleStatisticProvider)servent.getStatisticsService().getStatisticProvider("PushDownloadSucessProvider")).increment(1);
        }
        return socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalUnregisterPushRequestSleeper(PushRequestSleeper sleeper) {
        ArrayList<PushRequestSleeper> arrayList = this.pushSleeperList;
        synchronized (arrayList) {
            this.pushSleeperList.remove(sleeper);
        }
    }
}

