/*
 * Decompiled with CFR 0.152.
 */
package phex.download;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import phex.download.DownloadScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DownloadScopeList
implements Iterable<DownloadScope>,
Cloneable {
    private static DownloadScopeComparator DOWNLOAD_SCOPE_COMPARATOR = new DownloadScopeComparator();
    private volatile int modificationCount = 0;
    private List<DownloadScope> scopeList = new ArrayList<DownloadScope>();
    private long aggregatedLengthCache = 0L;
    private int aggregatedLengthModCount = 0;

    public void addAll(DownloadScopeList listToAdd) {
        for (DownloadScope scope : listToAdd) {
            this.add(scope);
        }
    }

    public void add(DownloadScope newScope) {
        DownloadScope neighborBefore = null;
        DownloadScope neighborAfter = null;
        Iterator<DownloadScope> iterator = this.scopeList.iterator();
        while (iterator.hasNext()) {
            DownloadScope scope = iterator.next();
            if (newScope.contains(scope)) {
                iterator.remove();
                continue;
            }
            if (scope.contains(newScope)) {
                return;
            }
            if (newScope.isNeighborBefore(scope)) {
                neighborBefore = scope;
            }
            if (newScope.isNeighborAfter(scope)) {
                neighborAfter = scope;
            }
            if (neighborAfter == null && scope.getStart() <= newScope.getEnd()) continue;
            break;
        }
        if (neighborBefore == null && neighborAfter == null) {
            this.addInternal(newScope);
        } else if (neighborBefore != null && neighborAfter != null) {
            this.removeInternal(neighborBefore);
            this.removeInternal(neighborAfter);
            this.addInternal(new DownloadScope(neighborBefore.getStart(), neighborAfter.getEnd()));
        } else if (neighborAfter != null) {
            this.removeInternal(neighborAfter);
            this.addInternal(new DownloadScope(newScope.getStart(), neighborAfter.getEnd()));
        } else if (neighborBefore != null) {
            this.removeInternal(neighborBefore);
            this.addInternal(new DownloadScope(neighborBefore.getStart(), newScope.getEnd()));
        }
    }

    public void removeAll(DownloadScopeList listToRemove) {
        for (DownloadScope scope : listToRemove) {
            this.remove(scope);
        }
    }

    public void remove(DownloadScope removeScope) {
        DownloadScope beforeScope = null;
        DownloadScope afterScope = null;
        Iterator<DownloadScope> iterator = this.scopeList.iterator();
        while (iterator.hasNext()) {
            DownloadScope scope = iterator.next();
            if (scope.isOverlapping(removeScope)) {
                iterator.remove();
                ++this.modificationCount;
                if (removeScope.getEnd() >= scope.getEnd()) {
                    if (removeScope.getStart() <= scope.getStart()) continue;
                    beforeScope = new DownloadScope(scope.getStart(), removeScope.getStart() - 1L);
                    continue;
                }
                if (scope.getStart() >= removeScope.getStart()) {
                    afterScope = new DownloadScope(removeScope.getEnd() + 1L, scope.getEnd());
                    break;
                }
                beforeScope = new DownloadScope(scope.getStart(), removeScope.getStart() - 1L);
                afterScope = new DownloadScope(removeScope.getEnd() + 1L, scope.getEnd());
                break;
            }
            if (scope.getStart() < removeScope.getEnd()) continue;
            break;
        }
        if (beforeScope != null) {
            this.add(beforeScope);
        }
        if (afterScope != null) {
            this.add(afterScope);
        }
    }

    public boolean contains(DownloadScope scope) {
        for (DownloadScope thisScope : this.scopeList) {
            if (!thisScope.contains(scope)) continue;
            return true;
        }
        return false;
    }

    public void retainAll(DownloadScopeList retainList) {
        ListIterator<DownloadScope> thisIterator = this.scopeList.listIterator();
        while (thisIterator.hasNext()) {
            boolean removeThis = true;
            DownloadScope thisScope = thisIterator.next();
            for (DownloadScope retainScope : retainList) {
                if (thisScope.isOverlapping(retainScope)) {
                    thisIterator.remove();
                    long retainStart = Math.max(retainScope.getStart(), thisScope.getStart());
                    long retainEnd = Math.min(retainScope.getEnd(), thisScope.getEnd());
                    thisIterator.add(new DownloadScope(retainStart, retainEnd));
                    removeThis = false;
                    break;
                }
                if (retainScope.getStart() < thisScope.getEnd()) continue;
                break;
            }
            if (!removeThis) continue;
            thisIterator.remove();
        }
    }

    public long getAggregatedLength() {
        if (this.modificationCount == this.aggregatedLengthModCount) {
            return this.aggregatedLengthCache;
        }
        long length = 0L;
        for (DownloadScope scope : this.scopeList) {
            length += scope.getLength();
        }
        this.aggregatedLengthCache = length;
        this.aggregatedLengthModCount = this.modificationCount;
        return length;
    }

    @Override
    public Iterator<DownloadScope> iterator() {
        return this.scopeList.iterator();
    }

    public boolean isEmpty() {
        return this.scopeList.isEmpty();
    }

    public int size() {
        return this.scopeList.size();
    }

    public DownloadScope getScopeAt(int pos) {
        if (pos < 0 || pos >= this.scopeList.size()) {
            return null;
        }
        return this.scopeList.get(pos);
    }

    public void clear() {
        this.scopeList.clear();
        this.aggregatedLengthCache = 0L;
        this.modificationCount = 0;
        this.aggregatedLengthModCount = 0;
    }

    public Object clone() {
        DownloadScopeList copy = new DownloadScopeList();
        copy.scopeList.addAll(this.scopeList);
        return copy;
    }

    protected void addInternal(DownloadScope scope) {
        int index = Collections.binarySearch(this.scopeList, scope, DOWNLOAD_SCOPE_COMPARATOR);
        assert (index < 0);
        this.scopeList.add(-(index + 1), scope);
        ++this.modificationCount;
    }

    protected void removeInternal(DownloadScope scope) {
        int index = Collections.binarySearch(this.scopeList, scope, DOWNLOAD_SCOPE_COMPARATOR);
        assert (index >= 0);
        this.scopeList.remove(index);
        ++this.modificationCount;
    }

    protected List<DownloadScope> getScopeListCopy() {
        return new ArrayList<DownloadScope>(this.scopeList);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DownloadScopeComparator
    implements Comparator<DownloadScope> {
        private DownloadScopeComparator() {
        }

        @Override
        public int compare(DownloadScope scope1, DownloadScope scope2) {
            if (scope1 == scope2 || scope1.equals(scope2)) {
                return 0;
            }
            if (scope1.getStart() > scope2.getStart()) {
                return 1;
            }
            return -1;
        }
    }
}

