/*
 * Decompiled with CFR 0.152.
 */
package phex.download;

public class DownloadScope {
    private long start;
    private long end;

    public DownloadScope(long startOffset, long endOffset) {
        if (endOffset < startOffset) {
            throw new IllegalArgumentException("endOffset < startOffset : " + startOffset + " " + endOffset);
        }
        this.start = startOffset;
        this.end = endOffset;
    }

    public long getEnd() {
        return this.end;
    }

    public long getStart() {
        return this.start;
    }

    public long getLength() {
        return this.end - this.start + 1L;
    }

    public boolean contains(DownloadScope scope) {
        return this.start <= scope.start && this.end >= scope.end;
    }

    public boolean isNeighborBefore(DownloadScope scope) {
        return this.start <= scope.end + 1L && this.start > scope.start;
    }

    public boolean isNeighborAfter(DownloadScope scope) {
        return this.end >= scope.start - 1L && this.end < scope.end;
    }

    public boolean isOverlapping(DownloadScope scope) {
        return this.end >= scope.start && this.start <= scope.end;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 17;
        result = 31 * result + (int)(this.end ^ this.end >>> 32);
        result = 31 * result + (int)(this.start ^ this.start >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DownloadScope other = (DownloadScope)obj;
        if (this.end != other.end) {
            return false;
        }
        return this.start == other.start;
    }

    public String toString() {
        return "[DownloadScope: start:" + this.start + ",end:" + this.end + "@" + Integer.toHexString(this.hashCode()) + "]";
    }
}

