/*
 * Decompiled with CFR 0.152.
 */
package phex.connection.handshake;

import phex.common.address.DestAddress;
import phex.common.address.IpAddress;
import phex.connection.ConnectionConstants;
import phex.connection.handshake.HandshakeStatus;
import phex.connection.handshake.LeafHandshakeHandler;
import phex.connection.handshake.UltrapeerHandshakeHandler;
import phex.host.Host;
import phex.http.HTTPHeader;
import phex.http.HTTPHeaderGroup;
import phex.prefs.core.ConnectionPrefs;
import phex.servent.Servent;

public abstract class HandshakeHandler
implements ConnectionConstants {
    protected final Servent servent;
    protected final Host connectedHost;

    public HandshakeHandler(Servent servent, Host connectedHost) {
        this.servent = servent;
        this.connectedHost = connectedHost;
    }

    protected HTTPHeaderGroup createDefaultHandshakeHeaders() {
        HTTPHeaderGroup openHeaders = new HTTPHeaderGroup(HTTPHeaderGroup.ACCEPT_HANDSHAKE_GROUP);
        DestAddress myAddress = this.servent.getLocalAddress();
        openHeaders.addHeader(new HTTPHeader("Listen-IP", myAddress.getFullHostName()));
        DestAddress remoteAddress = this.connectedHost.getHostAddress();
        IpAddress ipAddress = remoteAddress.getIpAddress();
        openHeaders.addHeader(new HTTPHeader("Remote-IP", ipAddress.getFormatedString()));
        if (ConnectionPrefs.AcceptDeflateConnection.get().booleanValue()) {
            openHeaders.addHeader(new HTTPHeader("Accept-Encoding", "deflate"));
        }
        return openHeaders;
    }

    public HTTPHeaderGroup createOutgoingHandshakeHeaders() {
        HTTPHeaderGroup outHeaders = this.createDefaultHandshakeHeaders();
        return outHeaders;
    }

    protected HandshakeStatus createCrawlerHandshakeStatus() {
        Host[] ultrapeers;
        Host[] leafs;
        HTTPHeaderGroup crawlerHeaders = new HTTPHeaderGroup(HTTPHeaderGroup.COMMON_HANDSHAKE_GROUP);
        boolean isUltrapeer = this.servent.isUltrapeer();
        crawlerHeaders.addHeader(new HTTPHeader("X-Ultrapeer", String.valueOf(isUltrapeer)));
        if (isUltrapeer && (leafs = this.servent.getHostService().getLeafConnections()).length > 0) {
            String leafAddressString = this.buildHostAddressString(leafs, leafs.length);
            crawlerHeaders.addHeader(new HTTPHeader("Leaves", leafAddressString));
        }
        if ((ultrapeers = this.servent.getHostService().getUltrapeerConnections()).length > 0) {
            String ultrapeerAddressString = this.buildHostAddressString(ultrapeers, ultrapeers.length);
            crawlerHeaders.addHeader(new HTTPHeader("Peers", ultrapeerAddressString));
        }
        return new HandshakeStatus(200, "OK", crawlerHeaders);
    }

    protected HTTPHeaderGroup createRejectOutgoingHeaders() {
        HTTPHeaderGroup openHeaders = new HTTPHeaderGroup(HTTPHeaderGroup.COMMON_HANDSHAKE_GROUP);
        return openHeaders;
    }

    protected HTTPHeaderGroup createRejectIncomingHeaders() {
        HTTPHeaderGroup openHeaders = new HTTPHeaderGroup(HTTPHeaderGroup.COMMON_HANDSHAKE_GROUP);
        openHeaders.addHeader(new HTTPHeader("Remote-IP", this.connectedHost.getHostAddress().getHostName()));
        Host[] ultrpeers = this.servent.getHostService().getUltrapeerConnections();
        String ultrapeerAddressString = this.buildHostAddressString(ultrpeers, 10);
        openHeaders.addHeader(new HTTPHeader("X-Try-Ultrapeers", ultrapeerAddressString));
        return openHeaders;
    }

    public abstract HandshakeStatus createHandshakeResponse(HandshakeStatus var1, boolean var2);

    public static HandshakeHandler createHandshakeHandler(Servent servent, Host connectedHost) {
        if (servent.isAbleToBecomeUltrapeer()) {
            return new UltrapeerHandshakeHandler(servent, connectedHost);
        }
        return new LeafHandshakeHandler(servent, connectedHost);
    }

    protected String buildHostAddressString(Host[] hosts, int max) {
        StringBuffer buffer = new StringBuffer();
        max = Math.min(max, hosts.length);
        for (int i = 0; i < max; ++i) {
            DestAddress address = hosts[i].getHostAddress();
            buffer.append(address.getFullHostName());
            if (i >= hosts.length - 1) continue;
            buffer.append(",");
        }
        return buffer.toString();
    }

    protected boolean isCrawlerConnection(HTTPHeaderGroup headers) {
        HTTPHeader crawlerHeader = headers.getHeader("Crawler");
        if (crawlerHeader == null) {
            return false;
        }
        try {
            float crawlerVersion = crawlerHeader.floatValue();
            return crawlerVersion >= 0.1f;
        }
        catch (NumberFormatException exp) {
            return false;
        }
    }
}

