/*
 * Decompiled with CFR 0.152.
 */
package phex.connection;

import java.io.IOException;
import phex.common.Environment;
import phex.common.address.DestAddress;
import phex.common.log.NLogger;
import phex.connection.ConnectionEngine;
import phex.connection.ConnectionRejectedException;
import phex.connection.ConnectionStatusEvent;
import phex.host.CaughtHostsContainer;
import phex.host.Host;
import phex.host.HostManager;
import phex.host.HostStatus;
import phex.host.NetworkHostsContainer;
import phex.net.connection.Connection;
import phex.net.connection.ConnectionFactory;
import phex.servent.Servent;

public class OutgoingConnectionDispatcher
implements Runnable {
    private final Servent servent;
    private final DestAddress hostAddress;

    public static void dispatchConnectToNextHost(Servent servent) {
        OutgoingConnectionDispatcher.dispatchConnectToNextHosts(1, servent);
    }

    public static void dispatchConnectToNextHosts(int count, Servent servent) {
        HostManager hostService = servent.getHostService();
        CaughtHostsContainer caughtHostsContainer = hostService.getCaughtHostsContainer();
        NetworkHostsContainer networkHostsCont = hostService.getNetworkHostsContainer();
        for (int i = 0; i < count; ++i) {
            DestAddress caughtHost;
            do {
                if ((caughtHost = caughtHostsContainer.getNextCaughtHost()) != null) continue;
                return;
            } while (networkHostsCont.isConnectedToHost(caughtHost));
            OutgoingConnectionDispatcher.dispatchConnectToHost(caughtHost, servent);
        }
    }

    public static void dispatchConnectToHost(DestAddress hostAddress, Servent servent) {
        OutgoingConnectionDispatcher dispatcher = new OutgoingConnectionDispatcher(hostAddress, servent);
        Environment.getInstance().executeOnThreadPool(dispatcher, "OutgoingConnectionDispatcher-" + Integer.toHexString(dispatcher.hashCode()));
    }

    private OutgoingConnectionDispatcher(DestAddress hostAddress, Servent servent) {
        this.hostAddress = hostAddress;
        this.servent = servent;
    }

    public void run() {
        try {
            this.connectToHostAddress();
        }
        catch (Throwable th) {
            NLogger.error(OutgoingConnectionDispatcher.class, th, th);
        }
    }

    private void connectToHostAddress() {
        ConnectionEngine engine;
        Connection connection;
        Host host = new Host(this.hostAddress);
        host.setType(Host.Type.OUTGOING);
        host.setStatus(HostStatus.CONNECTING);
        this.servent.getHostService().addNetworkHost(host);
        try {
            connection = ConnectionFactory.createConnection(this.hostAddress, this.servent.getBandwidthService().getNetworkBandwidthController());
        }
        catch (IOException exp) {
            this.reportStatus(ConnectionStatusEvent.Status.CONNECTION_FAILED);
            host.setStatus(HostStatus.ERROR, exp.getMessage());
            host.disconnect();
            NLogger.debug(OutgoingConnectionDispatcher.class, exp);
            return;
        }
        catch (Exception exp) {
            this.reportStatus(ConnectionStatusEvent.Status.CONNECTION_FAILED);
            host.setStatus(HostStatus.ERROR, exp.getMessage());
            host.disconnect();
            NLogger.warn(OutgoingConnectionDispatcher.class, exp, exp);
            return;
        }
        host.setConnection(connection);
        try {
            engine = new ConnectionEngine(this.servent, host);
            engine.initHostHandshake();
        }
        catch (ConnectionRejectedException exp) {
            this.reportStatus(ConnectionStatusEvent.Status.HANDSHAKE_REJECTED);
            host.setStatus(HostStatus.ERROR, exp.getMessage());
            host.disconnect();
            NLogger.debug(OutgoingConnectionDispatcher.class, exp);
            return;
        }
        catch (IOException exp) {
            this.reportStatus(ConnectionStatusEvent.Status.HANDSHAKE_FAILED);
            host.setStatus(HostStatus.ERROR, exp.getMessage());
            host.disconnect();
            NLogger.debug(OutgoingConnectionDispatcher.class, exp);
            return;
        }
        catch (Exception exp) {
            this.reportStatus(ConnectionStatusEvent.Status.HANDSHAKE_FAILED);
            host.setStatus(HostStatus.ERROR, exp.getMessage());
            host.disconnect();
            NLogger.warn(OutgoingConnectionDispatcher.class, exp, exp);
            return;
        }
        this.reportStatus(ConnectionStatusEvent.Status.SUCCESSFUL);
        try {
            engine.processIncomingData();
        }
        catch (IOException exp) {
            if (host.isConnected()) {
                host.setStatus(HostStatus.ERROR, exp.getMessage());
                host.disconnect();
            }
            NLogger.debug(OutgoingConnectionDispatcher.class, exp);
        }
        catch (Exception exp) {
            if (host.isConnected()) {
                host.setStatus(HostStatus.ERROR, exp.getMessage());
                host.disconnect();
            }
            NLogger.warn(OutgoingConnectionDispatcher.class, exp, exp);
        }
    }

    private void reportStatus(ConnectionStatusEvent.Status status) {
        this.servent.getEventService().publish("phex:net/connectionStatus", new ConnectionStatusEvent(this.hostAddress, status));
    }
}

