/*
 * Decompiled with CFR 0.152.
 */
package phex.common.format;

import phex.common.format.DoubleToString;
import phex.utils.Localizer;

public final class NumberFormatUtils {
    public static final DoubleToString doubleToStringFormat = new DoubleToString();
    public static final long ONE_KB = 1024L;
    public static final long ONE_MB = 0x100000L;
    public static final long ONE_GB = 0x40000000L;
    public static final long ONE_TB = 0x10000000000L;

    private NumberFormatUtils() {
    }

    public static String formatDecimal(double value, int precision) {
        if (Double.isNaN(value) || Double.isInfinite(value)) {
            return "\u221e";
        }
        if (precision == 0) {
            return NumberFormatUtils.formatNumber((long)value);
        }
        StringBuffer buf = new StringBuffer();
        doubleToStringFormat.appendFormatted(buf, value, precision, Localizer.getDecimalFormatSymbols().getDecimalSeparator(), Localizer.getDecimalFormatSymbols().getGroupingSeparator(), 3, Localizer.getDecimalFormatSymbols().getMinusSign(), '\uffff');
        return buf.toString();
    }

    public static String formatNumber(long size) {
        return Localizer.getIntegerNumberFormat().format(size);
    }

    public static String formatFullByteSize(long size) {
        return NumberFormatUtils.formatNumber(size) + " " + Localizer.getString("BytesToken");
    }

    public static String formatSignificantByteSize(double size) {
        int precision;
        double divider;
        String text;
        if (size < 10240.0) {
            text = Localizer.getString("BytesToken");
            divider = 1.0;
            precision = 0;
        } else if (size < 1.048576E7) {
            text = Localizer.getString("KBToken");
            divider = 1024.0;
            precision = 1;
        } else if (size < 1.073741824E10) {
            text = Localizer.getString("MBToken");
            divider = 1048576.0;
            precision = 1;
        } else if (size < 1.099511627776E13) {
            text = Localizer.getString("GBToken");
            divider = 1.073741824E9;
            precision = 2;
        } else {
            text = Localizer.getString("TBToken");
            divider = 1.099511627776E12;
            precision = 3;
        }
        double d = size / divider;
        String valStr = NumberFormatUtils.formatDecimal(d, precision);
        return valStr + " " + text;
    }

    public static String formatSignificantByteSize(Number number) {
        return NumberFormatUtils.formatSignificantByteSize(number.doubleValue());
    }
}

