/*
 * Decompiled with CFR 0.152.
 */
package phex.common.address;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import phex.common.address.DestAddress;
import phex.common.address.IpAddress;
import phex.common.address.MalformedDestAddressException;
import phex.common.log.NLogger;
import phex.net.repres.PresentationManager;
import phex.security.AccessType;
import phex.security.IpCidrPair;
import phex.security.PhexSecurityManager;
import phex.utils.IOUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddressUtils {
    public static final int[] CIDR2MASK = new int[]{0, Integer.MIN_VALUE, -1073741824, -536870912, -268435456, -134217728, -67108864, -33554432, -16777216, -8388608, -4194304, -2097152, -1048576, -524288, -262144, -131072, -65536, Short.MIN_VALUE, -16384, -8192, -4096, -2048, -1024, -512, -256, -128, -64, -32, -16, -8, -4, -2, -1};

    private AddressUtils() {
    }

    public static String ip2string(byte[] ip) {
        if (ip == null) {
            throw new NullPointerException("Ip is null!");
        }
        assert (ip.length == 4);
        return (ip[0] & 0xFF) + "." + (ip[1] & 0xFF) + "." + (ip[2] & 0xFF) + "." + (ip[3] & 0xFF);
    }

    public static String ip2string(int ip) {
        return (ip >> 24 & 0xFF) + "." + (ip >> 16 & 0xFF) + "." + (ip >> 8 & 0xFF) + "." + (ip & 0xFF);
    }

    public static boolean isIPHostName(String hostName) {
        int portSeparatorIdx = hostName.indexOf(58);
        if (portSeparatorIdx != -1) {
            hostName = hostName.substring(0, portSeparatorIdx);
        }
        char[] data = hostName.toCharArray();
        int hitDots = 0;
        for (int i = 0; i < data.length; ++i) {
            char c = data[i];
            if (c < '0' || c > '9') {
                return false;
            }
            while (c != '.') {
                if (c < '0' || c > '9') {
                    return false;
                }
                if (++i >= data.length) break;
                c = data[i];
            }
            ++hitDots;
        }
        return hitDots == 4 && !hostName.endsWith(".");
    }

    public static DestAddress parseAndValidateAddress(String addressString, boolean isPrivateIpAllowed, PhexSecurityManager securityService) throws MalformedDestAddressException {
        byte[] ip = AddressUtils.parseIP(addressString);
        if (ip == null) {
            throw new MalformedDestAddressException("Invalid IP: " + addressString);
        }
        int port = AddressUtils.parsePort(addressString);
        if (port == -1) {
            port = 6346;
        } else if (!AddressUtils.isPortInRange(port)) {
            throw new MalformedDestAddressException("Port out of range: " + addressString);
        }
        IpAddress ipAddress = new IpAddress(ip);
        DestAddress hostAddress = PresentationManager.getInstance().createHostAddress(ipAddress, port);
        if (!hostAddress.isValidAddress()) {
            throw new MalformedDestAddressException("Invalid IP: " + addressString);
        }
        if (!isPrivateIpAllowed && hostAddress.isSiteLocalAddress()) {
            throw new MalformedDestAddressException("Private IP: " + addressString);
        }
        AccessType access = securityService.controlHostIPAccess(hostAddress.getIpAddress().getHostIP());
        switch (access) {
            case ACCESS_DENIED: 
            case ACCESS_STRONGLY_DENIED: {
                throw new MalformedDestAddressException("Host access denied: " + addressString);
            }
        }
        return hostAddress;
    }

    public static byte[] parseIntIP(String ip) {
        long IP = Long.parseLong(ip);
        byte[] addr = new byte[]{(byte)(IP >>> 24 & 0xFFL), (byte)(IP >>> 16 & 0xFFL), (byte)(IP >>> 8 & 0xFFL), (byte)(IP & 0xFFL)};
        return addr;
    }

    public static int parseNetmaskToInt(String netmask) {
        if (netmask.indexOf(46) == -1) {
            try {
                int val = Integer.parseInt(netmask);
                if (val == 32) {
                    return -1;
                }
                if (val >= 0) {
                    return ~(-1 >>> val);
                }
                throw new IllegalArgumentException("Invalid netmask: " + netmask);
            }
            catch (NumberFormatException exp) {
                throw new IllegalArgumentException("Invalid netmask: " + netmask);
            }
        }
        return AddressUtils.parseDottedIpToInt(netmask);
    }

    public static byte parseNetmaskToCidr(String netmask) {
        if (netmask.indexOf(46) == -1) {
            try {
                byte val = Byte.parseByte(netmask);
                if (val >= 0) {
                    return val;
                }
                throw new IllegalArgumentException("Invalid netmask: " + netmask);
            }
            catch (NumberFormatException exp) {
                throw new IllegalArgumentException("Invalid netmask: " + netmask);
            }
        }
        return AddressUtils.calculateCidr(AddressUtils.parseDottedIpToInt(netmask));
    }

    public static int parseDottedIpToInt(String hostIp) {
        int portSeparatorIdx = hostIp.indexOf(58);
        String ipToParse = portSeparatorIdx != -1 ? hostIp.substring(0, portSeparatorIdx) : hostIp;
        char[] data = ipToParse.toCharArray();
        int IP = 0;
        int hitDots = 0;
        for (int i = 0; i < data.length; ++i) {
            char c = data[i];
            if (c < '0' || c > '9') {
                throw new IllegalArgumentException("IP contains character: " + ipToParse + " - org: " + hostIp);
            }
            int b = 0;
            while (c != '.') {
                if (c < '0' || c > '9') {
                    throw new IllegalArgumentException("IP contains character: " + ipToParse);
                }
                b = b * 10 + c - 48;
                if (++i >= data.length) break;
                c = data[i];
            }
            if (b > 255) {
                throw new IllegalArgumentException("Bogus ip value: " + ipToParse);
            }
            IP = (IP << 8) + b;
            ++hitDots;
        }
        if (hitDots != 4 || ipToParse.endsWith(".")) {
            throw new IllegalArgumentException("Bogus ip: " + ipToParse);
        }
        return IP;
    }

    public static byte[] parseIP(String hostIp) {
        try {
            int IP = AddressUtils.parseDottedIpToInt(hostIp);
            byte[] addr = new byte[]{(byte)(IP >>> 24 & 0xFF), (byte)(IP >>> 16 & 0xFF), (byte)(IP >>> 8 & 0xFF), (byte)(IP & 0xFF)};
            return addr;
        }
        catch (IllegalArgumentException exp) {
            NLogger.warn(AddressUtils.class, exp);
            return null;
        }
    }

    public static int parsePort(String hostName) {
        int portIdx = hostName.indexOf(58);
        if (portIdx == -1) {
            return -1;
        }
        String portString = hostName.substring(portIdx + 1);
        char[] data = portString.toCharArray();
        int port = 0;
        for (char c : data) {
            if (c < '0' || c > '9') break;
            port = port * 10 + c - 48;
        }
        if (!AddressUtils.isPortInRange(port)) {
            return -1;
        }
        return port;
    }

    public static String toIntValueString(byte[] ip) {
        int v1 = ip[3] & 0xFF;
        int v2 = ip[2] << 8 & 0xFF00;
        int v3 = ip[1] << 16 & 0xFF0000;
        int v4 = ip[0] << 24;
        long ipValue = (long)(v4 | v3 | v2 | v1) & 0xFFFFFFFFL;
        return String.valueOf(ipValue);
    }

    public static int byteIpToIntIp(byte[] ip) {
        int v1 = ip[3] & 0xFF;
        int v2 = ip[2] << 8 & 0xFF00;
        int v3 = ip[1] << 16 & 0xFF0000;
        int v4 = ip[0] << 24;
        int ipValue = (v4 | v3 | v2 | v1) & 0xFFFFFFFF;
        return ipValue;
    }

    public static byte[] intIp2ByteIp(int ip) {
        byte[] addr = new byte[]{(byte)(ip >>> 24 & 0xFF), (byte)(ip >>> 16 & 0xFF), (byte)(ip >>> 8 & 0xFF), (byte)(ip & 0xFF)};
        return addr;
    }

    public static boolean isPortInRange(int port) {
        return (port & 0xFFFF0000) == 0 && port != 0;
    }

    public static byte calculateCidr(int ip) {
        byte b = 0;
        b = (byte)(b + AddressUtils.cidrByteToNBits((byte)(ip >>> 24 & 0xFF)));
        b = (byte)(b + AddressUtils.cidrByteToNBits((byte)(ip >>> 16 & 0xFF)));
        b = (byte)(b + AddressUtils.cidrByteToNBits((byte)(ip >>> 8 & 0xFF)));
        b = (byte)(b + AddressUtils.cidrByteToNBits((byte)(ip & 0xFF)));
        return b;
    }

    private static byte cidrByteToNBits(byte val) {
        switch (val) {
            case -1: {
                return 8;
            }
            case -2: {
                return 7;
            }
            case -4: {
                return 6;
            }
            case -8: {
                return 5;
            }
            case -16: {
                return 4;
            }
            case -32: {
                return 3;
            }
            case -64: {
                return 2;
            }
            case -128: {
                return 1;
            }
            case 0: {
                return 0;
            }
        }
        throw new IllegalArgumentException("Invalid byte value");
    }

    public static byte calculateCidr(byte[] ip) {
        int intIp = AddressUtils.byteIpToIntIp(ip);
        return AddressUtils.calculateCidr(intIp);
    }

    public static List<IpCidrPair> range2cidr(byte[] startIp, byte[] endIp) {
        long start = IOUtil.unsignedInt2Long(AddressUtils.byteIpToIntIp(startIp));
        long end = IOUtil.unsignedInt2Long(AddressUtils.byteIpToIntIp(endIp));
        ArrayList<IpCidrPair> pairs = new ArrayList<IpCidrPair>();
        while (end >= start) {
            long mask;
            long maskedBase;
            byte maxsize;
            for (maxsize = 32; maxsize > 0 && (maskedBase = start & (mask = (long)CIDR2MASK[maxsize - 1])) == start; maxsize = (byte)((byte)(maxsize - 1))) {
            }
            double x = Math.log(end - start + 1L) / Math.log(2.0);
            byte maxdiff = (byte)(32.0 - Math.floor(x));
            if (maxsize < maxdiff) {
                maxsize = maxdiff;
            }
            pairs.add(new IpCidrPair((int)start, maxsize));
            start = (long)((double)start + Math.pow(2.0, 32 - maxsize));
        }
        return pairs;
    }

    public static SocketAddress createSocketAddress(DestAddress address) throws IOException {
        try {
            InetAddress inetAddress;
            if (address.isIpHostName()) {
                IpAddress ip = address.getIpAddress();
                inetAddress = InetAddress.getByAddress(ip.getHostIP());
            } else {
                inetAddress = InetAddress.getByName(address.getHostName());
            }
            int port = address.getPort();
            return new InetSocketAddress(inetAddress, port);
        }
        catch (UnknownHostException exp) {
            throw new IOException("Can't resolve address.");
        }
    }
}

