/*
 * Decompiled with CFR 0.152.
 */
package phex.bootstrap;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import phex.bootstrap.GWebCacheHost;
import phex.common.PhexVersion;
import phex.common.address.DestAddress;
import phex.common.address.MalformedDestAddressException;
import phex.connection.ProtocolNotSupportedException;
import phex.net.repres.PresentationManager;
import phex.prefs.core.ProxyPrefs;
import phex.security.AccessType;
import phex.security.PhexSecurityManager;
import phex.utils.IOUtil;
import phex.utils.NormalizableURL;
import phex.utils.StringUtils;
import phex.utils.URLCodecUtils;

public class GWebCacheConnection {
    private static final String PING_QUERY = "ping=1";
    private static final String HOST_FILE_QUERY = "hostfile=1";
    private static final String URL_FILE_QUERY = "urlfile=1";
    private static final String IP_QUERY = "ip=";
    private static final String URL_QUERY = "url=";
    private static final String QUERY_POSTFIX = "&client=PHEX&version=" + PhexVersion.getFullVersion();
    private static final Logger logger = LoggerFactory.getLogger(GWebCacheConnection.class);
    private GWebCacheHost gWebCache;
    private HttpMethod method;
    private BufferedReader reader;
    private boolean isCacheBad;

    public GWebCacheConnection(GWebCacheHost aGWebCache) throws ProtocolNotSupportedException {
        if (!aGWebCache.getUrl().getProtocol().equals("http")) {
            throw new ProtocolNotSupportedException("Only http URLs are supported for a GWebCacheConnection");
        }
        this.gWebCache = aGWebCache;
        this.isCacheBad = false;
    }

    public GWebCacheHost getGWebCache() {
        return this.gWebCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendPingRequest() {
        try {
            URL requestURL = new URL(this.gWebCache.getUrl(), this.gWebCache.getUrl().getPath() + '?' + PING_QUERY + QUERY_POSTFIX);
            if (requestURL.getHost() == null) {
                logger.warn("Host is null");
                this.isCacheBad = true;
                boolean bl = false;
                return bl;
            }
            this.openConnection(requestURL);
            String line = this.reader.readLine();
            if (line != null && line.startsWith("PONG")) {
                boolean bl = true;
                return bl;
            }
            this.isCacheBad = true;
            boolean bl = false;
            return bl;
        }
        catch (UnknownHostException exp) {
            logger.debug(exp.getMessage(), (Throwable)exp);
            this.isCacheBad = true;
            boolean bl = false;
            return bl;
        }
        catch (IOException exp) {
            logger.debug(exp.getMessage(), (Throwable)exp);
            this.isCacheBad = true;
            boolean bl = false;
            return bl;
        }
        finally {
            this.closeConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DestAddress[] sendHostFileRequest(PhexSecurityManager securityService) {
        try {
            URL requestURL = new URL(this.gWebCache.getUrl(), this.gWebCache.getUrl().getPath() + '?' + HOST_FILE_QUERY + QUERY_POSTFIX);
            if (requestURL.getHost() == null) {
                logger.warn("Host is null");
                this.isCacheBad = true;
                DestAddress[] destAddressArray = null;
                return destAddressArray;
            }
            this.openConnection(requestURL);
            String line = this.reader.readLine();
            if (line != null && line.startsWith("ERROR")) {
                this.isCacheBad = true;
                DestAddress[] destAddressArray = null;
                return destAddressArray;
            }
            boolean falseHostFound = false;
            ArrayList<DestAddress> hostFileList = new ArrayList<DestAddress>(20);
            PresentationManager presentationMgr = PresentationManager.getInstance();
            while (line != null) {
                try {
                    DestAddress destAddress = presentationMgr.createHostAddress(line, -1);
                    if (!destAddress.isIpHostName() || !destAddress.isValidAddress()) {
                        throw new MalformedDestAddressException("Invalid address.");
                    }
                    AccessType access = securityService.controlHostAddressAccess(destAddress);
                    switch (access) {
                        case ACCESS_DENIED: 
                        case ACCESS_STRONGLY_DENIED: {
                            break;
                        }
                        case ACCESS_GRANTED: {
                            hostFileList.add(destAddress);
                        }
                    }
                }
                catch (MalformedDestAddressException exp) {
                    logger.debug("Invalid host found: {}", (Object)line);
                    falseHostFound = true;
                    line = this.reader.readLine();
                    continue;
                }
                line = this.reader.readLine();
            }
            if (hostFileList.size() == 0 && falseHostFound) {
                this.isCacheBad = true;
                DestAddress[] exp = null;
                return exp;
            }
            DestAddress[] hostFileArr = new DestAddress[hostFileList.size()];
            hostFileList.toArray(hostFileArr);
            logger.debug("Hosts found: {}", (Object)hostFileArr.length);
            DestAddress[] destAddressArray = hostFileArr;
            return destAddressArray;
        }
        catch (IOException exp) {
            logger.debug(exp.toString(), (Throwable)exp);
            this.isCacheBad = true;
            DestAddress[] destAddressArray = null;
            return destAddressArray;
        }
        finally {
            this.closeConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL[] sendURLFileRequest() {
        try {
            URL requestURL = new URL(this.gWebCache.getUrl(), this.gWebCache.getUrl().getPath() + '?' + URL_FILE_QUERY + QUERY_POSTFIX);
            if (requestURL.getHost() == null) {
                logger.warn("Host is null");
                this.isCacheBad = true;
                URL[] uRLArray = null;
                return uRLArray;
            }
            this.openConnection(requestURL);
            String line = this.reader.readLine();
            if (line != null && line.startsWith("ERROR")) {
                this.isCacheBad = true;
                URL[] uRLArray = null;
                return uRLArray;
            }
            boolean falseURLFound = false;
            ArrayList<URL> urlFileList = new ArrayList<URL>(20);
            for (int counter = 0; line != null && counter < 20; ++counter) {
                try {
                    NormalizableURL helpUrl = new NormalizableURL(line);
                    helpUrl.normalize();
                    URL url = new URL(helpUrl.toExternalForm());
                    if (!url.getProtocol().equals("http")) {
                        throw new ProtocolNotSupportedException("Only http URLs are supported for a GWebCacheConnection");
                    }
                    urlFileList.add(url);
                }
                catch (MalformedURLException exp) {
                    falseURLFound = true;
                }
                line = this.reader.readLine();
            }
            if (urlFileList.size() == 0 && falseURLFound) {
                this.isCacheBad = true;
                URL[] exp = null;
                return exp;
            }
            URL[] urlFileArr = new URL[urlFileList.size()];
            urlFileList.toArray(urlFileArr);
            logger.debug("URLs found: {}", (Object)urlFileArr.length);
            URL[] uRLArray = urlFileArr;
            return uRLArray;
        }
        catch (IOException exp) {
            logger.debug(exp.getMessage(), (Throwable)exp);
            this.isCacheBad = true;
            URL[] uRLArray = null;
            return uRLArray;
        }
        finally {
            this.closeConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateRequest(String fullHostName, String cacheURL) {
        if (fullHostName == null && cacheURL == null) {
            throw new IllegalArgumentException("Must provide at least one of hostIP or cacheURL.");
        }
        try {
            URL requestURL;
            StringBuffer queryBuffer = new StringBuffer();
            if (fullHostName != null) {
                queryBuffer.append(IP_QUERY);
                queryBuffer.append(URLCodecUtils.encodeURL(fullHostName));
            }
            if (cacheURL != null) {
                if (fullHostName != null) {
                    queryBuffer.append('&');
                }
                queryBuffer.append(URL_QUERY);
                queryBuffer.append(URLCodecUtils.encodeURL(cacheURL));
            }
            if ((requestURL = new URL(this.gWebCache.getUrl(), this.gWebCache.getUrl().getPath() + '?' + queryBuffer.toString() + QUERY_POSTFIX)).getHost() == null) {
                logger.warn("Host is null");
                this.isCacheBad = true;
                boolean bl = false;
                return bl;
            }
            this.openConnection(requestURL);
            String line = this.reader.readLine();
            if (line != null && line.startsWith("OK")) {
                boolean bl = true;
                return bl;
            }
            this.isCacheBad = true;
            boolean bl = false;
            return bl;
        }
        catch (IOException exp) {
            logger.debug(exp.getMessage(), (Throwable)exp);
            this.isCacheBad = true;
            boolean bl = false;
            return bl;
        }
        finally {
            this.closeConnection();
        }
    }

    public boolean isCacheBad() {
        return this.isCacheBad;
    }

    private void openConnection(URL requestURL) throws IOException {
        HttpClient client = new HttpClient();
        client.getParams().setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler(0, false));
        if (ProxyPrefs.UseHttp.get().booleanValue() && !StringUtils.isEmpty(ProxyPrefs.HttpHost.get())) {
            client.getHostConfiguration().setProxy(ProxyPrefs.HttpHost.get(), ProxyPrefs.HttpPort.get().intValue());
        }
        this.method = new GetMethod(requestURL.toExternalForm());
        this.method.setFollowRedirects(false);
        this.method.addRequestHeader("Cache-Control", "no-cache");
        this.method.addRequestHeader("Connection", "close");
        logger.debug("Open GWebCache connection to {}.", (Object)requestURL);
        int responseCode = client.executeMethod(this.method);
        logger.debug("GWebCache {} returned response code: {}", (Object)requestURL, (Object)responseCode);
        if (responseCode < 200 || responseCode > 299) {
            throw new ConnectException("GWebCache service not available, response code: " + responseCode);
        }
        InputStream bodyStream = this.method.getResponseBodyAsStream();
        if (bodyStream == null) {
            throw new ConnectException("Empty response.");
        }
        this.reader = new BufferedReader(new InputStreamReader(bodyStream));
    }

    private void closeConnection() {
        IOUtil.closeQuietly(this.reader);
        this.reader = null;
        if (this.method != null) {
            this.method.releaseConnection();
            this.method = null;
        }
        logger.debug("Releasing HTTP method.");
    }
}

