/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cobertura.instrument;

import java.util.Collection;
import net.sourceforge.cobertura.coveragedata.ClassData;
import net.sourceforge.cobertura.util.RegexUtil;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodAdapter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;

public class MethodInstrumenter
extends MethodAdapter
implements Opcodes {
    private final String ownerClass;
    private String myName;
    private String myDescriptor;
    private Collection ignoreRegexs;
    private ClassData classData;
    private int currentLine = 0;

    public MethodInstrumenter(ClassData classData, MethodVisitor mv, String owner, String myName, String myDescriptor, Collection ignoreRegexs) {
        super(mv);
        this.classData = classData;
        this.ownerClass = owner;
        this.myName = myName;
        this.myDescriptor = myDescriptor;
        this.ignoreRegexs = ignoreRegexs;
    }

    public void visitJumpInsn(int opcode, Label label) {
        super.visitJumpInsn(opcode, label);
        if (opcode != 167 && this.currentLine != 0 && !this.myName.equals("<clinit>")) {
            this.classData.markLineAsBranch(this.currentLine);
        }
    }

    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        super.visitLookupSwitchInsn(dflt, keys, labels);
        if (this.currentLine != 0) {
            this.classData.markLineAsBranch(this.currentLine);
        }
    }

    public void visitLineNumber(int line, Label start) {
        this.currentLine = line;
        this.classData.addLine(this.currentLine, this.myName, this.myDescriptor);
        this.mv.visitMethodInsn(184, "net/sourceforge/cobertura/coveragedata/ProjectData", "getGlobalProjectData", "()Lnet/sourceforge/cobertura/coveragedata/ProjectData;");
        this.mv.visitLdcInsn((Object)this.ownerClass);
        this.mv.visitMethodInsn(182, "net/sourceforge/cobertura/coveragedata/ProjectData", "getOrCreateClassData", "(Ljava/lang/String;)Lnet/sourceforge/cobertura/coveragedata/ClassData;");
        this.mv.visitIntInsn(17, line);
        this.mv.visitMethodInsn(182, "net/sourceforge/cobertura/coveragedata/ClassData", "touch", "(I)V");
        super.visitLineNumber(line, start);
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc) {
        super.visitMethodInsn(opcode, owner, name, desc);
        if (RegexUtil.matches(this.ignoreRegexs, owner)) {
            this.classData.removeLine(this.currentLine);
        }
    }
}

