/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cobertura.coveragedata;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.sourceforge.cobertura.coveragedata.CoverageData;
import net.sourceforge.cobertura.coveragedata.HasBeenInstrumented;

public abstract class CoverageDataContainer
implements CoverageData,
HasBeenInstrumented,
Serializable {
    Map children = new HashMap();

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(this.getClass())) {
            return false;
        }
        CoverageDataContainer coverageDataContainer = (CoverageDataContainer)obj;
        return this.children.equals(coverageDataContainer.children);
    }

    public double getBranchCoverageRate() {
        int number = 0;
        int numberCovered = 0;
        Iterator iter = this.children.values().iterator();
        while (iter.hasNext()) {
            CoverageData coverageContainer = (CoverageData)iter.next();
            number += coverageContainer.getNumberOfValidBranches();
            numberCovered += coverageContainer.getNumberOfCoveredBranches();
        }
        if (number == 0) {
            return 1.0;
        }
        return (double)numberCovered / (double)number;
    }

    public CoverageData getChild(String name) {
        return (CoverageData)this.children.get(name);
    }

    public double getLineCoverageRate() {
        int number = 0;
        int numberCovered = 0;
        Iterator iter = this.children.values().iterator();
        while (iter.hasNext()) {
            CoverageData coverageContainer = (CoverageData)iter.next();
            number += coverageContainer.getNumberOfValidLines();
            numberCovered += coverageContainer.getNumberOfCoveredLines();
        }
        if (number == 0) {
            return 1.0;
        }
        return (double)numberCovered / (double)number;
    }

    public int getNumberOfChildren() {
        return this.children.size();
    }

    public int getNumberOfCoveredBranches() {
        int number = 0;
        Iterator iter = this.children.values().iterator();
        while (iter.hasNext()) {
            CoverageData coverageContainer = (CoverageData)iter.next();
            number += coverageContainer.getNumberOfCoveredBranches();
        }
        return number;
    }

    public int getNumberOfCoveredLines() {
        int number = 0;
        Iterator iter = this.children.values().iterator();
        while (iter.hasNext()) {
            CoverageData coverageContainer = (CoverageData)iter.next();
            number += coverageContainer.getNumberOfCoveredLines();
        }
        return number;
    }

    public int getNumberOfValidBranches() {
        int number = 0;
        Iterator iter = this.children.values().iterator();
        while (iter.hasNext()) {
            CoverageData coverageContainer = (CoverageData)iter.next();
            number += coverageContainer.getNumberOfValidBranches();
        }
        return number;
    }

    public int getNumberOfValidLines() {
        int number = 0;
        Iterator iter = this.children.values().iterator();
        while (iter.hasNext()) {
            CoverageData coverageContainer = (CoverageData)iter.next();
            number += coverageContainer.getNumberOfValidLines();
        }
        return number;
    }

    public int hashCode() {
        return this.children.size();
    }

    public void merge(CoverageData coverageData) {
        CoverageDataContainer container = (CoverageDataContainer)coverageData;
        Iterator iter = container.children.keySet().iterator();
        while (iter.hasNext()) {
            Object key = iter.next();
            CoverageData newChild = (CoverageData)container.children.get(key);
            CoverageData existingChild = (CoverageData)this.children.get(key);
            if (existingChild != null) {
                existingChild.merge(newChild);
                continue;
            }
            this.children.put(key, newChild);
        }
    }
}

