/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cobertura.coveragedata;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import net.sourceforge.cobertura.coveragedata.CoverageData;
import net.sourceforge.cobertura.coveragedata.CoverageDataContainer;
import net.sourceforge.cobertura.coveragedata.HasBeenInstrumented;
import net.sourceforge.cobertura.coveragedata.LineData;

public class ClassData
extends CoverageDataContainer
implements Comparable,
HasBeenInstrumented {
    private static final long serialVersionUID = 5L;
    private Map branches = new HashMap();
    private boolean containsInstrumentationInfo = false;
    private Set methodNamesAndDescriptors = new HashSet();
    private String name = null;
    private String sourceFileName = null;
    static /* synthetic */ Class class$net$sourceforge$cobertura$coveragedata$ClassData;

    public ClassData(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Class name must be specified.");
        }
        this.name = name;
    }

    public LineData addLine(int lineNumber, String methodName, String methodDescriptor) {
        LineData lineData = this.getLineData(lineNumber);
        if (lineData == null) {
            lineData = new LineData(lineNumber);
            this.children.put(new Integer(lineNumber), lineData);
        }
        lineData.setMethodNameAndDescriptor(methodName, methodDescriptor);
        if (methodName != null && methodDescriptor != null) {
            this.methodNamesAndDescriptors.add(methodName + methodDescriptor);
        }
        return lineData;
    }

    public int compareTo(Object o) {
        if (!o.getClass().equals(class$net$sourceforge$cobertura$coveragedata$ClassData == null ? (class$net$sourceforge$cobertura$coveragedata$ClassData = ClassData.class$("net.sourceforge.cobertura.coveragedata.ClassData")) : class$net$sourceforge$cobertura$coveragedata$ClassData)) {
            return Integer.MAX_VALUE;
        }
        return this.name.compareTo(((ClassData)o).name);
    }

    public boolean containsInstrumentationInfo() {
        return this.containsInstrumentationInfo;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(this.getClass())) {
            return false;
        }
        ClassData classData = (ClassData)obj;
        return super.equals(obj) && this.branches.equals(classData.branches) && this.methodNamesAndDescriptors.equals(classData.methodNamesAndDescriptors) && this.name.equals(classData.name) && this.sourceFileName.equals(classData.sourceFileName);
    }

    public String getBaseName() {
        int lastDot = this.name.lastIndexOf(46);
        if (lastDot == -1) {
            return this.name;
        }
        return this.name.substring(lastDot + 1);
    }

    public double getBranchCoverageRate(String methodNameAndDescriptor) {
        int total = 0;
        int hits = 0;
        Iterator iter = this.branches.values().iterator();
        while (iter.hasNext()) {
            LineData next = (LineData)iter.next();
            if (!methodNameAndDescriptor.equals(next.getMethodName() + next.getMethodDescriptor())) continue;
            ++total;
            if (next.getHits() <= 0L) continue;
            ++hits;
        }
        if (total == 0) {
            return 1.0;
        }
        return (double)hits / (double)total;
    }

    public Collection getBranches() {
        return Collections.unmodifiableCollection(this.branches.keySet());
    }

    public long getHitCount(int lineNumber) {
        Integer lineObject = new Integer(lineNumber);
        if (!this.children.containsKey(lineObject)) {
            return 0L;
        }
        return ((LineData)this.children.get(lineObject)).getHits();
    }

    public double getLineCoverageRate(String methodNameAndDescriptor) {
        int total = 0;
        int hits = 0;
        Iterator iter = this.children.values().iterator();
        while (iter.hasNext()) {
            LineData next = (LineData)iter.next();
            if (!methodNameAndDescriptor.equals(next.getMethodName() + next.getMethodDescriptor())) continue;
            ++total;
            if (next.getHits() <= 0L) continue;
            ++hits;
        }
        if (total == 0) {
            return 1.0;
        }
        return (double)hits / (double)total;
    }

    private LineData getLineData(int lineNumber) {
        return (LineData)this.children.get(new Integer(lineNumber));
    }

    public SortedSet getLines() {
        return new TreeSet(this.children.values());
    }

    public Collection getLines(String methodNameAndDescriptor) {
        HashSet<LineData> lines = new HashSet<LineData>();
        Iterator iter = this.children.values().iterator();
        while (iter.hasNext()) {
            LineData next = (LineData)iter.next();
            if (!methodNameAndDescriptor.equals(next.getMethodName() + next.getMethodDescriptor())) continue;
            lines.add(next);
        }
        return lines;
    }

    public Set getMethodNamesAndDescriptors() {
        return this.methodNamesAndDescriptors;
    }

    public String getName() {
        return this.name;
    }

    public int getNumberOfValidBranches() {
        return this.branches.size();
    }

    public String getPackageName() {
        int lastDot = this.name.lastIndexOf(46);
        if (lastDot == -1) {
            return "";
        }
        return this.name.substring(0, lastDot);
    }

    public String getSourceFileName() {
        String baseName;
        int firstDollarSign;
        baseName = this.sourceFileName != null ? this.sourceFileName : ((firstDollarSign = (baseName = this.getBaseName()).indexOf(36)) == -1 || firstDollarSign == 0 ? baseName + ".java" : baseName.substring(0, firstDollarSign) + ".java");
        String packageName = this.getPackageName();
        if (packageName.equals("")) {
            return baseName;
        }
        return packageName.replace('.', '/') + '/' + baseName;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean isBranch(int lineNumber) {
        return this.branches.containsKey(new Integer(lineNumber));
    }

    public boolean isValidSourceLineNumber(int lineNumber) {
        return this.children.containsKey(new Integer(lineNumber));
    }

    public void markLineAsBranch(int lineNumber) {
        LineData lineData = this.getLineData(lineNumber);
        if (lineData != null) {
            lineData.setBranch(true);
            this.branches.put(new Integer(lineNumber), lineData);
        }
    }

    public void merge(CoverageData coverageData) {
        ClassData classData = (ClassData)coverageData;
        if (!this.getName().equals(classData.getName())) {
            return;
        }
        super.merge(coverageData);
        Iterator iter = classData.branches.keySet().iterator();
        while (iter.hasNext()) {
            Object key = iter.next();
            if (this.branches.containsKey(key)) continue;
            this.branches.put(key, classData.branches.get(key));
        }
        this.containsInstrumentationInfo |= classData.containsInstrumentationInfo;
        this.methodNamesAndDescriptors.addAll(classData.getMethodNamesAndDescriptors());
        if (classData.sourceFileName != null) {
            this.sourceFileName = classData.sourceFileName;
        }
    }

    public void removeLine(int lineNumber) {
        Integer lineObject = new Integer(lineNumber);
        this.children.remove(lineObject);
        this.branches.remove(lineObject);
    }

    public void setContainsInstrumentationInfo() {
        this.containsInstrumentationInfo = true;
    }

    public void setSourceFileName(String sourceFileName) {
        this.sourceFileName = sourceFileName;
    }

    public void touch(int lineNumber) {
        LineData lineData = this.getLineData(lineNumber);
        if (lineData == null) {
            lineData = this.addLine(lineNumber, null, null);
        }
        lineData.touch();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

