/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.text.Collator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.search.FieldCacheImpl;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.ScoreDocComparator;
import org.apache.lucene.search.SortComparatorSource;
import org.apache.lucene.search.SortField;
import org.apache.lucene.util.PriorityQueue;

class FieldSortedHitQueue
extends PriorityQueue {
    protected ScoreDocComparator[] comparators;
    protected SortField[] fields;
    protected float maxscore = 1.0f;
    static final Map Comparators = new WeakHashMap();

    FieldSortedHitQueue(IndexReader reader, SortField[] fields, int size) throws IOException {
        int n = fields.length;
        this.comparators = new ScoreDocComparator[n];
        this.fields = new SortField[n];
        for (int i = 0; i < n; ++i) {
            String fieldname = fields[i].getField();
            this.comparators[i] = FieldSortedHitQueue.getCachedComparator(reader, fieldname, fields[i].getType(), fields[i].getLocale(), fields[i].getFactory());
            this.fields[i] = new SortField(fieldname, this.comparators[i].sortType(), fields[i].getReverse());
        }
        this.initialize(size);
    }

    protected final boolean lessThan(Object a, Object b) {
        ScoreDoc docA = (ScoreDoc)a;
        ScoreDoc docB = (ScoreDoc)b;
        if (docA.score > this.maxscore) {
            this.maxscore = docA.score;
        }
        if (docB.score > this.maxscore) {
            this.maxscore = docB.score;
        }
        int n = this.comparators.length;
        int c = 0;
        for (int i = 0; i < n && c == 0; ++i) {
            c = this.fields[i].reverse ? this.comparators[i].compare(docB, docA) : this.comparators[i].compare(docA, docB);
        }
        return c > 0;
    }

    FieldDoc fillFields(FieldDoc doc) {
        int n = this.comparators.length;
        Comparable[] fields = new Comparable[n];
        for (int i = 0; i < n; ++i) {
            fields[i] = this.comparators[i].sortValue(doc);
        }
        doc.fields = fields;
        if (this.maxscore > 1.0f) {
            doc.score /= this.maxscore;
        }
        return doc;
    }

    SortField[] getFields() {
        return this.fields;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ScoreDocComparator lookup(IndexReader reader, String field, int type, Object factory) {
        FieldCacheImpl.Entry entry = factory != null ? new FieldCacheImpl.Entry(field, factory) : new FieldCacheImpl.Entry(field, type);
        Map map = Comparators;
        synchronized (map) {
            HashMap readerCache = (HashMap)Comparators.get(reader);
            if (readerCache == null) {
                return null;
            }
            return (ScoreDocComparator)readerCache.get(entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Object store(IndexReader reader, String field, int type, Object factory, Object value) {
        FieldCacheImpl.Entry entry = factory != null ? new FieldCacheImpl.Entry(field, factory) : new FieldCacheImpl.Entry(field, type);
        Map map = Comparators;
        synchronized (map) {
            HashMap<FieldCacheImpl.Entry, Object> readerCache = (HashMap<FieldCacheImpl.Entry, Object>)Comparators.get(reader);
            if (readerCache == null) {
                readerCache = new HashMap<FieldCacheImpl.Entry, Object>();
                Comparators.put(reader, readerCache);
            }
            return readerCache.put(entry, value);
        }
    }

    static ScoreDocComparator getCachedComparator(IndexReader reader, String fieldname, int type, Locale locale, SortComparatorSource factory) throws IOException {
        if (type == 1) {
            return ScoreDocComparator.INDEXORDER;
        }
        if (type == 0) {
            return ScoreDocComparator.RELEVANCE;
        }
        ScoreDocComparator comparator = FieldSortedHitQueue.lookup(reader, fieldname, type, factory);
        if (comparator == null) {
            switch (type) {
                case 2: {
                    comparator = FieldSortedHitQueue.comparatorAuto(reader, fieldname);
                    break;
                }
                case 4: {
                    comparator = FieldSortedHitQueue.comparatorInt(reader, fieldname);
                    break;
                }
                case 5: {
                    comparator = FieldSortedHitQueue.comparatorFloat(reader, fieldname);
                    break;
                }
                case 3: {
                    if (locale != null) {
                        comparator = FieldSortedHitQueue.comparatorStringLocale(reader, fieldname, locale);
                        break;
                    }
                    comparator = FieldSortedHitQueue.comparatorString(reader, fieldname);
                    break;
                }
                case 9: {
                    comparator = factory.newComparator(reader, fieldname);
                    break;
                }
                default: {
                    throw new RuntimeException("unknown field type: " + type);
                }
            }
            FieldSortedHitQueue.store(reader, fieldname, type, factory, comparator);
        }
        return comparator;
    }

    static ScoreDocComparator comparatorInt(final IndexReader reader, String fieldname) throws IOException {
        final String field = fieldname.intern();
        return new ScoreDocComparator(){
            final int[] fieldOrder;
            {
                this.fieldOrder = FieldCache.DEFAULT.getInts(reader, field);
            }

            public final int compare(ScoreDoc i, ScoreDoc j) {
                int fi = this.fieldOrder[i.doc];
                int fj = this.fieldOrder[j.doc];
                if (fi < fj) {
                    return -1;
                }
                if (fi > fj) {
                    return 1;
                }
                return 0;
            }

            public Comparable sortValue(ScoreDoc i) {
                return new Integer(this.fieldOrder[i.doc]);
            }

            public int sortType() {
                return 4;
            }
        };
    }

    static ScoreDocComparator comparatorFloat(final IndexReader reader, String fieldname) throws IOException {
        final String field = fieldname.intern();
        return new ScoreDocComparator(){
            protected final float[] fieldOrder;
            {
                this.fieldOrder = FieldCache.DEFAULT.getFloats(reader, field);
            }

            public final int compare(ScoreDoc i, ScoreDoc j) {
                float fi = this.fieldOrder[i.doc];
                float fj = this.fieldOrder[j.doc];
                if (fi < fj) {
                    return -1;
                }
                if (fi > fj) {
                    return 1;
                }
                return 0;
            }

            public Comparable sortValue(ScoreDoc i) {
                return new Float(this.fieldOrder[i.doc]);
            }

            public int sortType() {
                return 5;
            }
        };
    }

    static ScoreDocComparator comparatorString(final IndexReader reader, String fieldname) throws IOException {
        final String field = fieldname.intern();
        return new ScoreDocComparator(){
            final FieldCache.StringIndex index;
            {
                this.index = FieldCache.DEFAULT.getStringIndex(reader, field);
            }

            public final int compare(ScoreDoc i, ScoreDoc j) {
                int fi = this.index.order[i.doc];
                int fj = this.index.order[j.doc];
                if (fi < fj) {
                    return -1;
                }
                if (fi > fj) {
                    return 1;
                }
                return 0;
            }

            public Comparable sortValue(ScoreDoc i) {
                return this.index.lookup[this.index.order[i.doc]];
            }

            public int sortType() {
                return 3;
            }
        };
    }

    static ScoreDocComparator comparatorStringLocale(final IndexReader reader, String fieldname, Locale locale) throws IOException {
        final Collator collator = Collator.getInstance(locale);
        final String field = fieldname.intern();
        return new ScoreDocComparator(){
            final String[] index;
            {
                this.index = FieldCache.DEFAULT.getStrings(reader, field);
            }

            public final int compare(ScoreDoc i, ScoreDoc j) {
                return collator.compare(this.index[i.doc], this.index[j.doc]);
            }

            public Comparable sortValue(ScoreDoc i) {
                return this.index[i.doc];
            }

            public int sortType() {
                return 3;
            }
        };
    }

    static ScoreDocComparator comparatorAuto(IndexReader reader, String fieldname) throws IOException {
        String field = fieldname.intern();
        Object lookupArray = FieldCache.DEFAULT.getAuto(reader, field);
        if (lookupArray instanceof FieldCache.StringIndex) {
            return FieldSortedHitQueue.comparatorString(reader, field);
        }
        if (lookupArray instanceof int[]) {
            return FieldSortedHitQueue.comparatorInt(reader, field);
        }
        if (lookupArray instanceof float[]) {
            return FieldSortedHitQueue.comparatorFloat(reader, field);
        }
        if (lookupArray instanceof String[]) {
            return FieldSortedHitQueue.comparatorString(reader, field);
        }
        throw new RuntimeException("unknown data type in field '" + field + "'");
    }
}

