/*
 * Decompiled with CFR 0.152.
 */
package com.octo.captcha.service.captchastore;

import com.octo.captcha.Captcha;
import com.octo.captcha.service.CaptchaServiceException;
import com.octo.captcha.service.captchastore.CaptchaAndLocale;
import com.octo.captcha.service.captchastore.CaptchaStore;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Locale;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Element;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EhcacheCaptchaStore
implements CaptchaStore {
    private Cache cache;
    private static Log log = LogFactory.getLog((Class)(class$com$octo$captcha$service$captchastore$EhcacheCaptchaStore == null ? (class$com$octo$captcha$service$captchastore$EhcacheCaptchaStore = EhcacheCaptchaStore.class$("com.octo.captcha.service.captchastore.EhcacheCaptchaStore")) : class$com$octo$captcha$service$captchastore$EhcacheCaptchaStore));
    static /* synthetic */ Class class$com$octo$captcha$service$captchastore$EhcacheCaptchaStore;

    public EhcacheCaptchaStore(Cache cache) {
        this.cache = cache;
    }

    public boolean hasCaptcha(String id) {
        try {
            Element el = this.cache.get((Serializable)((Object)id));
            return el != null && el.getValue() != null;
        }
        catch (CacheException e) {
            log.error((Object)e);
            return false;
        }
    }

    public void storeCaptcha(String id, Captcha captcha) throws CaptchaServiceException {
        this.cache.put(new Element((Serializable)((Object)id), (Serializable)new CaptchaAndLocale(captcha)));
    }

    public void storeCaptcha(String id, Captcha captcha, Locale locale) throws CaptchaServiceException {
        this.cache.put(new Element((Serializable)((Object)id), (Serializable)new CaptchaAndLocale(captcha, locale)));
    }

    public Captcha getCaptcha(String id) throws CaptchaServiceException {
        try {
            Element el = this.cache.get((Serializable)((Object)id));
            if (el != null) {
                return ((CaptchaAndLocale)el.getValue()).getCaptcha();
            }
            return null;
        }
        catch (CacheException e) {
            log.error((Object)e);
            return null;
        }
    }

    public Locale getLocale(String id) throws CaptchaServiceException {
        try {
            Element el = this.cache.get((Serializable)((Object)id));
            if (el != null) {
                return ((CaptchaAndLocale)el.getValue()).getLocale();
            }
            return null;
        }
        catch (CacheException e) {
            log.error((Object)e);
            return null;
        }
    }

    public boolean removeCaptcha(String id) {
        return this.cache.remove((Serializable)((Object)id));
    }

    public int getSize() {
        return (int)this.cache.getMemoryStoreSize() + this.cache.getDiskStoreSize();
    }

    public Collection getKeys() {
        try {
            return this.cache.getKeys();
        }
        catch (CacheException e) {
            log.error((Object)e);
            return null;
        }
    }

    public void empty() {
        try {
            this.cache.removeAll();
        }
        catch (IOException e) {
            log.error((Object)e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

