/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.ImageMath;
import java.awt.image.RGBImageFilter;
import java.io.Serializable;

public class FadeFilter
extends RGBImageFilter
implements Serializable {
    private int width;
    private int height;
    private double angle = 0.0;
    private double fadeStart = 1.0;
    private double fadeWidth = 10.0;
    private int sides;
    private boolean invert;
    private double m00 = 1.0;
    private double m01 = 0.0;
    private double m10 = 0.0;
    private double m11 = 1.0;

    public void setAngle(double d) {
        this.angle = d;
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        this.m00 = d2;
        this.m01 = d3;
        this.m10 = -d3;
        this.m11 = d2;
    }

    public double getAngle() {
        return this.angle;
    }

    public void setSides(int n) {
        this.sides = n;
    }

    public int getSides() {
        return this.sides;
    }

    public void setFadeStart(double d) {
        this.fadeStart = d;
    }

    public double getFadeStart() {
        return this.fadeStart;
    }

    public void setFadeWidth(double d) {
        this.fadeWidth = d;
    }

    public double getFadeWidth() {
        return this.fadeWidth;
    }

    public void setInvert(boolean bl) {
        this.invert = bl;
    }

    public boolean getInvert() {
        return this.invert;
    }

    public void setDimensions(int n, int n2) {
        this.width = n;
        this.height = n2;
        super.setDimensions(n, n2);
    }

    public int filterRGB(int n, int n2, int n3) {
        double d = this.m00 * (double)n + this.m01 * (double)n2;
        double d2 = this.m10 * (double)n + this.m11 * (double)n2;
        if (this.sides == 2) {
            d = Math.sqrt(d * d + d2 * d2);
        } else if (this.sides == 3) {
            d = ImageMath.mod(d, 16.0);
        } else if (this.sides == 4) {
            d = this.symmetry(d, 16.0);
        }
        int n4 = (int)(ImageMath.smoothStep(this.fadeStart, this.fadeStart + this.fadeWidth, d) * 255.0);
        if (this.invert) {
            n4 = 255 - n4;
        }
        return n4 << 24 | n3 & 0xFFFFFF;
    }

    public double symmetry(double d, double d2) {
        if ((d = ImageMath.mod(d, 2.0 * d2)) > d2) {
            return 2.0 * d2 - d;
        }
        return d;
    }

    public String toString() {
        return "Fade...";
    }
}

