/*
 * Decompiled with CFR 0.152.
 */
package com.sun.syndication.propono.blogclient.atomprotocol;

import com.sun.syndication.propono.atom.client.ClientEntry;
import com.sun.syndication.propono.atom.client.ClientMediaEntry;
import com.sun.syndication.propono.blogclient.BlogClientException;
import com.sun.syndication.propono.blogclient.atomprotocol.AtomCollection;
import com.sun.syndication.propono.blogclient.atomprotocol.AtomEntry;
import com.sun.syndication.propono.blogclient.atomprotocol.AtomResource;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AtomEntryIterator
implements Iterator {
    static final Log logger = LogFactory.getLog(AtomEntryIterator.class);
    private Iterator iterator = null;
    private AtomCollection collection = null;

    AtomEntryIterator(AtomCollection collection) throws BlogClientException {
        try {
            this.collection = collection;
            this.iterator = collection.getClientCollection().getEntries();
        }
        catch (Exception e) {
            throw new BlogClientException("ERROR fetching collection", e);
        }
    }

    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    public Object next() {
        try {
            ClientEntry entry = (ClientEntry)((Object)this.iterator.next());
            if (entry instanceof ClientMediaEntry) {
                return new AtomResource(this.collection, (ClientMediaEntry)entry);
            }
            return new AtomEntry(this.collection, entry);
        }
        catch (Exception e) {
            logger.error((Object)"ERROR fetching entry", (Throwable)e);
            return null;
        }
    }

    public void remove() {
    }
}

