/*
 * Decompiled with CFR 0.152.
 */
package com.sun.syndication.propono.blogclient.atomprotocol;

import com.sun.syndication.feed.atom.Category;
import com.sun.syndication.propono.atom.client.ClientAtomService;
import com.sun.syndication.propono.atom.client.ClientCollection;
import com.sun.syndication.propono.atom.client.ClientEntry;
import com.sun.syndication.propono.atom.common.Categories;
import com.sun.syndication.propono.blogclient.Blog;
import com.sun.syndication.propono.blogclient.BlogClientException;
import com.sun.syndication.propono.blogclient.BlogEntry;
import com.sun.syndication.propono.blogclient.BlogResource;
import com.sun.syndication.propono.blogclient.atomprotocol.AtomBlog;
import com.sun.syndication.propono.blogclient.atomprotocol.AtomEntry;
import com.sun.syndication.propono.blogclient.atomprotocol.AtomEntryIterator;
import com.sun.syndication.propono.blogclient.atomprotocol.AtomResource;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AtomCollection
implements Blog.Collection {
    static final Log logger = LogFactory.getLog(AtomCollection.class);
    private Blog blog = null;
    private List categories = new ArrayList();
    private ClientCollection clientCollection = null;

    AtomCollection(AtomBlog blog, ClientCollection col) {
        this.blog = blog;
        this.clientCollection = col;
        for (Categories cats : col.getCategories()) {
            for (Category cat : cats.getCategories()) {
                BlogEntry.Category blogCat = new BlogEntry.Category(cat.getTerm());
                blogCat.setName(cat.getLabel());
                blogCat.setUrl(cat.getScheme());
                this.getCategories().add(blogCat);
            }
        }
    }

    public String getTitle() {
        return this.getClientCollection().getTitle();
    }

    public String getToken() {
        return this.getClientCollection().getHref();
    }

    public String getAccept() {
        return this.getClientCollection().getAccept();
    }

    public boolean accepts(String ct) {
        return this.getClientCollection().accepts(ct);
    }

    public Iterator getEntries() throws BlogClientException {
        return new AtomEntryIterator(this);
    }

    public BlogEntry newEntry() throws BlogClientException {
        AtomBlog atomBlog = (AtomBlog)this.getBlog();
        AtomEntry entry = new AtomEntry(atomBlog, this);
        return entry;
    }

    public BlogResource newResource(String name, String contentType, byte[] bytes) throws BlogClientException {
        return new AtomResource(this, name, contentType, bytes);
    }

    public String saveResource(BlogResource res) throws BlogClientException {
        ((AtomResource)res).setCollection(this);
        res.save();
        return res.getContent().getSrc();
    }

    public String saveEntry(BlogEntry entry) throws BlogClientException {
        ((AtomEntry)entry).setCollection(this);
        entry.save();
        return entry.getPermalink();
    }

    void deleteEntry(BlogEntry entry) throws BlogClientException {
        try {
            ClientAtomService service = ((AtomBlog)this.getBlog()).getService();
            ClientEntry clientEntry = service.getEntry(entry.getToken());
            clientEntry.remove();
        }
        catch (Exception e) {
            throw new BlogClientException("ERROR deleting entry", e);
        }
    }

    public Blog getBlog() {
        return this.blog;
    }

    void setBlog(AtomBlog blog) {
        this.blog = blog;
    }

    public List getCategories() {
        return this.categories;
    }

    void setCategories(List categories) {
        this.categories = categories;
    }

    ClientCollection getClientCollection() {
        return this.clientCollection;
    }
}

