/*
 * Decompiled with CFR 0.152.
 */
package com.sun.syndication.propono.blogclient.atomprotocol;

import com.sun.syndication.propono.atom.client.ClientAtomService;
import com.sun.syndication.propono.atom.client.ClientCollection;
import com.sun.syndication.propono.atom.client.ClientEntry;
import com.sun.syndication.propono.atom.client.ClientMediaEntry;
import com.sun.syndication.propono.atom.client.ClientWorkspace;
import com.sun.syndication.propono.blogclient.Blog;
import com.sun.syndication.propono.blogclient.BlogClientException;
import com.sun.syndication.propono.blogclient.BlogEntry;
import com.sun.syndication.propono.blogclient.BlogResource;
import com.sun.syndication.propono.blogclient.atomprotocol.AtomCollection;
import com.sun.syndication.propono.blogclient.atomprotocol.AtomEntry;
import com.sun.syndication.propono.blogclient.atomprotocol.AtomEntryIterator;
import com.sun.syndication.propono.blogclient.atomprotocol.AtomResource;
import com.sun.syndication.propono.utils.ProponoException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AtomBlog
implements Blog {
    static final Log logger = LogFactory.getLog(AtomBlog.class);
    private HttpClient httpClient = null;
    private String name = null;
    private ClientAtomService service;
    private ClientWorkspace workspace = null;
    private AtomCollection entriesCollection = null;
    private AtomCollection resourcesCollection = null;
    private Map collections = new TreeMap();

    AtomBlog(ClientAtomService service, ClientWorkspace workspace) {
        this.setService(service);
        this.setWorkspace(workspace);
        this.name = workspace.getTitle();
        for (ClientCollection col : workspace.getCollections()) {
            if ("entry".equals(col.getAccept()) && this.entriesCollection == null) {
                this.entriesCollection = new AtomCollection(this, col);
            } else if (col.getAccept() != null && !col.getAccept().equals("entry") && this.resourcesCollection == null) {
                this.resourcesCollection = new AtomCollection(this, col);
            }
            this.collections.put(col.getHref(), new AtomCollection(this, col));
        }
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.getName();
    }

    public String getToken() {
        return this.entriesCollection.getToken();
    }

    public BlogEntry newEntry() throws BlogClientException {
        if (this.entriesCollection == null) {
            throw new BlogClientException("No entry collection");
        }
        return this.entriesCollection.newEntry();
    }

    public BlogEntry getEntry(String token) throws BlogClientException {
        ClientEntry clientEntry = null;
        Object atomEntry = null;
        try {
            clientEntry = this.getService().getEntry(token);
        }
        catch (ProponoException ex) {
            throw new BlogClientException("ERROR: fetching entry", ex);
        }
        if (clientEntry != null && clientEntry instanceof ClientMediaEntry) {
            return new AtomResource(this, (ClientMediaEntry)clientEntry);
        }
        if (clientEntry != null && clientEntry instanceof ClientEntry) {
            return new AtomEntry(this, clientEntry);
        }
        throw new BlogClientException("ERROR: unknown object type returned");
    }

    public Iterator getEntries() throws BlogClientException {
        if (this.entriesCollection == null) {
            throw new BlogClientException("No primary entry collection");
        }
        return new AtomEntryIterator(this.entriesCollection);
    }

    public Iterator getResources() throws BlogClientException {
        if (this.resourcesCollection == null) {
            throw new BlogClientException("No primary entry collection");
        }
        return new AtomEntryIterator(this.resourcesCollection);
    }

    String saveEntry(BlogEntry entry) throws BlogClientException {
        if (this.entriesCollection == null) {
            throw new BlogClientException("No primary entry collection");
        }
        return this.entriesCollection.saveEntry(entry);
    }

    void deleteEntry(BlogEntry entry) throws BlogClientException {
        if (this.entriesCollection == null) {
            throw new BlogClientException("No primary entry collection");
        }
        this.entriesCollection.deleteEntry(entry);
    }

    public List getCategories() throws BlogClientException {
        if (this.entriesCollection == null) {
            throw new BlogClientException("No primary entry collection");
        }
        return this.entriesCollection.getCategories();
    }

    public BlogResource newResource(String name, String contentType, byte[] bytes) throws BlogClientException {
        if (this.resourcesCollection == null) {
            throw new BlogClientException("No resource collection");
        }
        return this.resourcesCollection.newResource(name, contentType, bytes);
    }

    String saveResource(BlogResource res) throws BlogClientException {
        if (this.resourcesCollection == null) {
            throw new BlogClientException("No primary resource collection");
        }
        return this.resourcesCollection.saveResource(res);
    }

    void deleteResource(BlogResource resource) throws BlogClientException {
        this.deleteEntry(resource);
    }

    public List getCollections() throws BlogClientException {
        return new ArrayList(this.collections.values());
    }

    public Blog.Collection getCollection(String token) throws BlogClientException {
        return (Blog.Collection)this.collections.get(token);
    }

    ClientAtomService getService() {
        return this.service;
    }

    void setService(ClientAtomService service) {
        this.service = service;
    }

    ClientWorkspace getWorkspace() {
        return this.workspace;
    }

    void setWorkspace(ClientWorkspace workspace) {
        this.workspace = workspace;
    }
}

