/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.spring;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.directwebremoting.spring.ConverterConfig;
import org.directwebremoting.util.Logger;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.BeanDefinitionDecorator;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.NamespaceHandlerSupport;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DwrNamespaceHandler
extends NamespaceHandlerSupport {
    protected static final String DEFAULT_SPRING_CONFIGURATOR_ID = "__dwrConfiguration";
    protected static final Logger log = Logger.getLogger(class$org$directwebremoting$spring$DwrNamespaceHandler == null ? (class$org$directwebremoting$spring$DwrNamespaceHandler = DwrNamespaceHandler.class$("org.directwebremoting.spring.DwrNamespaceHandler")) : class$org$directwebremoting$spring$DwrNamespaceHandler);
    static /* synthetic */ Class class$org$directwebremoting$spring$SpringConfigurator;
    static /* synthetic */ Class class$org$directwebremoting$spring$CreatorConfig;
    static /* synthetic */ Class class$org$directwebremoting$filter$ExtraLatencyAjaxFilter;
    static /* synthetic */ Class class$org$directwebremoting$spring$DwrController;
    static /* synthetic */ Class class$org$directwebremoting$spring$BeanCreator;
    static /* synthetic */ Class class$org$directwebremoting$spring$SpringCreator;
    static /* synthetic */ Class class$org$directwebremoting$create$NewCreator;
    static /* synthetic */ Class class$org$directwebremoting$spring$DwrNamespaceHandler;

    public void init() {
        this.registerBeanDefinitionParser("configuration", new ConfigurationBeanDefinitionParser());
        this.registerBeanDefinitionParser("controller", new ControllerBeanDefinitionParser());
        this.registerBeanDefinitionDecorator("create", new CreatorBeanDefinitionDecorator());
        this.registerBeanDefinitionDecorator("convert", new ConverterBeanDefinitionDecorator());
        this.registerBeanDefinitionDecorator("signatures", new SignaturesBeanDefinitionDecorator());
        this.registerBeanDefinitionDecorator("remote", new RemoteBeanDefinitionDecorator());
    }

    protected BeanDefinition registerSpringConfiguratorIfNecessary(BeanDefinitionRegistry registry) {
        if (!registry.containsBeanDefinition(DEFAULT_SPRING_CONFIGURATOR_ID)) {
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition((Class)(class$org$directwebremoting$spring$SpringConfigurator == null ? (class$org$directwebremoting$spring$SpringConfigurator = DwrNamespaceHandler.class$("org.directwebremoting.spring.SpringConfigurator")) : class$org$directwebremoting$spring$SpringConfigurator));
            builder.addPropertyValue("creators", (Object)new ManagedMap());
            builder.addPropertyValue("converters", (Object)new ManagedMap());
            registry.registerBeanDefinition(DEFAULT_SPRING_CONFIGURATOR_ID, (BeanDefinition)builder.getBeanDefinition());
        }
        return registry.getBeanDefinition(DEFAULT_SPRING_CONFIGURATOR_ID);
    }

    protected void registerCreator(BeanDefinitionRegistry registry, String javascript, BeanDefinitionBuilder beanCreator, NodeList children) {
        this.registerSpringConfiguratorIfNecessary(registry);
        BeanDefinitionHolder holder = new BeanDefinitionHolder((BeanDefinition)beanCreator.getBeanDefinition(), "__" + javascript + "_creator");
        BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)holder, (BeanDefinitionRegistry)registry);
        BeanDefinitionBuilder creatorConfig = BeanDefinitionBuilder.rootBeanDefinition((Class)(class$org$directwebremoting$spring$CreatorConfig == null ? (class$org$directwebremoting$spring$CreatorConfig = DwrNamespaceHandler.class$("org.directwebremoting.spring.CreatorConfig")) : class$org$directwebremoting$spring$CreatorConfig));
        creatorConfig.addPropertyReference("creator", "__" + javascript + "_creator");
        ArrayList<String> includes = new ArrayList<String>();
        creatorConfig.addPropertyValue("includes", includes);
        ArrayList<String> excludes = new ArrayList<String>();
        creatorConfig.addPropertyValue("excludes", excludes);
        Properties auth = new Properties();
        creatorConfig.addPropertyValue("auth", (Object)auth);
        for (int i = 0; i < children.getLength(); ++i) {
            Element element;
            Node node = children.item(i);
            if (node.getNodeType() == 3 || node.getNodeType() == 8) continue;
            Element child = (Element)node;
            if (node.getNodeName().equals("dwr:latencyfilter")) {
                BeanDefinitionBuilder beanFilter = BeanDefinitionBuilder.rootBeanDefinition((Class)(class$org$directwebremoting$filter$ExtraLatencyAjaxFilter == null ? DwrNamespaceHandler.class$("org.directwebremoting.filter.ExtraLatencyAjaxFilter") : class$org$directwebremoting$filter$ExtraLatencyAjaxFilter));
                beanFilter.addPropertyValue("delay", (Object)child.getAttribute("delay"));
                BeanDefinitionHolder holder2 = new BeanDefinitionHolder((BeanDefinition)beanFilter.getBeanDefinition(), "__latencyFilter_" + javascript);
                BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)holder2, (BeanDefinitionRegistry)registry);
                ManagedList filterList = new ManagedList();
                filterList.add((Object)new RuntimeBeanReference("__latencyFilter_" + javascript));
                creatorConfig.addPropertyValue("filters", (Object)filterList);
                continue;
            }
            if (node.getNodeName().equals("dwr:include")) {
                includes.add(child.getAttribute("method"));
                continue;
            }
            if (node.getNodeName().equals("dwr:exclude")) {
                excludes.add(child.getAttribute("method"));
                continue;
            }
            if (node.getNodeName().equals("dwr:auth")) {
                auth.setProperty(child.getAttribute("method"), child.getAttribute("role"));
                continue;
            }
            if (node.getNodeName().equals("dwr:convert")) {
                element = (Element)node;
                String type = element.getAttribute("type");
                String className = element.getAttribute("class");
                ConverterConfig converterConfig = new ConverterConfig();
                converterConfig.setType(type);
                this.parseConverterSettings(converterConfig, element);
                this.lookupConverters(registry).put(className, converterConfig);
                continue;
            }
            if (node.getNodeName().equals("dwr:filter")) {
                BeanDefinitionBuilder beanFilter;
                element = (Element)node;
                String filterClass = element.getAttribute("class");
                try {
                    beanFilter = BeanDefinitionBuilder.rootBeanDefinition((Class)ClassUtils.forName((String)filterClass));
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalArgumentException("bla");
                }
                BeanDefinitionHolder holder2 = new BeanDefinitionHolder((BeanDefinition)beanFilter.getBeanDefinition(), "__filter_" + filterClass + "_" + javascript);
                BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)holder2, (BeanDefinitionRegistry)registry);
                ManagedList filterList = new ManagedList();
                filterList.add((Object)new RuntimeBeanReference("__filter_" + filterClass + "_" + javascript));
                creatorConfig.addPropertyValue("filters", (Object)filterList);
                continue;
            }
            throw new RuntimeException("an unknown dwr:remote sub node was fouund: " + node.getNodeName());
        }
        String creatorConfigName = "__" + javascript;
        BeanDefinitionHolder holder3 = new BeanDefinitionHolder((BeanDefinition)creatorConfig.getBeanDefinition(), creatorConfigName);
        BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)holder3, (BeanDefinitionRegistry)registry);
        this.lookupCreators(registry).put(javascript, new RuntimeBeanReference(creatorConfigName));
    }

    protected void parseConverterSettings(ConverterConfig converterConfig, Element parent) {
        NodeList children = parent.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            if (node.getNodeType() == 3 || node.getNodeType() == 8) continue;
            Element child = (Element)node;
            if (child.getNodeName().equals("dwr:include")) {
                converterConfig.addInclude(child.getAttribute("method"));
                continue;
            }
            if (child.getNodeName().equals("dwr:exclude")) {
                converterConfig.addExclude(child.getAttribute("method"));
                continue;
            }
            throw new RuntimeException("an unknown dwr:remote sub node was fouund: " + node.getNodeName());
        }
    }

    protected Map lookupCreators(BeanDefinitionRegistry registry) {
        BeanDefinition config = this.registerSpringConfiguratorIfNecessary(registry);
        return (Map)config.getPropertyValues().getPropertyValue("creators").getValue();
    }

    protected Map lookupConverters(BeanDefinitionRegistry registry) {
        BeanDefinition config = this.registerSpringConfiguratorIfNecessary(registry);
        return (Map)config.getPropertyValues().getPropertyValue("converters").getValue();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class SignaturesBeanDefinitionDecorator
    implements BeanDefinitionDecorator {
        protected SignaturesBeanDefinitionDecorator() {
        }

        public BeanDefinitionHolder decorate(Node node, BeanDefinitionHolder definition, ParserContext parserContext) {
            BeanDefinitionRegistry registry = parserContext.getRegistry();
            BeanDefinition config = DwrNamespaceHandler.this.registerSpringConfiguratorIfNecessary(registry);
            StringBuffer sigtext = new StringBuffer();
            NodeList children = node.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                if (child.getNodeType() != 3 && child.getNodeType() != 4) {
                    log.warn("Ignoring illegal node type: " + child.getNodeType());
                    continue;
                }
                sigtext.append(child.getNodeValue());
            }
            config.getPropertyValues().addPropertyValue("signatures", (Object)sigtext.toString());
            return definition;
        }
    }

    protected class CreatorBeanDefinitionDecorator
    implements BeanDefinitionDecorator {
        protected CreatorBeanDefinitionDecorator() {
        }

        public BeanDefinitionHolder decorate(Node node, BeanDefinitionHolder definition, ParserContext parserContext) {
            BeanDefinitionBuilder creator;
            String parentBeanName = definition.getBeanName();
            Element element = (Element)node;
            String javascript = element.getAttribute("javascript");
            String type = element.getAttribute("type");
            if ("spring".equals(type)) {
                creator = BeanDefinitionBuilder.rootBeanDefinition((Class)(class$org$directwebremoting$spring$SpringCreator == null ? (class$org$directwebremoting$spring$SpringCreator = DwrNamespaceHandler.class$("org.directwebremoting.spring.SpringCreator")) : class$org$directwebremoting$spring$SpringCreator));
                creator.addPropertyValue("bean", (Object)new RuntimeBeanReference(parentBeanName));
                creator.addPropertyValue("javascript", (Object)javascript);
            } else if ("new".equals(type)) {
                creator = BeanDefinitionBuilder.rootBeanDefinition((Class)(class$org$directwebremoting$create$NewCreator == null ? (class$org$directwebremoting$create$NewCreator = DwrNamespaceHandler.class$("org.directwebremoting.create.NewCreator")) : class$org$directwebremoting$create$NewCreator));
                creator.addPropertyValue("className", (Object)node.getAttributes().getNamedItem("class").getNodeValue());
                creator.addPropertyValue("javascript", (Object)javascript);
            } else {
                throw new UnsupportedOperationException("Type " + type + " is not yet supported");
            }
            DwrNamespaceHandler.this.registerCreator(parserContext.getRegistry(), javascript, creator, node.getChildNodes());
            return definition;
        }
    }

    protected class ConverterBeanDefinitionDecorator
    implements BeanDefinitionDecorator {
        protected ConverterBeanDefinitionDecorator() {
        }

        public BeanDefinitionHolder decorate(Node node, BeanDefinitionHolder definition, ParserContext parserContext) {
            Element element = (Element)node;
            String type = element.getAttribute("type");
            String className = element.getAttribute("class");
            BeanDefinitionRegistry registry = parserContext.getRegistry();
            ConverterConfig converterConfig = new ConverterConfig();
            converterConfig.setType(type);
            DwrNamespaceHandler.this.parseConverterSettings(converterConfig, element);
            DwrNamespaceHandler.this.lookupConverters(registry).put(className, converterConfig);
            return definition;
        }
    }

    protected class RemoteBeanDefinitionDecorator
    implements BeanDefinitionDecorator {
        protected RemoteBeanDefinitionDecorator() {
        }

        public BeanDefinitionHolder decorate(Node node, BeanDefinitionHolder definition, ParserContext parserContext) {
            Element element = (Element)node;
            String parentBeanName = definition.getBeanName();
            String javascript = element.getAttribute("javascript");
            BeanDefinitionBuilder beanCreator = BeanDefinitionBuilder.rootBeanDefinition((Class)(class$org$directwebremoting$spring$BeanCreator == null ? (class$org$directwebremoting$spring$BeanCreator = DwrNamespaceHandler.class$("org.directwebremoting.spring.BeanCreator")) : class$org$directwebremoting$spring$BeanCreator));
            beanCreator.addPropertyValue("bean", (Object)new RuntimeBeanReference(parentBeanName));
            beanCreator.addPropertyValue("javascript", (Object)javascript);
            DwrNamespaceHandler.this.registerCreator(parserContext.getRegistry(), javascript, beanCreator, node.getChildNodes());
            return definition;
        }
    }

    protected class ControllerBeanDefinitionParser
    implements BeanDefinitionParser {
        protected ControllerBeanDefinitionParser() {
        }

        public BeanDefinition parse(Element element, ParserContext parserContext) {
            BeanDefinitionBuilder dwrController = BeanDefinitionBuilder.rootBeanDefinition((Class)(class$org$directwebremoting$spring$DwrController == null ? (class$org$directwebremoting$spring$DwrController = DwrNamespaceHandler.class$("org.directwebremoting.spring.DwrController")) : class$org$directwebremoting$spring$DwrController));
            ManagedList configurators = new ManagedList();
            configurators.add(new RuntimeBeanReference(DwrNamespaceHandler.DEFAULT_SPRING_CONFIGURATOR_ID));
            dwrController.addPropertyValue("configurators", (Object)configurators);
            String debug = element.getAttribute("debug");
            if (StringUtils.hasText((String)debug)) {
                dwrController.addPropertyValue("debug", (Object)debug);
            }
            String beanName = element.getAttribute("id");
            String[] aliases = null;
            if (!StringUtils.hasText((String)beanName)) {
                beanName = element.getAttribute("name");
            } else {
                String aliasName = element.getAttribute("name");
                if (StringUtils.hasText((String)aliasName)) {
                    aliases = new String[]{aliasName};
                }
            }
            BeanDefinitionHolder holder = new BeanDefinitionHolder((BeanDefinition)dwrController.getBeanDefinition(), beanName, aliases);
            BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)holder, (BeanDefinitionRegistry)parserContext.getRegistry());
            return dwrController.getBeanDefinition();
        }
    }

    protected class ConfigurationBeanDefinitionParser
    implements BeanDefinitionParser {
        protected ConfigurationBeanDefinitionParser() {
        }

        public BeanDefinition parse(Element element, ParserContext parserContext) {
            BeanDefinitionRegistry registry = parserContext.getRegistry();
            BeanDefinition beanDefinition = DwrNamespaceHandler.this.registerSpringConfiguratorIfNecessary(registry);
            List createElements = DomUtils.getChildElementsByTagName((Element)element, (String)"create");
            Iterator iter = createElements.iterator();
            while (iter.hasNext()) {
                Element createElement = (Element)iter.next();
                DwrNamespaceHandler.this.findDecoratorForNode(createElement).decorate((Node)createElement, new BeanDefinitionHolder(beanDefinition, DwrNamespaceHandler.DEFAULT_SPRING_CONFIGURATOR_ID), parserContext);
            }
            List convertElements = DomUtils.getChildElementsByTagName((Element)element, (String)"convert");
            iter = convertElements.iterator();
            while (iter.hasNext()) {
                Element convertElement = (Element)iter.next();
                DwrNamespaceHandler.this.findDecoratorForNode(convertElement).decorate((Node)convertElement, new BeanDefinitionHolder(beanDefinition, DwrNamespaceHandler.DEFAULT_SPRING_CONFIGURATOR_ID), parserContext);
            }
            List signatureElements = DomUtils.getChildElementsByTagName((Element)element, (String)"signatures");
            Iterator i = signatureElements.iterator();
            while (i.hasNext()) {
                Element signatureElement = (Element)i.next();
                DwrNamespaceHandler.this.findDecoratorForNode(signatureElement).decorate((Node)signatureElement, new BeanDefinitionHolder(beanDefinition, DwrNamespaceHandler.DEFAULT_SPRING_CONFIGURATOR_ID), parserContext);
            }
            return beanDefinition;
        }
    }
}

