/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.servlet;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.directwebremoting.extend.Handler;
import org.directwebremoting.servlet.UrlProcessor;
import org.directwebremoting.util.IdGenerator;
import org.directwebremoting.util.JavascriptUtil;
import org.directwebremoting.util.LocalUtil;

public class FileHandler
implements Handler {
    private boolean allowGetForSafariButMakeForgeryEasier = false;
    protected boolean ignoreLastModified = false;
    protected String sessionCookieName = "JSESSIONID";
    protected int compressionLevel = 7;
    protected boolean scriptCompressed = false;
    protected IdGenerator generator = new IdGenerator();
    protected int pageIdLength = 16;
    protected final Map scriptCache = new HashMap();
    private String filePath;
    private String mimeType;
    private boolean dynamic;
    private static final long servletContainerStartTime;
    private static final String etag;
    protected static final String PARAM_SCRIPT_ALLOWGET = "${allowGetForSafariButMakeForgeryEasier}";
    protected static final String PARAM_SCRIPT_SESSIONID = "${scriptSessionId}";
    protected static final String PARAM_SCRIPT_COOKIENAME = "${sessionCookieName}";

    public FileHandler(String filePath, String mimeType, boolean dynamic) {
        this.filePath = filePath;
        this.mimeType = mimeType;
        this.dynamic = dynamic;
    }

    public FileHandler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String output;
        if (this.dynamic) {
            response.setHeader("pragma", "public");
            response.setHeader("Expires", "0");
            response.setHeader("Cache-Control", "must-revalidate, post-check=0, pre-check=0");
        }
        if (!this.dynamic && this.isUpToDate(request)) {
            response.setStatus(304);
            return;
        }
        Map map = this.scriptCache;
        synchronized (map) {
            output = (String)this.scriptCache.get(this.filePath);
            if (output == null) {
                String line;
                StringBuffer buffer = new StringBuffer();
                String resource = "/org/directwebremoting" + this.filePath;
                InputStream raw = this.getClass().getResourceAsStream(resource);
                if (raw == null) {
                    throw new IOException("Failed to find resource: " + resource);
                }
                BufferedReader in = new BufferedReader(new InputStreamReader(raw));
                while ((line = in.readLine()) != null) {
                    if (this.dynamic) {
                        if (line.indexOf(PARAM_SCRIPT_COOKIENAME) != -1) {
                            line = LocalUtil.replace(line, PARAM_SCRIPT_COOKIENAME, this.sessionCookieName);
                        }
                        if (line.indexOf(PARAM_SCRIPT_SESSIONID) != -1) {
                            line = LocalUtil.replace(line, PARAM_SCRIPT_SESSIONID, this.generator.generateId(this.pageIdLength));
                        }
                        if (line.indexOf(PARAM_SCRIPT_ALLOWGET) != -1) {
                            line = LocalUtil.replace(line, PARAM_SCRIPT_ALLOWGET, String.valueOf(this.allowGetForSafariButMakeForgeryEasier));
                        }
                    }
                    buffer.append(line);
                    buffer.append('\n');
                }
                output = buffer.toString();
                if (this.mimeType.equals("text/javascript") && this.scriptCompressed) {
                    output = JavascriptUtil.compress(output, this.compressionLevel);
                }
                if (!this.dynamic) {
                    this.scriptCache.put(this.filePath, output);
                }
            }
        }
        response.setContentType(this.mimeType);
        response.setDateHeader("Last-Modified", servletContainerStartTime);
        response.setHeader("ETag", etag);
        PrintWriter out = response.getWriter();
        out.println(output);
    }

    private boolean isUpToDate(HttpServletRequest req) {
        String givenEtag;
        if (this.ignoreLastModified) {
            return false;
        }
        long modifiedSince = -1L;
        try {
            modifiedSince = req.getDateHeader("If-Modified-Since");
        }
        catch (RuntimeException ex) {
            UrlProcessor.log.warn("Websphere/RAD date failure. If you understand why this might happen please report to dwr-users mailing list");
        }
        if (modifiedSince != -1L) {
            modifiedSince -= modifiedSince % 1000L;
        }
        if ((givenEtag = req.getHeader("If-None-Match")) == null) {
            if (modifiedSince > servletContainerStartTime) {
                if (UrlProcessor.log.isDebugEnabled()) {
                    UrlProcessor.log.debug("Sending 304 for " + this.filePath + " If-Modified-Since=" + modifiedSince + ", Last-Modified=" + servletContainerStartTime);
                }
                return true;
            }
            return false;
        }
        if (modifiedSince == -1L) {
            if (!etag.equals(givenEtag)) {
                if (UrlProcessor.log.isDebugEnabled()) {
                    UrlProcessor.log.debug("Sending 304 for " + this.filePath + " Old ETag=" + givenEtag + ", New ETag=" + etag);
                }
                return true;
            }
            return false;
        }
        if (etag.equals(givenEtag) && modifiedSince <= servletContainerStartTime) {
            if (UrlProcessor.log.isDebugEnabled()) {
                UrlProcessor.log.debug("Sending 304 for " + this.filePath);
            }
            return true;
        }
        return false;
    }

    public void setAllowGetForSafariButMakeForgeryEasier(boolean allowGetForSafariButMakeForgeryEasier) {
        this.allowGetForSafariButMakeForgeryEasier = allowGetForSafariButMakeForgeryEasier;
    }

    public void setIgnoreLastModified(boolean ignoreLastModified) {
        this.ignoreLastModified = ignoreLastModified;
    }

    public void setSessionCookieName(String sessionCookieName) {
        this.sessionCookieName = sessionCookieName;
    }

    public void setScriptCompressed(boolean scriptCompressed) {
        this.scriptCompressed = scriptCompressed;
    }

    public void setCompressionLevel(int compressionLevel) {
        this.compressionLevel = compressionLevel;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public void setDynamic(boolean dynamic) {
        this.dynamic = dynamic;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    static {
        long now = System.currentTimeMillis();
        servletContainerStartTime = now - now % 1000L;
        etag = "\"" + servletContainerStartTime + '\"';
    }
}

