/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.impl;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.directwebremoting.extend.ConverterManager;
import org.directwebremoting.extend.Creator;
import org.directwebremoting.extend.CreatorManager;
import org.directwebremoting.extend.TypeHintContext;
import org.directwebremoting.util.JavascriptUtil;
import org.directwebremoting.util.LocalUtil;
import org.directwebremoting.util.Logger;

public class SignatureParser {
    private Map classImports = new HashMap();
    private List packageImports = new ArrayList();
    private ConverterManager converterManager;
    private CreatorManager creatorManager;
    public static final Logger log = Logger.getLogger(class$org$directwebremoting$impl$SignatureParser == null ? (class$org$directwebremoting$impl$SignatureParser = SignatureParser.class$("org.directwebremoting.impl.SignatureParser")) : class$org$directwebremoting$impl$SignatureParser);
    static /* synthetic */ Class class$org$directwebremoting$impl$SignatureParser;

    public SignatureParser(ConverterManager converterManager, CreatorManager creatorManager) {
        this.converterManager = converterManager;
        this.creatorManager = creatorManager;
        this.packageImports.add("java.lang");
    }

    public void parse(String sigtext) {
        try {
            log.debug("Parsing extra type info: ");
            String reply = JavascriptUtil.stripMultiLineComments(sigtext);
            String process = reply = JavascriptUtil.stripSingleLineComments(reply);
            process = process.replace('\n', ' ');
            process = process.replace('\r', ' ');
            process = process.replace('\t', ' ');
            StringTokenizer st = new StringTokenizer(process, ";");
            while (st.hasMoreTokens()) {
                String line = st.nextToken();
                if ((line = line.trim()).length() == 0) continue;
                if (line.startsWith("import ")) {
                    this.parseImportLine(line);
                    continue;
                }
                this.parseDeclarationLine(line);
            }
        }
        catch (Exception ex) {
            log.error("Unexpected Error", ex);
        }
    }

    private void parseImportLine(String line) {
        String shortcut = line.substring(7, line.length());
        shortcut = shortcut.trim();
        if (line.endsWith(".*")) {
            shortcut = shortcut.substring(0, shortcut.length() - 2);
            this.packageImports.add(shortcut);
        } else {
            int lastDot = line.lastIndexOf(46);
            if (lastDot == -1) {
                log.error("Missing . from import statement: " + line);
                return;
            }
            String leaf = line.substring(lastDot + 1);
            this.classImports.put(leaf, shortcut);
        }
    }

    private void parseDeclarationLine(String line) {
        int openBrace = line.indexOf(40);
        int closeBrace = line.indexOf(41);
        if (openBrace == -1) {
            log.error("Missing ( in declaration: " + line);
            return;
        }
        if (closeBrace == -1) {
            log.error("Missing ) in declaration: " + line);
            return;
        }
        if (openBrace > closeBrace) {
            log.error("( Must come before ) in declaration: " + line);
            return;
        }
        String classMethod = line.substring(0, openBrace).trim();
        Method method = this.findMethod(classMethod);
        if (method == null) {
            return;
        }
        String paramDecl = line.substring(openBrace + 1, closeBrace);
        String[] paramNames = this.split(paramDecl);
        if (method.getParameterTypes().length != paramNames.length) {
            log.error("Parameter mismatch parsing signatures section in dwr.xml on line: " + line);
            log.info("- Reflected method had: " + method.getParameterTypes().length + " parameters: " + method.toString());
            log.info("- Signatures section had: " + paramNames.length + " parameters");
            log.info("- This can be caused by method overloading which is not supported by Javascript or DWR");
            return;
        }
        for (int i = 0; i < paramNames.length; ++i) {
            String[] genericList = this.getGenericParameterTypeList(paramNames[i]);
            for (int j = 0; j < genericList.length; ++j) {
                String type = genericList[j].trim();
                Class clazz = this.findClass(type);
                if (clazz != null) {
                    TypeHintContext thc = new TypeHintContext(this.converterManager, method, i).createChildContext(j);
                    this.converterManager.setExtraTypeInfo(thc, clazz);
                    if (!log.isDebugEnabled()) continue;
                    log.debug("- " + thc + " = " + clazz.getName());
                    continue;
                }
                log.warn("Missing class (" + type + ") while parsing signature section on line: " + line);
            }
        }
    }

    private Class findClass(String type) {
        String itype = type;
        if (itype.indexOf(46) != -1) {
            log.debug("Inner class detected: " + itype);
            itype = itype.replace('.', '$');
        }
        try {
            String full = (String)this.classImports.get(itype);
            if (full == null) {
                full = itype;
            }
            return LocalUtil.classForName(full);
        }
        catch (Exception ex) {
            Iterator it = this.packageImports.iterator();
            while (it.hasNext()) {
                String pkg = (String)it.next();
                String lookup = pkg + '.' + itype;
                try {
                    return LocalUtil.classForName(lookup);
                }
                catch (Exception ex2) {
                }
            }
            Creator creator = this.creatorManager.getCreator(type);
            if (creator != null) {
                return creator.getType();
            }
            log.error("Failed to find class: '" + itype + "' from <signature> block.");
            log.info("- Looked in the following class imports:");
            Iterator it2 = this.classImports.entrySet().iterator();
            while (it2.hasNext()) {
                Map.Entry entry = it2.next();
                log.info("  - " + entry.getKey() + " -> " + entry.getValue());
            }
            log.info("- Looked in the following package imports:");
            it2 = this.packageImports.iterator();
            while (it2.hasNext()) {
                log.info("  - " + it2.next());
            }
            return null;
        }
    }

    private String[] getGenericParameterTypeList(String paramName) {
        int openGeneric = paramName.indexOf(60);
        if (openGeneric == -1) {
            log.debug("No < in paramter declaration: " + paramName);
            return new String[0];
        }
        int closeGeneric = paramName.lastIndexOf(62);
        if (closeGeneric == -1) {
            log.error("Missing > in generic declaration: " + paramName);
            return new String[0];
        }
        String generics = paramName.substring(openGeneric + 1, closeGeneric);
        StringTokenizer st = new StringTokenizer(generics, ",");
        String[] types = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            types[i++] = st.nextToken();
        }
        return types;
    }

    private Method findMethod(String classMethod) {
        int lastDot;
        String classMethodChop = classMethod;
        int lastSpace = classMethodChop.lastIndexOf(32);
        if (lastSpace >= 0) {
            classMethodChop = classMethodChop.substring(lastSpace);
        }
        if ((lastDot = classMethodChop.lastIndexOf(46)) == -1) {
            log.error("Missing . to separate class name and method: " + classMethodChop);
            return null;
        }
        String className = classMethodChop.substring(0, lastDot).trim();
        String methodName = classMethodChop.substring(lastDot + 1).trim();
        Class clazz = this.findClass(className);
        if (clazz == null) {
            return null;
        }
        Method method = null;
        Method[] methods = clazz.getMethods();
        for (int j = 0; j < methods.length; ++j) {
            Method test = methods[j];
            if (!test.getName().equals(methodName)) continue;
            if (method == null) {
                method = test;
                continue;
            }
            log.warn("Setting extra type info to overloaded methods may fail with <parameter .../>");
        }
        if (method == null) {
            log.error("Unable to find method called: " + methodName + " on type: " + clazz.getName());
        }
        return method;
    }

    private String[] split(String paramDecl) {
        ArrayList<String> params = new ArrayList<String>();
        boolean inGeneric = false;
        int start = 0;
        for (int i = 0; i < paramDecl.length(); ++i) {
            char c = paramDecl.charAt(i);
            if (c == '<') {
                if (inGeneric) {
                    log.error("Found < while parsing generic section: " + paramDecl);
                    break;
                }
                inGeneric = true;
            }
            if (c == '>') {
                if (!inGeneric) {
                    log.error("Found > while not parsing generic section: " + paramDecl);
                    break;
                }
                inGeneric = false;
            }
            if (inGeneric || c != ',') continue;
            String param = paramDecl.substring(start, i);
            params.add(param);
            start = i + 1;
        }
        String param = paramDecl.substring(start, paramDecl.length());
        params.add(param);
        return params.toArray(new String[params.size()]);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

