/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.directwebremoting.ScriptBuffer;
import org.directwebremoting.extend.MarshallException;
import org.directwebremoting.extend.RealScriptSession;
import org.directwebremoting.extend.ScriptConduit;
import org.directwebremoting.impl.DefaultScriptSessionManager;
import org.directwebremoting.util.Logger;

public class DefaultScriptSession
implements RealScriptSession {
    protected final SortedSet conduits = new TreeSet();
    protected final List scripts = new ArrayList();
    protected String id = null;
    protected long creationTime = 0L;
    protected long lastAccessedTime = 0L;
    protected boolean invalidated = false;
    protected Map attributes = Collections.synchronizedMap(new HashMap());
    protected DefaultScriptSessionManager manager;
    private final Object scriptLock = new Object();
    private static final Logger log = Logger.getLogger(class$org$directwebremoting$impl$DefaultScriptSession == null ? (class$org$directwebremoting$impl$DefaultScriptSession = DefaultScriptSession.class$("org.directwebremoting.impl.DefaultScriptSession")) : class$org$directwebremoting$impl$DefaultScriptSession);
    static /* synthetic */ Class class$org$directwebremoting$impl$DefaultScriptSession;

    protected DefaultScriptSession(String id, DefaultScriptSessionManager manager) {
        this.id = id;
        if (id == null) {
            throw new IllegalArgumentException("id can not be null");
        }
        this.manager = manager;
        this.lastAccessedTime = this.creationTime = System.currentTimeMillis();
    }

    public Object getAttribute(String name) {
        this.checkNotInvalidated();
        return this.attributes.get(name);
    }

    public void setAttribute(String name, Object value) {
        this.checkNotInvalidated();
        this.attributes.put(name, value);
    }

    public void removeAttribute(String name) {
        this.checkNotInvalidated();
        this.attributes.remove(name);
    }

    public Iterator getAttributeNames() {
        this.checkNotInvalidated();
        return this.attributes.keySet().iterator();
    }

    public void invalidate() {
        this.invalidated = true;
        this.manager.invalidate(this);
    }

    public boolean isInvalidated() {
        return this.invalidated;
    }

    public String getId() {
        return this.id;
    }

    public long getCreationTime() {
        this.checkNotInvalidated();
        return this.creationTime;
    }

    public long getLastAccessedTime() {
        return this.lastAccessedTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addScript(ScriptBuffer script) {
        this.checkNotInvalidated();
        if (script == null) {
            throw new NullPointerException("null script");
        }
        Object object = this.scriptLock;
        synchronized (object) {
            if (this.conduits.size() == 0) {
                this.scripts.add(script);
            } else {
                boolean written = false;
                Iterator it = this.conduits.iterator();
                while (!written && it.hasNext()) {
                    ScriptConduit conduit = (ScriptConduit)it.next();
                    try {
                        written = conduit.addScript(script);
                        if (!written) continue;
                        conduit.flush();
                    }
                    catch (Exception ex) {
                        log.warn("Failed to write to ScriptConduit, removing from list: " + conduit);
                        it.remove();
                    }
                }
                if (!written) {
                    this.scripts.add(script);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addScriptConduit(ScriptConduit conduit) throws IOException {
        this.checkNotInvalidated();
        Object object = this.scriptLock;
        synchronized (object) {
            this.conduits.add(conduit);
            boolean output = false;
            Iterator it = this.scripts.iterator();
            while (it.hasNext()) {
                ScriptBuffer script = (ScriptBuffer)it.next();
                try {
                    if (!conduit.addScript(script)) break;
                    output = true;
                    it.remove();
                }
                catch (MarshallException ex) {
                    log.warn("Failed to convert data. Dropping Javascript: " + script, ex);
                }
            }
            if (output) {
                conduit.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeScriptConduit(ScriptConduit conduit) {
        this.checkNotInvalidated();
        Object object = this.scriptLock;
        synchronized (object) {
            boolean removed = this.conduits.remove(conduit);
            if (!removed) {
                log.warn("Removing unattached ScriptConduit: " + conduit);
                this.debug();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushConduits() {
        this.checkNotInvalidated();
        Object object = this.scriptLock;
        synchronized (object) {
            if (this.conduits.size() > 0) {
                Iterator it = this.conduits.iterator();
                while (it.hasNext()) {
                    ScriptConduit conduit = (ScriptConduit)it.next();
                    try {
                        conduit.flush();
                    }
                    catch (Exception ex) {
                        log.warn("Failed to flush to ScriptConduit, removing from list: " + conduit);
                        it.remove();
                    }
                }
            }
        }
    }

    public Object getScriptLock() {
        return this.scriptLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasWaitingScripts() {
        Object object = this.scriptLock;
        synchronized (object) {
            return !this.scripts.isEmpty();
        }
    }

    protected void updateLastAccessedTime() {
        this.lastAccessedTime = System.currentTimeMillis();
    }

    protected void checkNotInvalidated() {
        long now = System.currentTimeMillis();
        long age = now - this.lastAccessedTime;
        if (age > this.manager.getScriptSessionTimeout()) {
            this.invalidate();
        }
        if (this.invalidated) {
            log.warn("ScriptSession has been invalidated.");
        }
    }

    private void debug() {
        if (log.isDebugEnabled()) {
            log.debug("Known ScriptConduits:");
            Iterator it = this.conduits.iterator();
            while (it.hasNext()) {
                ScriptConduit c = (ScriptConduit)it.next();
                log.debug("- " + c);
            }
        }
    }

    public int hashCode() {
        return 572 + this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        DefaultScriptSession that = (DefaultScriptSession)obj;
        return this.id.equals(that.id);
    }

    public String toString() {
        return "DefaultScriptSession[id=" + this.id + "]";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

