/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.dwrp;

import java.util.Collection;
import java.util.Iterator;
import org.directwebremoting.dwrp.ReferenceOutboundVariable;
import org.directwebremoting.extend.OutboundContext;
import org.directwebremoting.extend.OutboundVariable;

public abstract class AbstractOutboundVariable
implements OutboundVariable {
    private OutboundVariable reference;
    private boolean inline = true;
    private boolean forcedInlineStatus = false;
    private boolean calculated = false;
    private NotInlineDefinition notInlineDefinition;
    private String assignCode;
    private String varName;
    private OutboundContext outboundContext;
    private Collection children;

    protected AbstractOutboundVariable(OutboundContext outboundContext) {
        this.outboundContext = outboundContext;
    }

    protected void forceInline(boolean inlineStatus) {
        this.setInline(inlineStatus);
        this.forcedInlineStatus = true;
    }

    protected void setChildren(Collection children) {
        this.children = children;
    }

    public String getDeclareCode() {
        if (!this.calculated) {
            this.calculate();
        }
        if (this.inline) {
            return this.getChildDeclareCodes();
        }
        return this.notInlineDefinition.declareCode + this.getChildDeclareCodes();
    }

    public String getBuildCode() {
        if (!this.calculated) {
            this.calculate();
        }
        if (this.inline) {
            return this.getChildBuildCodes();
        }
        return this.notInlineDefinition.buildCode + this.getChildBuildCodes();
    }

    public String getAssignCode() {
        if (this.calculated) {
            if (this.inline) {
                return this.assignCode;
            }
            return this.varName;
        }
        if (this.forcedInlineStatus) {
            if (this.inline) {
                return this.getInlineDefinition();
            }
            return this.getVariableName();
        }
        this.setInline(false);
        return this.getVariableName();
    }

    public OutboundVariable getReferenceVariable() {
        if (this.reference == null) {
            this.reference = new ReferenceOutboundVariable(this.getVariableName());
            if (this.forcedInlineStatus) {
                throw new IllegalStateException("Ignoring request to inline on reference for: " + this);
            }
            this.setInline(false);
        }
        return this.reference;
    }

    private void calculate() {
        if (this.inline) {
            this.assignCode = this.getInlineDefinition();
        } else {
            this.notInlineDefinition = this.getNotInlineDefinition();
        }
        this.calculated = true;
    }

    private String getChildBuildCodes() {
        if (this.children == null) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        Iterator it = this.children.iterator();
        while (it.hasNext()) {
            OutboundVariable nested = (OutboundVariable)it.next();
            buffer.append(nested.getBuildCode());
        }
        return buffer.toString();
    }

    private String getChildDeclareCodes() {
        if (this.children == null) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        Iterator it = this.children.iterator();
        while (it.hasNext()) {
            OutboundVariable nested = (OutboundVariable)it.next();
            buffer.append(nested.getDeclareCode());
        }
        return buffer.toString();
    }

    protected String getVariableName() {
        if (this.varName == null) {
            this.varName = this.outboundContext.getNextVariableName();
        }
        return this.varName;
    }

    protected abstract NotInlineDefinition getNotInlineDefinition();

    protected abstract String getInlineDefinition();

    protected String toStringDefinitionHint() {
        if (this.inline) {
            return "inline";
        }
        if (this.varName != null) {
            return this.varName;
        }
        return "?";
    }

    private void setInline(boolean isInline) {
        if (this.calculated) {
            throw new IllegalStateException("Attempt to change inline status after calculation");
        }
        this.inline = isInline;
    }

    protected class NotInlineDefinition {
        String declareCode;
        String buildCode;

        protected NotInlineDefinition(String declareCode, String buildCode) {
            this.declareCode = declareCode;
            this.buildCode = buildCode;
        }
    }
}

