/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.distribution;

import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.rmi.UnmarshalException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.Status;
import net.sf.ehcache.distribution.CachePeer;
import net.sf.ehcache.distribution.EventMessage;
import net.sf.ehcache.distribution.RMISynchronousCacheReplicator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class RMIAsynchronousCacheReplicator
extends RMISynchronousCacheReplicator {
    protected static final int REPLICATION_THREAD_INTERVAL = 1000;
    private static final Log LOG = LogFactory.getLog((String)(class$net$sf$ehcache$distribution$RMIAsynchronousCacheReplicator == null ? (class$net$sf$ehcache$distribution$RMIAsynchronousCacheReplicator = RMIAsynchronousCacheReplicator.class$("net.sf.ehcache.distribution.RMIAsynchronousCacheReplicator")) : class$net$sf$ehcache$distribution$RMIAsynchronousCacheReplicator).getName());
    protected Thread replicationThread = new ReplicationThread();
    protected final List replicationQueue = new LinkedList();
    static /* synthetic */ Class class$net$sf$ehcache$distribution$RMIAsynchronousCacheReplicator;

    protected RMIAsynchronousCacheReplicator(boolean replicatePuts, boolean replicateUpdates, boolean replicateUpdatesViaCopy, boolean replicateRemovals) {
        super(replicatePuts, replicateUpdates, replicateUpdatesViaCopy, replicateRemovals);
        this.status = Status.STATUS_ALIVE;
        this.replicationThread.start();
    }

    private void replicationThreadMain() {
        while (true) {
            if (this.alive() && this.replicationQueue != null && this.replicationQueue.size() == 0) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    LOG.debug((Object)"Spool Thread interrupted.");
                    return;
                }
            }
            if (this.notAlive()) {
                return;
            }
            if (this.replicationQueue.size() == 0) continue;
            this.flushReplicationQueue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void notifyElementPut(Ehcache cache, Element element) throws CacheException {
        if (this.notAlive()) {
            return;
        }
        if (!this.replicatePuts) {
            return;
        }
        if (!element.isSerializable()) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)("Object with key " + element.getObjectKey() + " is not Serializable and cannot be replicated"));
            }
            return;
        }
        List list = this.replicationQueue;
        synchronized (list) {
            this.replicationQueue.add(new CacheEventMessage(0, cache, element, null));
        }
    }

    public final void notifyElementUpdated(Ehcache cache, Element element) throws CacheException {
        if (this.notAlive()) {
            return;
        }
        if (!this.replicateUpdates) {
            return;
        }
        if (this.replicateUpdatesViaCopy) {
            if (!element.isSerializable()) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn((Object)("Object with key " + element.getObjectKey() + " is not Serializable and cannot be updated via copy"));
                }
                return;
            }
            this.replicationQueue.add(new CacheEventMessage(0, cache, element, null));
        } else {
            if (!element.isKeySerializable()) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn((Object)("Key " + element.getObjectKey() + " is not Serializable and cannot be replicated."));
                }
                return;
            }
            this.replicationQueue.add(new CacheEventMessage(1, cache, null, element.getKey()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void notifyElementRemoved(Ehcache cache, Element element) throws CacheException {
        if (!this.replicateRemovals) {
            return;
        }
        if (!element.isKeySerializable()) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)("Key " + element.getObjectKey() + " is not Serializable and cannot be replicated."));
            }
            return;
        }
        List list = this.replicationQueue;
        synchronized (list) {
            this.replicationQueue.add(new CacheEventMessage(1, cache, null, element.getKey()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushReplicationQueue() {
        int eventMessagesNotResolved;
        Object[] replicationQueueCopy;
        List list = this.replicationQueue;
        synchronized (list) {
            if (this.replicationQueue.size() == 0) {
                return;
            }
            replicationQueueCopy = this.replicationQueue.toArray();
            this.replicationQueue.clear();
        }
        Ehcache cache = ((CacheEventMessage)replicationQueueCopy[0]).cache;
        List cachePeers = RMIAsynchronousCacheReplicator.listRemoteCachePeers(cache);
        List resolvedEventMessages = RMIAsynchronousCacheReplicator.extractAndResolveEventMessages(replicationQueueCopy);
        for (int j = 0; j < cachePeers.size(); ++j) {
            CachePeer cachePeer = (CachePeer)cachePeers.get(j);
            try {
                cachePeer.send(resolvedEventMessages);
                continue;
            }
            catch (UnmarshalException e) {
                String message = e.getMessage();
                if (message.indexOf("Read time out") != 0) {
                    LOG.warn((Object)("Unable to send message to remote peer due to socket read timeout. Consider increasing the socketTimeoutMillis setting in the cacheManagerPeerListenerFactory. Message was: " + e.getMessage()));
                    continue;
                }
                LOG.debug((Object)("Unable to send message to remote peer.  Message was: " + e.getMessage()));
                continue;
            }
            catch (Throwable t) {
                LOG.debug((Object)("Unable to send message to remote peer.  Message was: " + t.getMessage()));
            }
        }
        if (LOG.isWarnEnabled() && (eventMessagesNotResolved = replicationQueueCopy.length - resolvedEventMessages.size()) > 0) {
            LOG.warn((Object)(eventMessagesNotResolved + " messages were discarded on replicate due to reclamation of " + "SoftReferences by the VM. Consider increasing the maximum heap size and/or setting the " + "starting heap size to a higher value."));
        }
    }

    private static List extractAndResolveEventMessages(Object[] replicationQueueCopy) {
        ArrayList<EventMessage> list = new ArrayList<EventMessage>();
        for (int i = 0; i < replicationQueueCopy.length; ++i) {
            EventMessage eventMessage = ((CacheEventMessage)replicationQueueCopy[i]).getEventMessage();
            if (eventMessage != null) {
                list.add(eventMessage);
            }
            replicationQueueCopy[i] = null;
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void dispose() {
        this.status = Status.STATUS_SHUTDOWN;
        List list = this.replicationQueue;
        synchronized (list) {
            this.replicationQueue.clear();
        }
    }

    public Object clone() throws CloneNotSupportedException {
        super.clone();
        return new RMIAsynchronousCacheReplicator(this.replicatePuts, this.replicateUpdates, this.replicateUpdatesViaCopy, this.replicateRemovals);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class CacheEventMessage {
        private final Ehcache cache;
        private final SoftReference softEventMessage;

        public CacheEventMessage(int event, Ehcache cache, Element element, Serializable key) {
            EventMessage eventMessage = new EventMessage(event, key, element);
            this.softEventMessage = new SoftReference<EventMessage>(eventMessage);
            this.cache = cache;
        }

        public final EventMessage getEventMessage() {
            return (EventMessage)this.softEventMessage.get();
        }
    }

    private final class ReplicationThread
    extends Thread {
        public ReplicationThread() {
            super("Replication Thread");
            this.setDaemon(true);
            this.setPriority(2);
        }

        public final void run() {
            RMIAsynchronousCacheReplicator.this.replicationThreadMain();
        }
    }
}

