/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.constructs.web.filter;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.zip.DataFormatException;
import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.constructs.blocking.BlockingCache;
import net.sf.ehcache.constructs.web.AlreadyCommittedException;
import net.sf.ehcache.constructs.web.AlreadyGzippedException;
import net.sf.ehcache.constructs.web.GenericResponseWrapper;
import net.sf.ehcache.constructs.web.PageInfo;
import net.sf.ehcache.constructs.web.ResponseHeadersNotModifiableException;
import net.sf.ehcache.constructs.web.ResponseUtil;
import net.sf.ehcache.constructs.web.SerializableCookie;
import net.sf.ehcache.constructs.web.filter.Filter;
import net.sf.ehcache.constructs.web.filter.FilterCacheManager;
import net.sf.ehcache.constructs.web.filter.FilterNonReentrantException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class CachingFilter
extends Filter {
    private static final Log LOG = LogFactory.getLog((String)(class$net$sf$ehcache$constructs$web$filter$CachingFilter == null ? (class$net$sf$ehcache$constructs$web$filter$CachingFilter = CachingFilter.class$("net.sf.ehcache.constructs.web.filter.CachingFilter")) : class$net$sf$ehcache$constructs$web$filter$CachingFilter).getName());
    private BlockingCache blockingCache;
    static /* synthetic */ Class class$net$sf$ehcache$constructs$web$filter$CachingFilter;

    public void doInit() throws CacheException {
        String cacheName = this.getCacheName();
        this.blockingCache = FilterCacheManager.getInstance().getCache(cacheName);
    }

    protected void doDestroy() {
    }

    protected void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws AlreadyGzippedException, AlreadyCommittedException, FilterNonReentrantException, Exception {
        if (response.isCommitted()) {
            throw new AlreadyCommittedException("Response already committed before doing buildPage.");
        }
        this.logRequestHeaders(request);
        PageInfo pageInfo = this.buildPageInfo(request, response, chain);
        if (response.isCommitted()) {
            throw new AlreadyCommittedException("Response already committed after doing buildPagebut before writing response from PageInfo.");
        }
        this.writeResponse(request, response, pageInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PageInfo buildPageInfo(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws Exception {
        PageInfo pageInfo;
        block9: {
            String key = this.calculateKey(request);
            pageInfo = null;
            try {
                this.checkNoReentry(request);
                pageInfo = (PageInfo)this.blockingCache.get((Serializable)((Object)key));
                if (pageInfo != null) break block9;
                try {
                    pageInfo = this.buildPage(request, response, chain);
                    if (pageInfo.isOk()) {
                        if (LOG.isTraceEnabled()) {
                            LOG.trace((Object)("PageInfo ok. Adding to cache " + this.blockingCache.getName() + " with key " + key));
                        }
                        this.blockingCache.put((Serializable)((Object)key), pageInfo);
                    } else {
                        if (LOG.isWarnEnabled()) {
                            LOG.warn((Object)("PageInfo was not ok(200). Putting null into cache " + this.blockingCache.getName() + " with key " + key));
                        }
                        this.blockingCache.put((Serializable)((Object)key), null);
                    }
                }
                catch (Throwable throwable) {
                    this.blockingCache.put((Serializable)((Object)key), null);
                    throw new Exception(throwable);
                }
            }
            finally {
                Thread.currentThread().setName("Application Server Thread");
            }
        }
        return pageInfo;
    }

    protected PageInfo buildPage(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws AlreadyGzippedException, Exception {
        ByteArrayOutputStream outstr = new ByteArrayOutputStream();
        GenericResponseWrapper wrapper = new GenericResponseWrapper(response, outstr);
        chain.doFilter((ServletRequest)request, (ServletResponse)wrapper);
        wrapper.flush();
        return new PageInfo(wrapper.getStatus(), wrapper.getContentType(), wrapper.getHeaders(), wrapper.getCookies(), outstr.toByteArray(), true);
    }

    protected void writeResponse(HttpServletRequest request, HttpServletResponse response, PageInfo pageInfo) throws IOException, DataFormatException, ResponseHeadersNotModifiableException {
        boolean requestAcceptsGzipEncoding = this.acceptsGzipEncoding(request);
        this.setStatus(response, pageInfo);
        this.setHeaders(pageInfo, requestAcceptsGzipEncoding, response);
        this.setCookies(pageInfo, response);
        this.setContentType(response, pageInfo);
        this.writeContent(request, response, pageInfo);
    }

    protected void setContentType(HttpServletResponse response, PageInfo pageInfo) {
        response.setContentType(pageInfo.getContentType());
    }

    protected void setCookies(PageInfo pageInfo, HttpServletResponse response) {
        List cookies = pageInfo.getSerializableCookies();
        Iterator iterator = cookies.iterator();
        while (iterator.hasNext()) {
            Cookie cookie = ((SerializableCookie)iterator.next()).toCookie();
            response.addCookie(cookie);
        }
    }

    protected void setStatus(HttpServletResponse response, PageInfo pageInfo) {
        response.setStatus(pageInfo.getStatusCode());
    }

    protected void setHeaders(PageInfo pageInfo, boolean requestAcceptsGzipEncoding, HttpServletResponse response) {
        List headers = pageInfo.getHeaders();
        boolean header = false;
        boolean value = true;
        Iterator iterator = headers.iterator();
        while (iterator.hasNext()) {
            String[] headerPair = (String[])iterator.next();
            response.addHeader(headerPair[0], headerPair[1]);
        }
    }

    protected abstract String getCacheName();

    protected abstract String calculateKey(HttpServletRequest var1);

    protected void writeContent(HttpServletRequest request, HttpServletResponse response, PageInfo pageInfo) throws IOException, ResponseHeadersNotModifiableException {
        boolean shouldBodyBeZero;
        byte[] body;
        if (this.acceptsGzipEncoding(request)) {
            ResponseUtil.addGzipHeader(response);
            body = pageInfo.getGzippedBody();
            if (ResponseUtil.shouldGzippedBodyBeZero(body, request)) {
                body = new byte[]{};
            }
        } else {
            body = pageInfo.getUngzippedBody();
        }
        if (shouldBodyBeZero = ResponseUtil.shouldBodyBeZero(request, pageInfo.getStatusCode())) {
            body = new byte[]{};
        }
        response.setContentLength(body.length);
        response.getOutputStream().write(body);
    }

    protected void checkNoReentry(HttpServletRequest httpRequest) throws FilterNonReentrantException {
        Thread thread = Thread.currentThread();
        String threadName = thread.getName();
        String filterName = this.getClass().getName();
        if (thread.getName().indexOf(" been through " + filterName) != -1) {
            throw new FilterNonReentrantException("The request thread is attempting to reenter filter " + filterName + ". URL: " + httpRequest.getRequestURL());
        }
        thread.setName(thread.getName() + " been through " + filterName);
        String newThreadName = thread.getName();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Thread name changed from " + threadName + " to " + newThreadName));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

