/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.constructs.blocking;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.constructs.blocking.BlockingCache;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BlockingCacheManager {
    private static final Log LOG = LogFactory.getLog((String)(class$net$sf$ehcache$constructs$blocking$BlockingCacheManager == null ? (class$net$sf$ehcache$constructs$blocking$BlockingCacheManager = BlockingCacheManager.class$("net.sf.ehcache.constructs.blocking.BlockingCacheManager")) : class$net$sf$ehcache$constructs$blocking$BlockingCacheManager).getName());
    private static CacheManager manager;
    protected final Map caches;
    static /* synthetic */ Class class$net$sf$ehcache$constructs$blocking$BlockingCacheManager;

    public BlockingCacheManager() {
        this.caches = new HashMap();
    }

    public BlockingCacheManager(CacheManager mgr) {
        manager = mgr;
        this.caches = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BlockingCache getCache(String name) throws CacheException {
        BlockingCache blockingCache = (BlockingCache)this.caches.get(name);
        if (blockingCache != null) {
            return blockingCache;
        }
        BlockingCacheManager blockingCacheManager = this;
        synchronized (blockingCacheManager) {
            blockingCache = manager == null ? new BlockingCache(name) : new BlockingCache(name, manager);
            this.caches.put(name, blockingCache);
            return blockingCache;
        }
    }

    public void clearAll() throws CacheException {
        List cacheList = this.getCaches();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Removing all blocking caches");
        }
        for (int i = 0; i < cacheList.size(); ++i) {
            BlockingCache cache = (BlockingCache)cacheList.get(i);
            cache.clear();
        }
    }

    public void clear(String name) throws CacheException {
        BlockingCache blockingCache = this.getCache(name);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Clearing " + name));
        }
        blockingCache.clear();
    }

    protected CacheManager getCacheManager() {
        return manager;
    }

    protected void setCacheManager(CacheManager mgr) {
        manager = mgr;
    }

    private synchronized List getCaches() {
        ArrayList blockingCaches = new ArrayList();
        blockingCaches.addAll(this.caches.values());
        return blockingCaches;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

