/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.constructs.blocking;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.constructs.blocking.BlockingCacheException;
import net.sf.ehcache.constructs.concurrent.Mutex;
import net.sf.ehcache.constructs.valueobject.KeyValuePair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BlockingCache {
    private static final Log LOG = LogFactory.getLog((String)(class$net$sf$ehcache$constructs$blocking$BlockingCache == null ? (class$net$sf$ehcache$constructs$blocking$BlockingCache = BlockingCache.class$("net.sf.ehcache.constructs.blocking.BlockingCache")) : class$net$sf$ehcache$constructs$blocking$BlockingCache).getName());
    private final Ehcache cache;
    private final int timeoutMillis;
    private final Map locks = new HashMap();
    static /* synthetic */ Class class$net$sf$ehcache$constructs$blocking$BlockingCache;

    public BlockingCache(String name) throws CacheException {
        this(name, 0);
    }

    public BlockingCache(String name, int timeoutMillis) throws CacheException {
        CacheManager manager = null;
        try {
            manager = CacheManager.create();
        }
        catch (CacheException e) {
            LOG.fatal((Object)("CacheManager cannot be created. Cause was: " + e.getMessage() + e));
            throw new CacheException("CacheManager cannot be created", e);
        }
        this.cache = manager.getCache(name);
        if (this.cache == null || !this.cache.getName().equals(name)) {
            throw new CacheException("Cache " + name + " cannot be retrieved. Please check ehcache.xml");
        }
        this.timeoutMillis = timeoutMillis;
    }

    public BlockingCache(String name, CacheManager manager) throws CacheException {
        this(name, manager, 0);
    }

    public BlockingCache(String name, CacheManager manager, int timeoutMillis) throws CacheException {
        if (manager == null) {
            throw new CacheException("CacheManager cannot be null");
        }
        this.cache = manager.getCache(name);
        if (this.cache == null || !this.cache.getName().equals(name)) {
            throw new CacheException("Cache " + name + " cannot be retrieved. Please check ehcache.xml");
        }
        this.timeoutMillis = timeoutMillis;
    }

    protected Ehcache getCache() {
        return this.cache;
    }

    public String getName() {
        return this.cache.getName();
    }

    public Serializable get(Serializable key) throws BlockingCacheException {
        Mutex lock = this.checkLockExistsForKey(key);
        try {
            if (this.timeoutMillis == 0) {
                lock.acquire();
            } else {
                boolean acquired = lock.attempt(this.timeoutMillis);
                if (!acquired) {
                    StringBuffer message = new StringBuffer("lock timeout attempting to acquire lock for key ").append(key).append(" on cache ").append(this.cache.getName());
                    throw new BlockingCacheException(message.toString());
                }
            }
            Element element = this.cache.get(key);
            if (element != null) {
                lock.release();
                return element.getValue();
            }
            return null;
        }
        catch (InterruptedException e) {
            throw new CacheException("Interrupted. Message was: " + e.getMessage());
        }
    }

    private synchronized Mutex checkLockExistsForKey(Serializable key) {
        Mutex lock = (Mutex)this.locks.get(key);
        if (lock == null) {
            lock = new Mutex();
            this.locks.put(key, lock);
        }
        return lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Serializable key, Serializable value) {
        Mutex lock = this.checkLockExistsForKey(key);
        try {
            if (value != null) {
                Element element = new Element(key, value);
                this.cache.put(element);
            } else {
                this.cache.remove(key);
            }
        }
        finally {
            lock.release();
        }
    }

    public Collection getKeys() throws CacheException {
        return this.cache.getKeys();
    }

    public void clear() throws CacheException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Cache " + this.cache.getName() + ": removing all entries"));
        }
        this.cache.removeAll();
    }

    public synchronized String liveness() {
        return this.getName();
    }

    public List getEntries() throws CacheException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting entries for the " + this.cache.getName() + " cache"));
        }
        List keys = this.cache.getKeys();
        ArrayList<KeyValuePair> keyValuePairs = new ArrayList<KeyValuePair>(keys.size());
        Iterator iterator = keys.iterator();
        while (iterator.hasNext()) {
            Serializable key = (Serializable)iterator.next();
            Element element = this.cache.get(key);
            keyValuePairs.add(new KeyValuePair(key, element.getValue()));
        }
        return keyValuePairs;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

